/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypterException;

public class OAuthCallbackState {
    private static final int CALLBACK_STATE_MAX_AGE_SECS = 600;
    private static final String REAL_CALLBACK_URL_KEY = "u";
    private final BlobCrypter crypter;
    private final Map<String, String> state;

    public OAuthCallbackState(BlobCrypter crypter) {
        this.crypter = crypter;
        this.state = Maps.newHashMap();
    }

    public OAuthCallbackState(BlobCrypter crypter, String stateBlob) {
        this.crypter = crypter;
        Map state = Maps.newHashMap();
        if (stateBlob != null) {
            try {
                state = crypter.unwrap(stateBlob, 600);
            }
            catch (BlobCrypterException e) {
                // empty catch block
            }
        }
        if (state == null) {
            state = Maps.newHashMap();
        }
        this.state = state;
    }

    public String getEncryptedState() throws BlobCrypterException {
        return this.crypter.wrap(this.state);
    }

    public String getRealCallbackUrl() {
        return this.state.get(REAL_CALLBACK_URL_KEY);
    }

    public void setRealCallbackUrl(String realCallbackUrl) {
        this.state.put(REAL_CALLBACK_URL_KEY, realCallbackUrl);
    }
}

