/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.regex.Pattern;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.VersionException;
import org.apache.commons.lang.Validate;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.impl.core.value.BooleanValue;
import org.exoplatform.services.jcr.impl.core.value.DoubleValue;
import org.exoplatform.services.jcr.impl.core.value.LongValue;
import org.exoplatform.services.jcr.impl.core.value.StringValue;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.jcr.JCRSessionManager;
import org.exoplatform.social.common.jcr.LockManager;
import org.exoplatform.social.common.jcr.QueryBuilder;
import org.exoplatform.social.common.jcr.SocialDataLocation;
import org.exoplatform.social.common.jcr.Util;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.service.ProfileConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityStorage {
    private static final Log LOG = ExoLogger.getExoLogger(IdentityStorage.class);
    public static final String IDENTITY_NODETYPE = "exo:identity".intern();
    public static final String PROFILE_NODETYPE = "exo:profile".intern();
    public static final String IDENTITY_REMOTEID = "exo:remoteId".intern();
    public static final String IDENTITY_PROVIDERID = "exo:providerId".intern();
    public static final String PROFILE_IDENTITY = "exo:identity".intern();
    public static final String PROFILE_AVATAR = "avatar".intern();
    public static final String JCR_UUID = "jcr:uuid".intern();
    public static final String REFERENCEABLE_NODE = "mix:referenceable";
    private ProfileConfig config = null;
    private SocialDataLocation dataLocation;
    private JCRSessionManager sessionManager;
    private IdentityManager identityManager;
    private final LockManager lockManager;

    public IdentityStorage(SocialDataLocation dataLocation, LockManager lockManager) {
        this.lockManager = lockManager;
        this.dataLocation = dataLocation;
        this.sessionManager = dataLocation.getSessionManager();
    }

    private Node getIdentityServiceHome(Session session) {
        try {
            String path = this.dataLocation.getSocialIdentityHome();
            Node rootNode = session.getRootNode();
            Util.createNodes((Node)rootNode, (String)path);
            return session.getRootNode().getNode(path);
        }
        catch (PathNotFoundException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private ProfileConfig getConfig() {
        if (this.config == null) {
            PortalContainer container = PortalContainer.getInstance();
            this.config = (ProfileConfig)container.getComponentInstanceOfType(ProfileConfig.class);
        }
        return this.config;
    }

    private Node getProfileServiceHome(Session session) throws Exception {
        String path = this.dataLocation.getSocialProfileHome();
        Node rootNode = session.getRootNode();
        Util.createNodes((Node)rootNode, (String)path);
        return session.getRootNode().getNode(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveIdentity(Identity identity) {
        Identity checkingIdentity = null;
        Lock lock = this.lockManager.getLock("Identity", identity.getRemoteId());
        lock.lock();
        try {
            checkingIdentity = this.findIdentity(identity.getProviderId(), identity.getRemoteId());
            Session session = this.sessionManager.getOrOpenSession();
            try {
                Node identityNode;
                Node identityHomeNode = this.getIdentityServiceHome(session);
                if (identity.getId() == null) {
                    if (checkingIdentity == null) {
                        identityNode = identityHomeNode.addNode(identity.getRemoteId(), IDENTITY_NODETYPE);
                        identityNode.addMixin(REFERENCEABLE_NODE);
                    } else {
                        identityNode = session.getNodeByUUID(checkingIdentity.getId());
                    }
                } else {
                    identityNode = session.getNodeByUUID(identity.getId());
                }
                identityNode.setProperty(IDENTITY_REMOTEID, identity.getRemoteId());
                identityNode.setProperty(IDENTITY_PROVIDERID, identity.getProviderId());
                if (identity.getId() == null) {
                    identityHomeNode.save();
                    identity.setId(identityNode.getUUID());
                } else {
                    identityNode.save();
                }
            }
            catch (Exception e) {
                LOG.error((Object)("failed to save identity " + identity), (Throwable)e);
            }
            finally {
                this.sessionManager.closeSession();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteIdentity(Identity identity) {
        Session session = this.sessionManager.getOrOpenSession();
        try {
            Node identityNode = session.getNodeByUUID(identity.getId());
            if (identity.getProfile().getId() != null) {
                this.deleteProfile(identity.getProfile());
            }
            identityNode.remove();
            session.save();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteProfile(Profile profile) {
        Session session = this.sessionManager.getOrOpenSession();
        try {
            Node profileNode = session.getNodeByUUID(profile.getId());
            profileNode.remove();
            session.save();
        }
        catch (ItemNotFoundException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Identity findIdentityById(String nodeId) {
        Session session = this.sessionManager.getOrOpenSession();
        Identity identity = null;
        Node identityNode = null;
        try {
            identityNode = session.getNodeByUUID(nodeId);
            if (identityNode != null) {
                identity = this.getIdentity(identityNode);
            }
        }
        catch (ItemNotFoundException e) {
            LOG.warn((Object)("can not find identity with nodeId: " + nodeId));
        }
        catch (RepositoryException e) {
            LOG.warn((Object)"failed from repository", (Throwable)e);
        }
        catch (Exception e) {
            LOG.warn((Object)("failed getIdentity by identityNode:" + identityNode), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return identity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<Identity> getAllIdentities() {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        try {
            Session session = this.sessionManager.openSession();
            Node identityHomeNode = this.getIdentityServiceHome(session);
            NodeIterator iter = identityHomeNode.getNodes();
            while (iter.hasNext()) {
                Node identityNode = iter.nextNode();
                Identity identity = this.getIdentity(identityNode);
                identities.add(identity);
            }
            ArrayList<Identity> arrayList = identities;
            return arrayList;
        }
        catch (Exception e) {
            LOG.error((Object)"Error while loading identities", (Throwable)e);
            List<Identity> list = null;
            return list;
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Identity findIdentity(String providerId, String remoteId) {
        Session session = this.sessionManager.openSession();
        Node identityHomeNode = this.getIdentityServiceHome(session);
        Identity identity = null;
        try {
            List nodes = new QueryBuilder(session).select(IDENTITY_NODETYPE).like("jcr:path", identityHomeNode.getPath() + "/%").and().equal(IDENTITY_PROVIDERID, providerId).and().equal(IDENTITY_REMOTEID, remoteId).exec();
            if (nodes.size() == 1) {
                Node identityNode = (Node)nodes.get(0);
                identity = this.getIdentity(identityNode);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("failed to load identity by remote id : " + providerId + ":" + remoteId), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return identity;
    }

    public final Identity getIdentity(Node identityNode) throws Exception {
        Identity identity = new Identity(identityNode.getUUID());
        identity.setProviderId(identityNode.getProperty(IDENTITY_PROVIDERID).getString());
        identity.setRemoteId(identityNode.getProperty(IDENTITY_REMOTEID).getString());
        Profile profile = new Profile(identity);
        this.loadProfile(profile);
        identity.setProfile(profile);
        return identity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Identity> getIdentitiesByProfileFilter(String identityProvider, ProfileFilter profileFilter, long offset, long limit) throws Exception {
        String inputName = profileFilter.getName();
        String userName = this.processUsernameSearchPattern(inputName.trim());
        String position = this.addPositionSearchPattern(profileFilter.getPosition().trim());
        String gender = profileFilter.getGender().trim();
        inputName = inputName == "" || inputName.length() == 0 ? "*" : inputName;
        String nameForSearch = inputName.replace("*", " ");
        String[] nameParts = nameForSearch.trim().split(" ");
        ArrayList<Identity> listIdentity = new ArrayList<Identity>();
        List nodes = null;
        try {
            Session session = this.sessionManager.getOrOpenSession();
            Node profileHomeNode = this.getProfileServiceHome(session);
            QueryBuilder queryBuilder = new QueryBuilder(session).select(PROFILE_NODETYPE, offset, limit).like("jcr:path", profileHomeNode.getPath() + "[%]/%");
            for (String namePart : nameParts) {
                if (namePart == "") continue;
                queryBuilder.or().like(queryBuilder.lower("firstName"), namePart.toLowerCase() + "%");
                queryBuilder.or().like(queryBuilder.lower("lastName"), namePart.toLowerCase() + "%");
            }
            if (position.length() != 0) {
                queryBuilder.and().contains("position", position);
            }
            if (gender.length() != 0) {
                queryBuilder.and().equal("gender", gender);
            }
            queryBuilder.orderBy("firstName", "ASC");
            nodes = queryBuilder.exec();
            for (Node profileNode : nodes) {
                Node identityNode = profileNode.getProperty(PROFILE_IDENTITY).getNode();
                Identity identity = this.getIdentityManager().getIdentity(identityNode.getUUID(), false);
                if (!identity.getProviderId().equals(identityProvider)) continue;
                if (userName.length() != 0) {
                    String fullUserName = identity.getProfile().getFullName();
                    String fullNameLC = fullUserName.toLowerCase();
                    String userNameLC = userName.toLowerCase();
                    if (userNameLC.length() == 0 || !fullNameLC.matches(userNameLC)) continue;
                    listIdentity.add(identity);
                    continue;
                }
                listIdentity.add(identity);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("error while filtering identities: " + e.getMessage()));
            ArrayList<Identity> arrayList = new ArrayList<Identity>();
            return arrayList;
        }
        finally {
            this.sessionManager.closeSession();
        }
        return listIdentity;
    }

    private String addPositionSearchPattern(String position) {
        if (position.length() != 0) {
            if (position.indexOf("*") == -1) {
                return "*" + position + "*";
            }
            return position;
        }
        return "";
    }

    private String processUsernameSearchPattern(String userName) {
        if (userName.length() > 0) {
            userName = "".equals(userName) || userName.length() == 0 ? "*" : userName;
            userName = userName.charAt(0) != '*' ? "*" + userName : userName;
            userName = userName.charAt(userName.length() - 1) != '*' ? (userName = userName + "*") : userName;
            userName = userName.indexOf("*") >= 0 ? userName.replace("*", ".*") : userName;
            userName = userName.indexOf("%") >= 0 ? userName.replace("%", ".*") : userName;
            Pattern.compile(userName);
        }
        return userName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<Identity> getIdentitiesFilterByAlphaBet(String identityProvider, ProfileFilter profileFilter, long offset, long limit) throws Exception {
        ArrayList<Identity> listIdentity = new ArrayList<Identity>();
        List nodes = null;
        try {
            Session session = this.sessionManager.getOrOpenSession();
            Node profileHomeNode = this.getProfileServiceHome(session);
            QueryBuilder queryBuilder = new QueryBuilder(session);
            queryBuilder.select(PROFILE_NODETYPE, offset, limit).like("jcr:path", profileHomeNode.getPath() + "/%");
            String userName = profileFilter.getName();
            if (userName.length() != 0) {
                queryBuilder.and().like(queryBuilder.lower("firstName"), userName.toLowerCase() + "%");
            }
            queryBuilder.orderBy("firstName", "ASC");
            nodes = queryBuilder.exec();
            for (Node profileNode : nodes) {
                Node identityNode = profileNode.getProperty(PROFILE_IDENTITY).getNode();
                Identity identity = this.getIdentityManager().getIdentity(identityNode.getUUID(), false);
                if (!identity.getProviderId().equals(identityProvider)) continue;
                listIdentity.add(identity);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to filter identities by alphabet" + e.getMessage()));
            List<Identity> list = null;
            return list;
        }
        finally {
            this.sessionManager.closeSession();
        }
        return listIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveProfile(Profile profile) {
        try {
            Session session = this.sessionManager.getOrOpenSession();
            Node profileHomeNode = this.getProfileServiceHome(session);
            if (profile.getIdentity().getId() == null) {
                LOG.warn((Object)"the identity has to be saved before saving the profile");
                return;
            }
            Lock lock = this.lockManager.getLock("Profile", profile.getIdentity().getId());
            lock.lock();
            try {
                Node profileNode;
                if (profile.getId() == null) {
                    profileNode = profileHomeNode.addNode(profile.getIdentity().getId(), PROFILE_NODETYPE);
                    profileNode.addMixin(REFERENCEABLE_NODE);
                    Node identityNode = session.getNodeByUUID(profile.getIdentity().getId());
                    profileNode.setProperty(PROFILE_IDENTITY, identityNode);
                    profileNode.setProperty("jcr:lastModified", Calendar.getInstance());
                    profileHomeNode.save();
                } else {
                    profileNode = session.getNodeByUUID(profile.getId());
                }
                this.saveProfile(profile, profileNode, session);
                if (profile.getId() == null) {
                    profileHomeNode.save();
                    profile.setId(profileNode.getUUID());
                } else {
                    profileNode.save();
                }
            }
            finally {
                lock.unlock();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to save profile " + profile), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void saveProfile(Profile profile, Node profileNode, Session session) throws Exception, IOException {
        Lock lock = this.lockManager.getLock("Profile", profile.getIdentity().getId());
        lock.lock();
        try {
            long lastLoaded = profile.getLastLoaded();
            long lastPersisted = 0L;
            if (profileNode.hasProperty("jcr:lastModified")) {
                lastPersisted = profileNode.getProperty("jcr:lastModified").getLong();
            }
            if (!profile.hasChanged() && lastPersisted > 0L && lastPersisted <= lastLoaded) {
                return;
            }
            profile.clearHasChanged();
            Calendar date = Calendar.getInstance();
            profileNode.setProperty("jcr:lastModified", date);
            profile.setLastLoaded(date.getTimeInMillis());
            Profile oldProfile = new Profile(profile.getIdentity());
            this.loadProfile(oldProfile, profileNode, session.getWorkspace().getName());
            for (String key : oldProfile.getProperties().keySet()) {
                if (profile.contains(key)) continue;
                if (profileNode.hasProperty(key)) {
                    profileNode.getProperty(key).remove();
                    continue;
                }
                if (!profileNode.hasNode(key)) continue;
                profileNode.getNode(key).remove();
            }
            this.addOrModifyProfileProperties(profile, profileNode, session);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addOrModifyProfileProperties(Profile profile) throws Exception {
        Validate.notNull((Object)profile.getId(), (String)"profile.getId() must be not null.");
        try {
            Session session = this.sessionManager.getOrOpenSession();
            Node profileNode = session.getNodeByUUID(profile.getId());
            this.addOrModifyProfileProperties(profile, profileNode, session);
            profileNode.save();
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdentitiesCount(String providerId) {
        Session session = this.sessionManager.getOrOpenSession();
        int count = 0;
        Node identityHomeNode = this.getIdentityServiceHome(session);
        try {
            count = (int)new QueryBuilder(session).select(IDENTITY_NODETYPE).like("jcr:path", identityHomeNode.getPath() + "/%").and().equal(IDENTITY_PROVIDERID, providerId).count();
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addOrModifyProfileProperties(Profile profile, Node profileNode, Session session) throws Exception {
        Map<String, Object> props = profile.getProperties();
        Iterator<Map.Entry<String, Object>> it = props.entrySet().iterator();
        Lock lock = this.lockManager.getLock("Profile", profile.getIdentity().getId());
        lock.lock();
        try {
            while (it.hasNext()) {
                Map.Entry<String, Object> entry = it.next();
                String key = entry.getKey();
                if (key.contains(":")) continue;
                this.setProperty(profileNode, session, key, entry.getValue());
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void setProperty(Node profileNode, Session session, String name, Object value) throws Exception {
        if (this.isForcedMultiValue(name)) {
            if (value instanceof String) {
                value = new String[]{(String)value};
            }
            this.setProperty(name, value, profileNode);
        } else if (value instanceof String) {
            profileNode.setProperty(name, (String)value);
        } else if (value instanceof Double) {
            profileNode.setProperty(name, ((Double)value).doubleValue());
        } else if (value instanceof Boolean) {
            profileNode.setProperty(name, ((Boolean)value).booleanValue());
        } else if (value instanceof Long) {
            profileNode.setProperty(name, ((Long)value).longValue());
        } else if (value instanceof String[]) {
            String[] strings = value;
            if (strings.length == 1) {
                profileNode.setProperty(name, strings[0]);
            } else {
                this.setProperty(name, strings, profileNode);
            }
        } else if (value instanceof List) {
            this.setProperty(name, (List)value, profileNode, session);
        } else if (value instanceof AvatarAttachment) {
            this.saveAvatarAttachment(profileNode, session, name, (AvatarAttachment)value);
        }
    }

    private void saveAvatarAttachment(Node profileNode, Session session, String name, AvatarAttachment profileAtt) throws Exception {
        ExtendedNode extNode = (ExtendedNode)profileNode;
        if (extNode.canAddMixin("exo:privilegeable")) {
            extNode.addMixin("exo:privilegeable");
        }
        String[] arrayPers = new String[]{"read", "add_node", "set_property", "remove"};
        extNode.setPermission(SystemIdentity.ANY, arrayPers);
        List permsList = extNode.getACL().getPermissionEntries();
        for (AccessControlEntry accessControlEntry : permsList) {
            extNode.setPermission(accessControlEntry.getIdentity(), arrayPers);
        }
        if (profileAtt.getFileName() != null) {
            Node nodeContent;
            Node nodeFile;
            try {
                nodeFile = profileNode.getNode(name);
            }
            catch (PathNotFoundException ex) {
                nodeFile = profileNode.addNode(name, "nt:file");
            }
            try {
                nodeContent = nodeFile.getNode("jcr:content");
            }
            catch (PathNotFoundException ex) {
                nodeContent = nodeFile.addNode("jcr:content", "nt:resource");
            }
            long lastModified = profileAtt.getLastModified();
            long lastSaveTime = 0L;
            if (nodeContent.hasProperty("jcr:lastModified")) {
                lastSaveTime = nodeContent.getProperty("jcr:lastModified").getLong();
            }
            if (lastModified != 0L && lastModified != lastSaveTime) {
                nodeContent.setProperty("jcr:mimeType", profileAtt.getMimeType());
                nodeContent.setProperty("jcr:data", profileAtt.getInputStream(session));
                nodeContent.setProperty("jcr:lastModified", profileAtt.getLastModified());
            }
        } else if (profileNode.hasNode(name)) {
            profileNode.getNode(name).remove();
            profileNode.save();
        }
    }

    private void setProperty(String name, List<Map<String, Object>> props, Node n, Session session) throws Exception {
        String ntName = this.getNodeTypeName(name);
        if (ntName == null) {
            throw new Exception("no nodeType is defined for " + name);
        }
        NodeIterator nIt = n.getNodes(name);
        while (nIt.hasNext()) {
            Node currNode = nIt.nextNode();
            currNode.remove();
        }
        n.save();
        for (Map<String, Object> prop : props) {
            Node propNode = n.addNode(name, ntName);
            for (Map.Entry<String, Object> entry : prop.entrySet()) {
                String key = entry.getKey();
                Object propValue = entry.getValue();
                if (propValue == null) continue;
                if (propValue instanceof String) {
                    propNode.setProperty(key, (String)propValue);
                    continue;
                }
                if (propValue instanceof Double) {
                    propNode.setProperty(key, ((Double)propValue).doubleValue());
                    continue;
                }
                if (propValue instanceof Boolean) {
                    propNode.setProperty(key, ((Boolean)propValue).booleanValue());
                    continue;
                }
                if (propValue instanceof Long) {
                    propNode.setProperty(key, ((Long)propValue).longValue());
                    continue;
                }
                LOG.warn((Object)("Type of property does not support!" + propValue));
            }
        }
    }

    private void setProperty(String name, String[] propValue, Node n) throws IOException, RepositoryException, ConstraintViolationException, VersionException {
        ArrayList<StringValue> values = new ArrayList<StringValue>();
        for (String value : propValue) {
            if (value == null || value.length() <= 0) continue;
            values.add(new StringValue(value));
        }
        n.setProperty(name, values.toArray(new Value[values.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadProfile(Profile profile) {
        if (profile.getIdentity().getId() == null) {
            LOG.warn((Object)"Failed to load profile. The identity has to be saved before loading the profile");
            return;
        }
        Session session = this.sessionManager.getOrOpenSession();
        try {
            Node identityNode = session.getNodeByUUID(profile.getIdentity().getId());
            String workspaceName = session.getWorkspace().getName();
            PropertyIterator references = identityNode.getReferences();
            if (references.getSize() == 0L) {
                this.saveProfile(profile);
            } else {
                while (references.hasNext()) {
                    Property nodeReferencedProperty = (Property)references.next();
                    if (!nodeReferencedProperty.getParent().isNodeType(PROFILE_NODETYPE)) continue;
                    Node profileNode = nodeReferencedProperty.getParent();
                    profile.setId(profileNode.getUUID());
                    this.loadProfile(profile, profileNode, workspaceName);
                }
            }
        }
        catch (ItemNotFoundException e) {
            LOG.warn((Object)"Cannot load profile. The identity has been deleted.");
        }
        catch (RepositoryException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    protected final boolean isForcedMultiValue(String key) {
        return this.getConfig().isForcedMultiValue(key);
    }

    protected final String getNodeTypeName(String nodeName) {
        return this.getConfig().getNodeType(nodeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void loadProfile(Profile profile, Node profileNode, String workspaceName) throws RepositoryException {
        Lock lock = this.lockManager.getLock("Profile", profile.getIdentity().getId());
        lock.lock();
        try {
            String nodeName;
            Node node;
            long lastLoaded = profile.getLastLoaded();
            long lastPersisted = 0L;
            if (profileNode.hasProperty("jcr:lastModified")) {
                lastPersisted = profileNode.getProperty("jcr:lastModified").getLong();
            } else {
                profileNode.setProperty("jcr:lastModified", Calendar.getInstance());
                profileNode.save();
            }
            if (lastPersisted > 0L && lastPersisted <= lastLoaded) {
                return;
            }
            boolean hasChanged = profile.hasChanged();
            Calendar date = Calendar.getInstance();
            profile.setLastLoaded(date.getTimeInMillis());
            PropertyIterator props = profileNode.getProperties();
            this.copyPropertiesToMap(props, profile.getProperties());
            NodeIterator it = profileNode.getNodes();
            while (it.hasNext()) {
                node = it.nextNode();
                nodeName = node.getName();
                while (profile.contains(nodeName)) {
                    profile.removeProperty(nodeName);
                }
            }
            it = profileNode.getNodes();
            while (it.hasNext()) {
                node = it.nextNode();
                nodeName = node.getName();
                if (nodeName.equals(PROFILE_AVATAR) || nodeName.startsWith(PROFILE_AVATAR + "_")) {
                    if (!node.isNodeType("nt:file")) continue;
                    AvatarAttachment file = new AvatarAttachment();
                    file.setId(node.getPath());
                    file.setMimeType(node.getNode("jcr:content").getProperty("jcr:mimeType").getString());
                    try {
                        file.setInputStream(node.getNode("jcr:content").getProperty("jcr:data").getValue().getStream());
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Failed to load data for avatar of " + profile + ": " + e.getMessage()));
                    }
                    file.setLastModified(node.getNode("jcr:content").getProperty("jcr:lastModified").getLong());
                    file.setFileName(nodeName);
                    file.setWorkspace(workspaceName);
                    profile.setProperty(nodeName, file);
                    continue;
                }
                ArrayList<Map<String, Object>> l = (ArrayList<Map<String, Object>>)profile.getProperty(nodeName);
                if (l == null) {
                    l = new ArrayList<Map<String, Object>>();
                }
                l.add(this.copyPropertiesToMap(node.getProperties(), null));
                profile.setProperty(nodeName, l);
            }
            if (!hasChanged) {
                profile.clearHasChanged();
            }
        }
        finally {
            lock.unlock();
        }
    }

    private Map<String, Object> copyPropertiesToMap(PropertyIterator props, Map<String, Object> map) throws RepositoryException {
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        while (props.hasNext()) {
            Property prop = (Property)props.next();
            String name = prop.getName();
            if (name.contains(":")) continue;
            try {
                Value value = prop.getValue();
                if (value instanceof StringValue) {
                    map.put(name, value.getString());
                    continue;
                }
                if (value instanceof LongValue) {
                    map.put(name, value.getLong());
                    continue;
                }
                if (value instanceof DoubleValue) {
                    map.put(name, value.getDouble());
                    continue;
                }
                if (!(value instanceof BooleanValue)) continue;
                map.put(name, value.getBoolean());
            }
            catch (ValueFormatException e) {
                Value[] values = prop.getValues();
                ArrayList<String> res = new ArrayList<String>();
                for (Value value : values) {
                    res.add(value.getString());
                }
                map.put(name, res.toArray(new String[res.size()]));
            }
        }
        return map;
    }

    private IdentityManager getIdentityManager() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (this.identityManager == null) {
            this.identityManager = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        }
        return this.identityManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getType(String nodetype, String property) throws Exception {
        try {
            PropertyDefinition[] pDefs;
            Session session = this.sessionManager.openSession();
            NodeTypeManager ntManager = session.getWorkspace().getNodeTypeManager();
            NodeType nt = ntManager.getNodeType(nodetype);
            for (PropertyDefinition pDef : pDefs = nt.getDeclaredPropertyDefinitions()) {
                if (!pDef.getName().equals(property)) continue;
                String string = PropertyType.nameFromValue((int)pDef.getRequiredType());
                return string;
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Could not find type of property " + property + " for nodetype " + nodetype));
            String string = null;
            return string;
        }
        finally {
            this.sessionManager.closeSession();
        }
        return null;
    }
}

