/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.proccess;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkerService {
    private final ScheduledThreadPoolExecutor executor;

    public WorkerService(int threadCount) {
        this.executor = new ScheduledThreadPoolExecutor(threadCount);
    }

    public WorkerService(int threadCount, String threadNamePrefix) {
        this.executor = new ScheduledThreadPoolExecutor(threadCount, new WorkerThreadFactory(threadNamePrefix));
    }

    public WorkerService(int threadCount, String threadNamePrefix, boolean makeThreadsDaemon) {
        this.executor = new ScheduledThreadPoolExecutor(threadCount, new WorkerThreadFactory(threadNamePrefix, makeThreadsDaemon));
    }

    public ScheduledFuture<?> executePeriodically(Runnable command, long delay) {
        return this.executor.scheduleWithFixedDelay(command, 0L, delay, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        this.executor.shutdown();
    }

    static class WorkerThreadFactory
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;
        final boolean isDaemon;

        WorkerThreadFactory(String namePrefix) {
            this(namePrefix, false);
        }

        WorkerThreadFactory(String namePrefix, boolean isDaemon) {
            this.isDaemon = isDaemon;
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = namePrefix + "-" + poolNumber.getAndIncrement() + "-thread-";
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(this.isDaemon);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

