/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.manager;

import java.io.Serializable;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.identity.IdentityProvider;
import org.exoplatform.social.core.identity.model.GlobalId;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManagerImpl;
import org.exoplatform.social.core.storage.IdentityStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingIdentityManager
extends IdentityManagerImpl {
    private static final Log LOG = ExoLogger.getExoLogger(CachingIdentityManager.class);
    private ExoCache<String, Identity> identityCacheById;
    private ExoCache<GlobalId, Identity> identityCache;
    private ExoCache<String, List<Identity>> identityListCache;

    public CachingIdentityManager(IdentityStorage identityStorage, IdentityProvider<?> defaultIdentityProvider, CacheService cacheService) {
        super(identityStorage, defaultIdentityProvider);
        this.identityCacheById = cacheService.getCacheInstance(this.getClass().getName() + "identityCacheById");
        this.identityCache = cacheService.getCacheInstance(this.getClass().getName() + "identityCache");
        this.identityListCache = cacheService.getCacheInstance(this.getClass().getName() + "identityListCache");
    }

    @Override
    public Identity getIdentity(String id, boolean loadProfile) {
        Identity cachedIdentity = null;
        if (GlobalId.isValid(id)) {
            GlobalId globalId = new GlobalId(id);
            String providerId = globalId.getDomain();
            String remoteId = globalId.getLocalId();
            cachedIdentity = (Identity)this.identityCache.get((Serializable)globalId);
            if (cachedIdentity == null) {
                cachedIdentity = this.getOrCreateIdentity(providerId, remoteId, loadProfile);
                if (cachedIdentity != null) {
                    this.identityCache.put((Serializable)globalId, (Object)cachedIdentity);
                    return cachedIdentity;
                }
                if (cachedIdentity == null) {
                    String tempId = globalId.getLocalId();
                    cachedIdentity = this.getIdentityStorage().findIdentityById(tempId);
                    if (cachedIdentity != null) {
                        id = tempId;
                    }
                }
            }
        } else {
            cachedIdentity = (Identity)this.identityCacheById.get((Serializable)((Object)id));
            if (cachedIdentity == null) {
                cachedIdentity = this.getIdentityStorage().findIdentityById(id);
            }
        }
        if (cachedIdentity != null) {
            if (loadProfile) {
                this.getIdentityStorage().loadProfile(cachedIdentity.getProfile());
                if (cachedIdentity.getProfile().getFullName().isEmpty()) {
                    this.updateProfileIfNeeded(cachedIdentity);
                }
            }
            this.identityCacheById.put((Serializable)((Object)id), (Object)cachedIdentity);
        }
        if (cachedIdentity == null) {
            LOG.info((Object)("Can not get identity with id: " + id));
        }
        return cachedIdentity;
    }

    @Override
    public Identity getIdentity(String providerId, String remoteId, boolean loadProfile) {
        GlobalId globalIdCacheKey = GlobalId.create(providerId, remoteId);
        Identity cachedIdentity = (Identity)this.identityCache.get((Serializable)globalIdCacheKey);
        if (cachedIdentity == null) {
            IdentityProvider<?> identityProvider = this.getIdentityProvider(providerId);
            cachedIdentity = identityProvider.getIdentityByRemoteId(remoteId);
            if (cachedIdentity != null) {
                Identity storedIdentity = this.getIdentityStorage().findIdentity(providerId, remoteId);
                if (storedIdentity != null) {
                    cachedIdentity.setId(storedIdentity.getId());
                } else {
                    this.getIdentityStorage().saveIdentity(cachedIdentity);
                }
            }
            this.identityCache.put((Serializable)globalIdCacheKey, (Object)cachedIdentity);
        }
        if (loadProfile && cachedIdentity.getProfile().getId() == null) {
            this.getIdentityStorage().loadProfile(cachedIdentity.getProfile());
            if (cachedIdentity.getProfile().getFullName().isEmpty()) {
                this.updateProfileIfNeeded(cachedIdentity);
            }
        }
        return cachedIdentity;
    }

    @Override
    public void deleteIdentity(Identity identity) {
        if (identity.getId() == null) {
            LOG.warn((Object)("identity.getId() must not be null of [" + identity + "]"));
            return;
        }
        this.getIdentityStorage().deleteIdentity(identity);
        this.identityCacheById.remove((Serializable)((Object)identity.getId()));
        this.identityCache.remove((Serializable)identity.getGlobalId());
        this.identityListCache.remove((Serializable)((Object)identity.getProviderId()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Identity getOrCreateIdentity(String providerId, String remoteId, boolean loadProfile) {
        GlobalId globalIdCacheKey = GlobalId.create(providerId, remoteId);
        Identity cachedIdentity = (Identity)this.identityCache.get((Serializable)globalIdCacheKey);
        if (cachedIdentity == null) {
            IdentityProvider<?> identityProvider = this.getIdentityProvider(providerId);
            Identity identity1 = identityProvider.getIdentityByRemoteId(remoteId);
            Identity result = this.getIdentityStorage().findIdentity(providerId, remoteId);
            if (result == null) {
                if (identity1 == null) return result;
                this.saveIdentity(identity1);
                this.getIdentityStorage().saveProfile(identity1.getProfile());
                result = identity1;
            } else {
                if (identity1 == null) {
                    this.getIdentityStorage().deleteIdentity(result);
                    return null;
                }
                if (loadProfile) {
                    this.getIdentityStorage().loadProfile(result.getProfile());
                    if (result.getProfile().getFullName().isEmpty()) {
                        this.updateProfileIfNeeded(result);
                    }
                }
            }
            cachedIdentity = result;
            if (cachedIdentity.getId() == null) return cachedIdentity;
            this.identityCache.put((Serializable)globalIdCacheKey, (Object)cachedIdentity);
            return cachedIdentity;
        } else {
            if (!loadProfile || cachedIdentity.getProfile().getId() != null) return cachedIdentity;
            this.getIdentityStorage().loadProfile(cachedIdentity.getProfile());
            if (!cachedIdentity.getProfile().getFullName().isEmpty()) return cachedIdentity;
            this.updateProfileIfNeeded(cachedIdentity);
        }
        return cachedIdentity;
    }

    @Override
    public void saveIdentity(Identity identity) {
        this.getIdentityStorage().saveIdentity(identity);
        this.getIdentityProvider(identity.getProviderId()).onSaveIdentity(identity);
        if (identity.getId() != null) {
            this.identityCacheById.remove((Serializable)((Object)identity.getId()));
            this.identityCache.remove((Serializable)identity.getGlobalId());
        }
        this.identityListCache.remove((Serializable)((Object)identity.getProviderId()));
    }

    private void removeCacheForProfileChange(Profile profile) {
        Identity identity = profile.getIdentity();
        this.identityCacheById.remove((Serializable)((Object)identity.getId()));
        this.identityCache.remove((Serializable)profile.getIdentity().getGlobalId());
        this.identityListCache.remove((Serializable)((Object)identity.getProviderId()));
    }

    @Override
    public void saveProfile(Profile profile) {
        this.getIdentityStorage().saveProfile(profile);
        this.getIdentityProvider(profile.getIdentity().getProviderId()).onSaveProfile(profile);
        this.removeCacheForProfileChange(profile);
    }

    @Override
    public void addOrModifyProfileProperties(Profile profile) throws Exception {
        this.getIdentityStorage().addOrModifyProfileProperties(profile);
        this.getIdentityProvider(profile.getIdentity().getProviderId()).onSaveProfile(profile);
        this.removeCacheForProfileChange(profile);
    }

    private void updateProfileIfNeeded(Identity identity) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        String userName = identity.getRemoteId();
        Profile profile = identity.getProfile();
        if (profile.getId() == null) {
            return;
        }
        try {
            OrganizationService service = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
            User user = service.getUserHandler().findUserByName(userName);
            boolean hasChanged = false;
            if (!user.getFirstName().equals((String)profile.getProperty("firstName"))) {
                profile.setProperty("firstName", user.getFirstName());
                hasChanged = true;
            }
            if (!user.getLastName().equals((String)profile.getProperty("lastName"))) {
                profile.setProperty("lastName", user.getLastName());
                hasChanged = true;
            }
            if (!user.getEmail().equals((String)profile.getProperty("lastName"))) {
                profile.setProperty("lastName", user.getLastName());
                hasChanged = true;
            }
            if (hasChanged) {
                this.saveProfile(profile);
                identity.setProfile(profile);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Problems in reseting profile information", (Throwable)e);
        }
    }
}

