/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.manager;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.RelationshipLifeCycle;
import org.exoplatform.social.core.relationship.RelationshipListener;
import org.exoplatform.social.core.relationship.RelationshipListenerPlugin;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.storage.RelationshipStorage;
import org.exoplatform.social.core.storage.RelationshipStorageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipManagerImpl
implements RelationshipManager {
    protected RelationshipStorage storage;
    protected RelationshipLifeCycle lifeCycle = new RelationshipLifeCycle();
    private IdentityManager identityManager;

    public RelationshipManagerImpl(RelationshipStorage relationshipStorage) {
        this.storage = relationshipStorage;
    }

    @Override
    public Relationship get(String relationshipId) {
        Relationship relationship = null;
        try {
            relationship = this.storage.getRelationship(relationshipId);
        }
        catch (Exception e) {
            return null;
        }
        return relationship;
    }

    @Override
    public Relationship invite(Identity sender, Identity receiver) throws RelationshipStorageException {
        Relationship relationship = this.get(sender, receiver);
        if (relationship == null) {
            relationship = new Relationship(sender, receiver);
        }
        relationship.setStatus(Relationship.Type.PENDING);
        this.save(relationship);
        this.lifeCycle.relationshipRequested(this, relationship);
        return relationship;
    }

    @Override
    public void save(Relationship relationship) throws RelationshipStorageException {
        String receiverId;
        Identity sender = relationship.getSender();
        Identity receiver = relationship.getReceiver();
        String senderId = sender.getId();
        if (senderId.equals(receiverId = receiver.getId())) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.FAILED_TO_SAVE_RELATIONSHIP, "the two identity are the same");
        }
        this.storage.saveRelationship(relationship);
    }

    @Override
    public void confirm(Relationship relationship) throws RelationshipStorageException {
        relationship.setStatus(Relationship.Type.CONFIRMED);
        this.save(relationship);
        this.lifeCycle.relationshipConfirmed(this, relationship);
    }

    @Override
    public void deny(Relationship relationship) throws RelationshipStorageException {
        this.remove(relationship);
        this.lifeCycle.relationshipDenied(this, relationship);
    }

    @Override
    public void remove(Relationship relationship) throws RelationshipStorageException {
        this.storage.removeRelationship(relationship);
        this.lifeCycle.relationshipRemoved(this, relationship);
    }

    @Override
    public void ignore(Relationship relationship) throws RelationshipStorageException {
        this.remove(relationship);
        this.lifeCycle.relationshipIgnored(this, relationship);
    }

    @Override
    public List<Relationship> getPending(Identity sender) throws RelationshipStorageException {
        return this.getSender(sender, Relationship.Type.PENDING, null);
    }

    @Override
    public List<Relationship> getPending(Identity sender, List<Identity> identities) throws RelationshipStorageException {
        return this.getSender(sender, Relationship.Type.PENDING, identities);
    }

    @Override
    public List<Relationship> getIncoming(Identity receiver) throws RelationshipStorageException {
        return this.getReceiver(receiver, Relationship.Type.PENDING, null);
    }

    @Override
    public List<Relationship> getIncoming(Identity receiver, List<Identity> identities) throws RelationshipStorageException {
        return this.getReceiver(receiver, Relationship.Type.PENDING, identities);
    }

    @Override
    public List<Relationship> getConfirmed(Identity identity) throws RelationshipStorageException {
        return this.getRelationships(identity, Relationship.Type.CONFIRMED, null);
    }

    @Override
    public List<Relationship> getConfirmed(Identity identity, List<Identity> identities) throws RelationshipStorageException {
        return this.getRelationships(identity, Relationship.Type.CONFIRMED, identities);
    }

    @Override
    public List<Relationship> getAll(Identity identity) throws RelationshipStorageException {
        return this.getRelationships(identity, null, null);
    }

    @Override
    public List<Relationship> getAll(Identity identity, List<Identity> identities) throws RelationshipStorageException {
        return this.getRelationships(identity, null, identities);
    }

    @Override
    public List<Relationship> getAll(Identity identity, Relationship.Type type, List<Identity> identities) throws RelationshipStorageException {
        return this.getRelationships(identity, type, identities);
    }

    @Override
    public Relationship get(Identity identity1, Identity identity2) throws RelationshipStorageException {
        return this.storage.getRelationship(identity1, identity2);
    }

    @Override
    public Relationship.Type getStatus(Identity identity1, Identity identity2) throws RelationshipStorageException {
        Relationship relationship = this.get(identity1, identity2);
        return relationship == null ? null : relationship.getStatus();
    }

    public void registerListener(RelationshipListener listener) {
        this.lifeCycle.addListener(listener);
    }

    public void unregisterListener(RelationshipListener listener) {
        this.lifeCycle.removeListener(listener);
    }

    public void addListenerPlugin(RelationshipListenerPlugin plugin) {
        this.registerListener(plugin);
    }

    protected RelationshipStorage getStorage() {
        return this.storage;
    }

    protected void setStorage(RelationshipStorage storage) {
        this.storage = storage;
    }

    protected RelationshipLifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    protected void setLifeCycle(RelationshipLifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    protected List<Relationship> getRelationships(Identity identity, Relationship.Type type, List<Identity> identities) throws RelationshipStorageException {
        return this.storage.getRelationships(identity, type, identities);
    }

    protected List<Relationship> getSender(Identity sender, Relationship.Type type, List<Identity> identities) throws RelationshipStorageException {
        return this.storage.getSenderRelationships(sender, type, identities);
    }

    protected List<Relationship> getReceiver(Identity receiver, Relationship.Type type, List<Identity> identities) throws RelationshipStorageException {
        return this.storage.getReceiverRelationships(receiver, type, identities);
    }

    @Override
    public Relationship create(Identity sender, Identity receiver) {
        return new Relationship(sender, receiver);
    }

    @Override
    public List<Identity> findRelationships(Identity ownerIdentity, Relationship.Type relationshipType) throws Exception {
        List<Relationship> allRelationships = this.getAll(ownerIdentity, relationshipType, null);
        ArrayList<Identity> identities = new ArrayList<Identity>();
        if (allRelationships == null || allRelationships.size() == 0) {
            return identities;
        }
        for (Relationship relationship : allRelationships) {
            identities.add(relationship.getPartner(ownerIdentity));
        }
        return identities;
    }

    @Override
    public List<Relationship> findRoute(Identity sender, Identity receiver) throws Exception {
        ArrayList<Relationship> route = new ArrayList<Relationship>();
        route.add(this.get(sender, receiver));
        return route;
    }

    @Override
    public Relationship.Type getConnectionStatus(Identity fromIdentity, Identity toIdentity) throws Exception {
        return this.getStatus(fromIdentity, toIdentity);
    }

    @Override
    public List<Relationship> getContacts(Identity currIdentity, List<Identity> identities) throws Exception {
        return this.getAll(currIdentity, Relationship.Type.CONFIRMED, identities);
    }

    @Override
    public List<Relationship> getContacts(Identity identity) throws Exception {
        return this.getAll(identity, Relationship.Type.CONFIRMED, null);
    }

    @Override
    public List<Identity> getIdentities(Identity id) throws Exception {
        return this.getIdentityManager().getConnections(id);
    }

    @Override
    public List<Relationship> getPendingRelationships(Identity identity) throws Exception {
        return this.getPending(identity);
    }

    @Override
    public List<Relationship> getPendingRelationships(Identity identity, boolean toConfirm) throws Exception {
        return this.getAll(identity, Relationship.Type.PENDING, null);
    }

    @Override
    public List<Relationship> getPendingRelationships(Identity currIdentity, List<Identity> identities, boolean toConfirm) throws Exception {
        return this.getAll(currIdentity, Relationship.Type.PENDING, identities);
    }

    @Override
    public Relationship getRelationship(Identity sender, Identity receiver) throws Exception {
        return this.get(sender, receiver);
    }

    @Override
    public Relationship getRelationshipById(String id) throws Exception {
        return this.get(id);
    }

    @Override
    public Relationship.Type getRelationshipStatus(Relationship rel, Identity id) {
        return rel.getStatus();
    }

    @Override
    public List<Relationship> getRelationshipsByIdentityId(String id) throws Exception {
        return this.getAll(this.getIdentityManager().getIdentity(id));
    }

    private IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            this.identityManager = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
        }
        return this.identityManager;
    }

    @Override
    public void saveRelationship(Relationship relationship) throws Exception {
        this.save(relationship);
    }

    @Override
    public List<Relationship> getAllRelationships(Identity identity) throws Exception {
        return this.getAll(identity);
    }
}

