/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.profile;

import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.webui.IdentityListAccess;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.profile.UIProfileUserSearch;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="classpath:groovy/social/webui/profile/UIDisplayProfileList.gtmpl", events={@EventConfig(listeners={AddContactActionListener.class}), @EventConfig(listeners={AcceptContactActionListener.class}), @EventConfig(listeners={DenyContactActionListener.class}), @EventConfig(listeners={SearchActionListener.class}, phase=Event.Phase.DECODE)})
public class UIDisplayProfileList
extends UIContainer {
    private static final String INVITATION_REVOKED_INFO = "UIDisplayProfileList.label.RevokedInfo";
    private static final String INVITATION_ESTABLISHED_INFO = "UIDisplayProfileList.label.InvitationEstablishedInfo";
    private static final Integer PEOPLE_PER_PAGE = 10;
    private static final String ITERATOR_ID = "UIIteratorPeople";
    UIProfileUserSearch uiProfileUserSearchPeople = null;
    private UIPageIterator iterator = (UIPageIterator)this.addChild(UIPageIterator.class, null, "UIIteratorPeople");
    private List<Identity> identityList;
    private static final int FIRST_PAGE = 1;

    public List<Identity> getIdentityList() throws Exception {
        if (this.identityList == null) {
            this.identityList = Utils.getIdentityManager().getIdentities("organization");
            if (this.identityList.contains(Utils.getViewerIdentity())) {
                this.identityList.remove(Utils.getViewerIdentity());
            }
        }
        return this.identityList;
    }

    public void setIdentityList(List<Identity> identityList) {
        this.identityList = identityList;
    }

    public UIPageIterator getUIPageIterator() {
        return this.iterator;
    }

    public UIDisplayProfileList() throws Exception {
        this.uiProfileUserSearchPeople = (UIProfileUserSearch)this.createUIComponent(UIProfileUserSearch.class, null, "UIProfileUserSearch");
        this.addChild((UIComponent)this.uiProfileUserSearchPeople);
    }

    public List<Identity> getList() throws Exception {
        int currentPage = this.iterator.getCurrentPage();
        LazyPageList pageList = new LazyPageList((ListAccess)new IdentityListAccess(this.getIdentityList()), PEOPLE_PER_PAGE.intValue());
        this.iterator.setPageList((PageList)pageList);
        if (this.uiProfileUserSearchPeople.isNewSearch()) {
            this.iterator.setCurrentPage(1);
        } else {
            this.iterator.setCurrentPage(currentPage);
        }
        this.uiProfileUserSearchPeople.setNewSearch(false);
        return this.iterator.getCurrentPageData();
    }

    public Relationship getRelationship(Identity identity) throws Exception {
        if (identity.equals((Object)Utils.getViewerIdentity())) {
            return null;
        }
        return Utils.getRelationshipManager().get(identity, Utils.getViewerIdentity());
    }

    public String getPath() {
        String nodePath = Util.getPortalRequestContext().getNodePath();
        String uriPath = Util.getPortalRequestContext().getRequestURI();
        return uriPath.replaceAll(nodePath, "");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchActionListener
    extends EventListener<UIDisplayProfileList> {
        public void execute(Event<UIDisplayProfileList> event) throws Exception {
            UIDisplayProfileList uiMyRelation = (UIDisplayProfileList)((Object)event.getSource());
            UIProfileUserSearch uiProfileUserSearch = (UIProfileUserSearch)uiMyRelation.getChild(UIProfileUserSearch.class);
            List<Identity> identityList = uiProfileUserSearch.getIdentityList();
            uiMyRelation.setIdentityList(identityList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DenyContactActionListener
    extends EventListener<UIDisplayProfileList> {
        public void execute(Event<UIDisplayProfileList> event) throws Exception {
            String userId = event.getRequestContext().getRequestParameter("objectId");
            Identity requestedIdentity = Utils.getIdentityManager().getIdentity(userId);
            Relationship relationship = Utils.getRelationshipManager().get(Utils.getViewerIdentity(), requestedIdentity);
            if (relationship == null || relationship.getStatus() != Relationship.Type.PENDING) {
                UIApplication uiApplication = event.getRequestContext().getUIApplication();
                uiApplication.addMessage(new ApplicationMessage(UIDisplayProfileList.INVITATION_REVOKED_INFO, null, 2));
                return;
            }
            Utils.getRelationshipManager().deny(relationship);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AcceptContactActionListener
    extends EventListener<UIDisplayProfileList> {
        public void execute(Event<UIDisplayProfileList> event) throws Exception {
            String userId = event.getRequestContext().getRequestParameter("objectId");
            Identity requestedIdentity = Utils.getIdentityManager().getIdentity(userId);
            Relationship relationship = Utils.getRelationshipManager().get(Utils.getViewerIdentity(), requestedIdentity);
            if (relationship == null || relationship.getStatus() != Relationship.Type.PENDING) {
                UIApplication uiApplication = event.getRequestContext().getUIApplication();
                uiApplication.addMessage(new ApplicationMessage(UIDisplayProfileList.INVITATION_REVOKED_INFO, null, 2));
                return;
            }
            Utils.getRelationshipManager().confirm(relationship);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddContactActionListener
    extends EventListener<UIDisplayProfileList> {
        public void execute(Event<UIDisplayProfileList> event) throws Exception {
            String userId = event.getRequestContext().getRequestParameter("objectId");
            Identity requestedIdentity = Utils.getIdentityManager().getIdentity(userId);
            Relationship relationship = Utils.getRelationshipManager().get(Utils.getViewerIdentity(), requestedIdentity);
            if (relationship != null) {
                UIApplication uiApplication = event.getRequestContext().getUIApplication();
                uiApplication.addMessage(new ApplicationMessage(UIDisplayProfileList.INVITATION_ESTABLISHED_INFO, null, 2));
                return;
            }
            Utils.getRelationshipManager().invite(Utils.getViewerIdentity(), requestedIdentity);
        }
    }
}

