/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.application;

import java.util.HashMap;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.relationship.RelationshipEvent;
import org.exoplatform.social.core.relationship.RelationshipListenerPlugin;
import org.exoplatform.social.core.relationship.model.Relationship;

public class RelationshipPublisher
extends RelationshipListenerPlugin {
    public static final String SENDER_PARAM = "SENDER";
    public static final String RECEIVER_PARAM = "RECEIVER";
    public static final String RELATIONSHIP_UUID_PARAM = "RELATIONSHIP_UUID";
    public static final String RELATIONSHIP_ACTIVITY_TYPE = "exosocial:relationship";
    private static final Log LOG = ExoLogger.getLogger(RelationshipPublisher.class);
    private ActivityManager activityManager;
    private IdentityManager identityManager;

    public RelationshipPublisher(InitParams params, ActivityManager activityManager, IdentityManager identityManager) {
        this.activityManager = activityManager;
        this.identityManager = identityManager;
    }

    public void confirmed(RelationshipEvent event) {
        Relationship relationship = (Relationship)event.getPayload();
        try {
            Identity sender = relationship.getSender();
            this.reloadIfNeeded(sender);
            Identity receiver = relationship.getReceiver();
            this.reloadIfNeeded(receiver);
            String senderRemoteId = sender.getRemoteId();
            String receiverRemoteId = receiver.getRemoteId();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(SENDER_PARAM, senderRemoteId);
            params.put(RECEIVER_PARAM, receiverRemoteId);
            params.put(RELATIONSHIP_UUID_PARAM, relationship.getId());
            ExoSocialActivityImpl activity1 = new ExoSocialActivityImpl(sender.getId(), RELATIONSHIP_ACTIVITY_TYPE, "I am now connected with @" + receiverRemoteId, null);
            activity1.setTitleId(TitleId.CONNECTION_CONFIRMED.toString());
            activity1.setTemplateParams(params);
            this.activityManager.saveActivity(sender, activity1);
            ExoSocialActivityImpl activity2 = new ExoSocialActivityImpl(receiver.getId(), RELATIONSHIP_ACTIVITY_TYPE, "I am now connected with @" + senderRemoteId, null);
            activity2.setTitleId(TitleId.CONNECTION_CONFIRMED.toString());
            activity2.setTemplateParams(params);
            this.activityManager.saveActivity(receiver, activity2);
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to publish event " + (Object)((Object)event) + ": " + e.getMessage()));
        }
    }

    private void reloadIfNeeded(Identity identity) throws Exception {
        if (identity.getId() == null || identity.getProfile().getFullName().length() == 0) {
            identity = this.identityManager.getIdentity(identity.getGlobalId().toString(), true);
        }
    }

    public void ignored(RelationshipEvent event) {
    }

    public void removed(RelationshipEvent event) {
    }

    public void denied(RelationshipEvent event) {
    }

    public void requested(RelationshipEvent event) {
        Relationship relationship = (Relationship)event.getPayload();
        try {
            Identity sender = relationship.getSender();
            this.reloadIfNeeded(sender);
            Identity receiver = relationship.getReceiver();
            this.reloadIfNeeded(receiver);
            String senderRemoteId = sender.getRemoteId();
            String receiverRemoteId = receiver.getRemoteId();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(SENDER_PARAM, senderRemoteId);
            params.put(RECEIVER_PARAM, receiverRemoteId);
            params.put(RELATIONSHIP_UUID_PARAM, relationship.getId());
            ExoSocialActivityImpl activity1 = new ExoSocialActivityImpl(sender.getId(), RELATIONSHIP_ACTIVITY_TYPE, "@" + senderRemoteId + " has invited @" + receiverRemoteId + " to connect", null);
            activity1.setTitleId(TitleId.CONNECTION_REQUESTED.toString());
            activity1.setTemplateParams(params);
            this.activityManager.saveActivity(sender, activity1);
            ExoSocialActivityImpl activity2 = new ExoSocialActivityImpl(sender.getId(), RELATIONSHIP_ACTIVITY_TYPE, "@" + senderRemoteId + " has invited @" + receiverRemoteId + " to connect", null);
            activity2.setTitleId(TitleId.CONNECTION_REQUESTED.toString());
            activity2.setTemplateParams(params);
            this.activityManager.saveActivity(receiver, activity2);
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to publish event " + (Object)((Object)event) + ": " + e.getMessage()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TitleId {
        CONNECTION_REQUESTED,
        CONNECTION_CONFIRMED;

    }
}

