/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity;

import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.social.common.ListAccessValidator;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.storage.RelationshipStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionListAccess
implements ListAccess<Identity> {
    private RelationshipStorage relationshipStorage;
    Identity identity;

    public ConnectionListAccess(RelationshipStorage relationshipStorage, Identity identity) {
        this.relationshipStorage = relationshipStorage;
        this.identity = identity;
    }

    public Identity[] load(int offset, int limit) throws Exception, IllegalArgumentException {
        ListAccessValidator.validateIndex((int)offset, (int)limit, (int)this.getSize());
        List<Identity> identities = this.relationshipStorage.getConnections(this.identity, offset, limit);
        return identities.toArray(new Identity[identities.size()]);
    }

    public int getSize() throws Exception {
        return this.relationshipStorage.getConnectionsCount(this.identity);
    }
}

