/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.manager;

import java.io.Serializable;
import java.util.List;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.social.core.identity.IdentityProvider;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManagerImpl;
import org.exoplatform.social.core.storage.IdentityStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingIdentityManager
extends IdentityManagerImpl {
    private ExoCache<String, Identity> identityCacheById;
    private ExoCache<String, List<Identity>> identityListCacheByIdentityProvider;

    public CachingIdentityManager(IdentityStorage identityStorage, IdentityProvider<?> defaultIdentityProvider, CacheService cacheService) {
        super(identityStorage, defaultIdentityProvider);
        this.identityCacheById = cacheService.getCacheInstance("exo.social.IdentityManager.IdentityCacheById");
        this.identityListCacheByIdentityProvider = cacheService.getCacheInstance("exo.social.IdentityManager.IdentityListCacheByIdentityProvider");
    }

    @Override
    public Identity getIdentity(String identityId, boolean forceLoadOrReloadProfile) {
        Identity cachedIdentity = (Identity)this.identityCacheById.get((Serializable)((Object)identityId));
        if (cachedIdentity != null && !forceLoadOrReloadProfile) {
            return cachedIdentity;
        }
        Identity foundIdentity = super.getIdentity(identityId, forceLoadOrReloadProfile);
        if (foundIdentity != null) {
            this.identityCacheById.put((Serializable)((Object)identityId), (Object)foundIdentity);
            cachedIdentity = foundIdentity;
        }
        return cachedIdentity;
    }

    @Override
    public Identity updateIdentity(Identity identity) {
        this.updateIdentityCaches(identity);
        return super.updateIdentity(identity);
    }

    @Override
    public void deleteIdentity(Identity identity) {
        super.deleteIdentity(identity);
        this.updateIdentityCaches(identity);
    }

    @Override
    public void saveIdentity(Identity identity) {
        super.saveIdentity(identity);
        this.updateIdentityCaches(identity);
    }

    private void updateIdentityCaches(Identity identity) {
        if (this.identityCacheById.get((Serializable)((Object)identity.getId())) != null) {
            this.identityCacheById.remove((Serializable)((Object)identity.getId()));
        }
        if (this.identityListCacheByIdentityProvider.get((Serializable)((Object)identity.getProviderId())) != null) {
            this.identityListCacheByIdentityProvider.remove((Serializable)((Object)identity.getProviderId()));
        }
    }
}

