/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.jbosscache;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoMode;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeHandler;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.jcr.impl.core.query.jbosscache.ChangesFilterListsWrapper;
import org.exoplatform.services.jcr.impl.core.query.jbosscache.JBossCacheIndexChangesFilter;
import org.exoplatform.services.jcr.impl.storage.jbosscache.AbstractWriteOnlyCacheLoader;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexerCacheLoader
extends AbstractWriteOnlyCacheLoader {
    private static final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.IndexerCacheLoader");
    private final Map<Fqn<String>, Indexer> indexers = new HashMap<Fqn<String>, Indexer>();
    private volatile IndexerIoModeHandler modeHandler;

    public void commit(Object tx) throws Exception {
    }

    public void register(SearchManager searchManager, SearchManager parentSearchManager, QueryHandler handler, QueryHandler parentHandler) throws RepositoryConfigurationException {
        this.indexers.put((Fqn<String>)Fqn.fromElements((Object[])new String[]{searchManager.getWsId()}), new Indexer(searchManager, parentSearchManager, handler, parentHandler));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Register " + searchManager.getWsId() + " " + (Object)((Object)this) + " in " + this.indexers));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Fqn name, Object key, Object value) throws Exception {
        if (key.equals(JBossCacheIndexChangesFilter.LISTWRAPPER) && value instanceof ChangesFilterListsWrapper) {
            if (log.isDebugEnabled()) {
                log.info((Object)"Received list wrapper, start indexing...");
            }
            ChangesFilterListsWrapper wrapper = (ChangesFilterListsWrapper)value;
            try {
                Indexer indexer = this.indexers.get(name.getParent());
                if (indexer == null) {
                    log.warn((Object)("No indexer could be found for the fqn " + name.getParent()));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("The current content of the map of indexers is " + this.indexers));
                    }
                } else {
                    indexer.updateIndex(wrapper.getAddedNodes(), wrapper.getRemovedNodes(), wrapper.getParentAddedNodes(), wrapper.getParentRemovedNodes());
                }
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.cache.removeNode(name);
                throw throwable;
            }
            this.cache.removeNode(name);
            {
            }
        }
        return null;
    }

    public void put(Fqn arg0, Map<Object, Object> arg1) throws Exception {
    }

    @Override
    public void put(List<Modification> modifications) throws Exception {
    }

    public void remove(Fqn arg0) throws Exception {
    }

    void setMode(IndexerIoMode ioMode) {
        if (this.modeHandler != null) {
            this.modeHandler.setMode(ioMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IndexerIoModeHandler getModeHandler() {
        if (this.modeHandler == null) {
            if (this.cache.getCacheStatus() != CacheStatus.STARTED) {
                throw new IllegalStateException("The cache should be started first");
            }
            IndexerCacheLoader indexerCacheLoader = this;
            synchronized (indexerCacheLoader) {
                if (this.modeHandler == null) {
                    this.modeHandler = new IndexerIoModeHandler(this.cache.getRPCManager().isCoordinator() ? IndexerIoMode.READ_WRITE : IndexerIoMode.READ_ONLY);
                }
            }
        }
        return this.modeHandler;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Indexer {
        private final SearchManager searchManager;
        private final SearchManager parentSearchManager;
        private final QueryHandler handler;
        private final QueryHandler parentHandler;

        public Indexer(SearchManager searchManager, SearchManager parentSearchManager, QueryHandler handler, QueryHandler parentHandler) throws RepositoryConfigurationException {
            this.searchManager = searchManager;
            this.parentSearchManager = parentSearchManager;
            this.handler = handler;
            this.parentHandler = parentHandler;
        }

        protected void updateIndex(Set<String> addedNodes, Set<String> removedNodes, Set<String> parentAddedNodes, Set<String> parentRemovedNodes) {
            if (this.searchManager != null && (addedNodes.size() > 0 || removedNodes.size() > 0)) {
                try {
                    this.searchManager.updateIndex(removedNodes, addedNodes);
                }
                catch (RepositoryException e) {
                    log.error((Object)("Error indexing changes " + (Object)((Object)e)), (Throwable)e);
                }
                catch (IOException e) {
                    log.error((Object)("Error indexing changes " + e), (Throwable)e);
                    try {
                        this.handler.logErrorChanges(removedNodes, addedNodes);
                    }
                    catch (IOException ioe) {
                        log.warn((Object)("Exception occure when errorLog writed. Error log is not complete. " + ioe), (Throwable)ioe);
                    }
                }
            }
            if (this.parentSearchManager != null && (parentAddedNodes.size() > 0 || parentRemovedNodes.size() > 0)) {
                try {
                    this.parentSearchManager.updateIndex(parentRemovedNodes, parentAddedNodes);
                }
                catch (RepositoryException e) {
                    log.error((Object)("Error indexing changes " + (Object)((Object)e)), (Throwable)e);
                }
                catch (IOException e) {
                    log.error((Object)("Error indexing changes " + e), (Throwable)e);
                    try {
                        this.parentHandler.logErrorChanges(removedNodes, addedNodes);
                    }
                    catch (IOException ioe) {
                        log.warn((Object)("Exception occure when errorLog writed. Error log is not complete. " + ioe), (Throwable)ioe);
                    }
                }
            }
        }
    }
}

