/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.profile;

import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.profile.UIProfileSection;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/social/webui/profile/UIHeaderSection.gtmpl", events={@EventConfig(listeners={UIProfileSection.EditActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIProfileSection.CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SaveActionListener.class})})
public class UIHeaderSection
extends UIProfileSection {
    public UIHeaderSection() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput("position", "position", null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{3, 30}));
    }

    public void setValue() throws Exception {
        UIFormStringInput uiPosition = (UIFormStringInput)this.getChildById("position");
        Profile profile = this.getProfile();
        String position = (String)profile.getProperty("position");
        position = position == null ? "" : position;
        uiPosition.setValue((Object)position);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends UIProfileSection.SaveActionListener {
        @Override
        public void execute(Event<UIProfileSection> event) throws Exception {
            super.execute(event);
            UIProfileSection sect = (UIProfileSection)((Object)event.getSource());
            UIHeaderSection uiHeaderSect = (UIHeaderSection)sect;
            UIFormStringInput uiPosition = (UIFormStringInput)uiHeaderSect.getChildById("position");
            String position = (String)uiPosition.getValue();
            Profile p = uiHeaderSect.getProfile();
            p.setProperty("position", (Object)position);
            Utils.getIdentityManager().updateProfile(p);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIHeaderSection> {
        public void execute(Event<UIHeaderSection> event) throws Exception {
            UIHeaderSection uiHeader = (UIHeaderSection)((Object)event.getSource());
            uiHeader.setEditMode(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiHeader);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditActionListener
    extends EventListener<UIHeaderSection> {
        public void execute(Event<UIHeaderSection> event) throws Exception {
            UIHeaderSection uiHeader = (UIHeaderSection)((Object)event.getSource());
            uiHeader.setEditMode(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiHeader);
        }
    }
}

