/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.extras.widget.rest;

import java.net.URI;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

@Path(value="spaces/{containerName}")
public class WidgetRestService
implements ResourceContainer {
    private static Log log = ExoLogger.getLogger((String)WidgetRestService.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="go_to_space")
    public Response goToSpace(@PathParam(value="containerName") String containerName, @QueryParam(value="portalName") @DefaultValue(value="classic") String portalName, @QueryParam(value="spaceDisplayName") String spaceDisplayName, @QueryParam(value="description") String description) {
        ExoContainer pc = ExoContainerContext.getContainerByName((String)containerName);
        ExoContainerContext.setCurrentContainer((ExoContainer)pc);
        RequestLifeCycle.begin((ExoContainer)pc);
        try {
            SpaceService service = (SpaceService)pc.getComponentInstanceOfType(SpaceService.class);
            Space space = service.getSpaceByPrettyName(SpaceUtils.cleanString((String)spaceDisplayName));
            String username = ConversationState.getCurrent().getIdentity().getUserId();
            if (space == null) {
                space = new Space();
                space.setDisplayName(spaceDisplayName);
                space.setRegistration("open");
                space.setDescription(description);
                space.setType("classic");
                space.setVisibility("public");
                space.setPriority("2");
                space = service.createSpace(space, username);
            } else if (!service.hasAccessPermission(space, username)) {
                if (space.getRegistration().equals("open")) {
                    service.addMember(space, username);
                } else {
                    service.addPendingUser(space, username);
                }
            }
            URI spaceURL = UriBuilder.fromPath((String)"/{containerName}/private/{portalName}/{spaceURL}").build(new Object[]{containerName, portalName, space.getUrl()});
            URI cleanupURL = UriBuilder.fromPath((String)"/{containerName}/invalidationsession").queryParam("portal", new Object[]{portalName}).queryParam("url", new Object[]{"{url}"}).build(new Object[]{containerName, spaceURL});
            Response response = Response.temporaryRedirect((URI)cleanupURL).build();
            return response;
        }
        catch (Exception e) {
            log.error((Object)"Error redirecting to a space", (Throwable)e);
            Response response = Response.status((int)500).build();
            return response;
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    @GET
    @Path(value="space_info")
    @Produces(value={"text/html"})
    public String spaceInfo(@PathParam(value="containerName") String containerName, @QueryParam(value="portalName") @DefaultValue(value="classic") String portalName, @QueryParam(value="spacePrettyName") String spacePrettyName, @QueryParam(value="description") String description, @Context UriInfo uriInfo) {
        ExoContainer pc = ExoContainerContext.getContainerByName((String)containerName);
        ExoContainerContext.setCurrentContainer((ExoContainer)pc);
        SpaceService service = (SpaceService)pc.getComponentInstanceOfType(SpaceService.class);
        IdentityManager identityManager = (IdentityManager)pc.getComponentInstanceOfType(IdentityManager.class);
        ActivityManager activityManager = (ActivityManager)pc.getComponentInstanceOfType(ActivityManager.class);
        StringBuffer response = new StringBuffer();
        response.append("<!DOCTYPE html><html><head><style type=\"text/css\">html,body{margin:0;padding:0;font-family:lucida,arial,tahoma,verdana,sans-serif;}").append(" h1,h3 {margin:0px} h3 a {color:#FF9600;font-size:14px;font-weight:bold;} h1{ text-indent:-9000px;height:20px;").append("background:url(\"/socialWidgetResources/img/social-logo.png\") no-repeat scroll 0 0 #FFFFFF; margin-bottom:5px;}</style>").append("</head><body><h1>eXo Social</h1>");
        URI goToSpace = uriInfo.getBaseUriBuilder().path("/spaces/{containerName}/go_to_space").queryParam("spacePrettyName", new Object[]{spacePrettyName}).queryParam("portalName", new Object[]{portalName}).queryParam("description", new Object[]{description}).build(new Object[]{containerName});
        Space space = service.getSpaceByPrettyName(spacePrettyName);
        response.append("<h3 class=\"space_name\"><a href=\"").append(goToSpace.toString()).append("\" target=\"_blank\">").append(space.getDisplayName()).append("</a></h3>");
        if (space != null) {
            String username = ConversationState.getCurrent().getIdentity().getUserId();
            if (service.hasAccessPermission(space, username)) {
                Identity spaceIdentity = identityManager.getOrCreateIdentity("space", space.getPrettyName());
                List activities = activityManager.getActivities(spaceIdentity);
                if (activities.size() > 0) {
                    response.append("<i>" + ((ExoSocialActivity)activities.get(0)).getTitle() + "</i>");
                }
            } else {
                response.append("You are not member");
            }
        } else {
            response.append("You are not member");
        }
        return response + "</body></html>";
    }
}

