/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui;

import java.util.List;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.URLUtils;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.core.UIComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static String getOwnerRemoteId() {
        String currentUserName = URLUtils.getCurrentUser();
        if (currentUserName == null || currentUserName.equals("")) {
            return Utils.getViewerRemoteId();
        }
        return currentUserName;
    }

    public static String getViewerRemoteId() {
        return RequestContext.getCurrentInstance().getRemoteUser();
    }

    public static boolean isOwner() {
        return Utils.getViewerRemoteId().equals(Utils.getOwnerRemoteId());
    }

    public static Identity getOwnerIdentity(boolean loadProfile) {
        return Utils.getUserIdentity(Utils.getOwnerRemoteId(), loadProfile);
    }

    public static Identity getViewerIdentity(boolean loadProfile) {
        return Utils.getUserIdentity(Utils.getViewerRemoteId(), loadProfile);
    }

    public static Identity getOwnerIdentity() {
        return Utils.getUserIdentity(Utils.getOwnerRemoteId(), false);
    }

    public static Identity getViewerIdentity() {
        return Utils.getUserIdentity(Utils.getViewerRemoteId(), false);
    }

    public static Identity getUserIdentity(String userName, boolean loadProfile) {
        return Utils.getIdentityManager().getOrCreateIdentity("organization", userName, loadProfile);
    }

    public static Identity getOwnerSpaceIdentity() {
        return Utils.getIdentityManager().getOrCreateIdentity("space", Utils.getOwnerRemoteId(), true);
    }

    public static List<Identity> getOwnerFriends() throws Exception {
        return Utils.getIdentityManager().getConnections(Utils.getOwnerIdentity());
    }

    public static List<Identity> getViewerFriends() throws Exception {
        return Utils.getIdentityManager().getConnections(Utils.getViewerIdentity());
    }

    public static void updateWorkingWorkSpace() {
        UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)Util.getUIPortalApplication().getChildById("UIWorkingWorkspace");
        PortalRequestContext pContext = Util.getPortalRequestContext();
        pContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
        pContext.setFullRender(true);
    }

    public static final ActivityManager getActivityManager() {
        return (ActivityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ActivityManager.class);
    }

    public static final IdentityManager getIdentityManager() {
        return (IdentityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(IdentityManager.class);
    }

    public static final RelationshipManager getRelationshipManager() {
        return (RelationshipManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RelationshipManager.class);
    }

    public static final SpaceService getSpaceService() {
        return (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
    }
}

