/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.registry;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.registry.Registry;
import org.exoplatform.services.jcr.ext.registry.RegistryEntry;
import org.exoplatform.services.jcr.ext.registry.RegistryInitializationEntryPlugin;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryService
extends Registry
implements Startable {
    private static Log log = ExoLogger.getLogger("exo.jcr.component.ext.RegistryService");
    protected static final String EXO_REGISTRY_NT = "exo:registry";
    protected static final String EXO_REGISTRYENTRY_NT = "exo:registryEntry";
    protected static final String EXO_REGISTRYGROUP_NT = "exo:registryGroup";
    protected static final String NT_FILE = "registry-nodetypes.xml";
    protected static final String EXO_REGISTRY = "exo:registry";
    protected static final String EXO_REGISTRYENTRY = "exo:registryEntry";
    public static final String EXO_SERVICES = "exo:services";
    public static final String EXO_APPLICATIONS = "exo:applications";
    public static final String EXO_USERS = "exo:users";
    public static final String EXO_GROUPS = "exo:groups";
    protected final Map<String, String> regWorkspaces;
    private HashMap<String, String> appConfigurations = new HashMap();
    private String entryLocation;
    private final PropertiesParam props;
    protected final RepositoryService repositoryService;
    protected boolean started = false;

    public RegistryService(InitParams params, RepositoryService repositoryService) throws RepositoryConfigurationException {
        this.repositoryService = repositoryService;
        this.regWorkspaces = new HashMap<String, String>();
        if (params == null) {
            throw new RepositoryConfigurationException("Init parameters expected");
        }
        this.props = params.getPropertiesParam("locations");
        if (this.props == null) {
            throw new RepositoryConfigurationException("Property parameters 'locations' expected");
        }
    }

    @Override
    public RegistryEntry getEntry(SessionProvider sessionProvider, String entryPath) throws PathNotFoundException, RepositoryException {
        String fullPath = "/exo:registry/" + entryPath;
        Session session = this.session(sessionProvider, this.repositoryService.getCurrentRepository());
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            session.exportDocumentView(fullPath, (OutputStream)out, true, false);
            return RegistryEntry.parse(out.toByteArray());
        }
        catch (IOException e) {
            throw new RepositoryException("Can't export node " + fullPath + " to XML representation " + e);
        }
        catch (ParserConfigurationException e) {
            throw new RepositoryException("Can't export node " + fullPath + " to XML representation " + e);
        }
        catch (SAXException e) {
            throw new RepositoryException("Can't export node " + fullPath + " to XML representation " + e);
        }
    }

    @Override
    public void createEntry(SessionProvider sessionProvider, String groupPath, RegistryEntry entry) throws RepositoryException {
        String fullPath = "/exo:registry/" + groupPath;
        try {
            this.checkGroup(sessionProvider, groupPath);
            this.session(sessionProvider, this.repositoryService.getCurrentRepository()).getWorkspace().importXML(fullPath, entry.getAsInputStream(), 0);
        }
        catch (IOException ioe) {
            throw new RepositoryException("Item " + fullPath + "can't be created " + ioe);
        }
        catch (ItemExistsException iee) {
            throw new RepositoryException("Item " + fullPath + "alredy exists " + (Object)((Object)iee));
        }
        catch (TransformerException te) {
            throw new RepositoryException("Can't get XML representation from stream " + te);
        }
    }

    @Override
    public void removeEntry(SessionProvider sessionProvider, String entryPath) throws RepositoryException {
        Node root = this.session(sessionProvider, this.repositoryService.getCurrentRepository()).getRootNode();
        Node node = root.getNode("exo:registry/" + entryPath);
        Node parent = node.getParent();
        node.remove();
        parent.save();
    }

    @Override
    public void recreateEntry(SessionProvider sessionProvider, String groupPath, RegistryEntry entry) throws RepositoryException {
        String entryRelPath = "exo:registry/" + groupPath + "/" + entry.getName();
        String parentFullPath = "/exo:registry/" + groupPath;
        try {
            Session session = this.session(sessionProvider, this.repositoryService.getCurrentRepository());
            Node node = session.getRootNode().getNode(entryRelPath);
            node.remove();
            session.importXML(parentFullPath, entry.getAsInputStream(), 0);
            session.save();
        }
        catch (IOException ioe) {
            throw new RepositoryException("Item " + parentFullPath + "can't be created " + ioe);
        }
        catch (TransformerException te) {
            throw new RepositoryException("Can't get XML representation from stream " + te);
        }
    }

    public void updateEntry(SessionProvider sessionProvider, String groupPath, RegistryEntry entry) throws RepositoryException {
        String entryRelPath = "exo:registry/" + groupPath + "/" + entry.getName();
        String parentFullPath = "/exo:registry/" + groupPath;
        try {
            Session session = this.session(sessionProvider, this.repositoryService.getCurrentRepository());
            try {
                Node node = session.getRootNode().getNode(entryRelPath);
                node.remove();
                session.importXML(parentFullPath, entry.getAsInputStream(), 0);
            }
            catch (PathNotFoundException e) {
                this.createEntry(sessionProvider, groupPath, entry);
            }
            session.save();
        }
        catch (IOException ioe) {
            throw new RepositoryException("Item " + parentFullPath + "can't be created " + ioe);
        }
        catch (TransformerException te) {
            throw new RepositoryException("Can't get XML representation from stream " + te);
        }
    }

    @Override
    public Registry.RegistryNode getRegistry(SessionProvider sessionProvider) throws RepositoryException {
        return new Registry.RegistryNode(this.session(sessionProvider, this.repositoryService.getCurrentRepository()).getRootNode().getNode("exo:registry"));
    }

    private Session session(SessionProvider sessionProvider, ManageableRepository repo) throws RepositoryException {
        return sessionProvider.getSession(this.regWorkspaces.get(repo.getConfiguration().getName()), repo);
    }

    public boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (!this.started) {
            try {
                for (RepositoryEntry repConfiguration : this.repConfigurations()) {
                    Exception e2;
                    Object var7_8;
                    String repName = repConfiguration.getName();
                    String wsName = null;
                    if (this.props != null) {
                        wsName = this.props.getProperty(repName);
                        if (wsName == null) {
                            wsName = repConfiguration.getDefaultWorkspaceName();
                        }
                    } else {
                        wsName = repConfiguration.getDefaultWorkspaceName();
                    }
                    this.addRegistryLocation(repName, wsName);
                    InputStream xml = SecurityHelper.doPrivilegedAction(new PrivilegedAction<InputStream>(){

                        @Override
                        public InputStream run() {
                            return this.getClass().getResourceAsStream(RegistryService.NT_FILE);
                        }
                    });
                    try {
                        this.repositoryService.getRepository(repName).getNodeTypeManager().registerNodeTypes(xml, 0);
                        var7_8 = null;
                    }
                    catch (Throwable throwable) {
                        var7_8 = null;
                        try {
                            xml.close();
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        xml.close();
                    }
                    catch (Exception e2) {}
                }
                this.initStorage(false);
                this.started = true;
            }
            catch (RepositoryConfigurationException e) {
                log.error(e.getLocalizedMessage(), e);
            }
            catch (RepositoryException e) {
                log.error(e.getLocalizedMessage(), e);
            }
        } else if (log.isDebugEnabled()) {
            log.warn("Registry service already started");
        }
    }

    public void stop() {
    }

    public void initStorage(boolean replace) throws RepositoryConfigurationException, RepositoryException {
        for (RepositoryEntry repConfiguration : this.repConfigurations()) {
            String repName = repConfiguration.getName();
            ManageableRepository rep = this.repositoryService.getRepository(repName);
            final Session sysSession = rep.getSystemSession(this.regWorkspaces.get(repName));
            if (sysSession.getRootNode().hasNode("exo:registry") && replace) {
                sysSession.getRootNode().getNode("exo:registry").remove();
            }
            if (!sysSession.getRootNode().hasNode("exo:registry")) {
                Node rootNode = sysSession.getRootNode().addNode("exo:registry", "exo:registry");
                rootNode.addNode(EXO_SERVICES, EXO_REGISTRYGROUP_NT);
                rootNode.addNode(EXO_APPLICATIONS, EXO_REGISTRYGROUP_NT);
                rootNode.addNode(EXO_USERS, EXO_REGISTRYGROUP_NT);
                rootNode.addNode(EXO_GROUPS, EXO_REGISTRYGROUP_NT);
                Set<String> appNames = this.appConfigurations.keySet();
                final String fullPath = "/exo:registry/" + this.entryLocation;
                for (String appName : appNames) {
                    final String xml = this.appConfigurations.get(appName);
                    try {
                        SecurityHelper.doPrivilegedExceptionAction(new PrivilegedExceptionAction<Void>(){

                            @Override
                            public Void run() throws Exception {
                                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                                ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes());
                                Document document = builder.parse(stream);
                                RegistryEntry entry = new RegistryEntry(document);
                                sysSession.importXML(fullPath, entry.getAsInputStream(), 0);
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException pae) {
                        Throwable cause = pae.getCause();
                        if (cause instanceof ParserConfigurationException) {
                            log.error(cause.getLocalizedMessage(), cause);
                            continue;
                        }
                        if (cause instanceof IOException) {
                            log.error(cause.getLocalizedMessage(), cause);
                            continue;
                        }
                        if (cause instanceof SAXException) {
                            log.error(cause.getLocalizedMessage(), cause);
                            continue;
                        }
                        if (cause instanceof TransformerException) {
                            log.error(cause.getLocalizedMessage(), cause);
                            continue;
                        }
                        if (cause instanceof RuntimeException) {
                            throw (RuntimeException)cause;
                        }
                        throw new RuntimeException(cause);
                    }
                }
                sysSession.save();
            }
            sysSession.logout();
        }
    }

    public void addRegistryLocation(String repositoryName, String workspaceName) {
        this.regWorkspaces.put(repositoryName, workspaceName);
    }

    public void removeRegistryLocation(String repositoryName) {
        this.regWorkspaces.remove(repositoryName);
    }

    public void initRegistryEntry(String groupName, String entryName) throws RepositoryException, RepositoryConfigurationException {
        String relPath = "exo:registry/" + groupName + "/" + entryName;
        for (RepositoryEntry repConfiguration : this.repConfigurations()) {
            String repName = repConfiguration.getName();
            SessionProvider sysProvider = SessionProvider.createSystemProvider();
            Node root = this.session(sysProvider, this.repositoryService.getRepository(repName)).getRootNode();
            if (!root.hasNode(relPath)) {
                root.addNode(relPath, "exo:registryEntry");
                root.save();
            } else {
                log.info("The RegistryEntry " + relPath + "is already initialized on repository " + repName);
            }
            sysProvider.close();
        }
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public boolean getForceXMLConfigurationValue(InitParams initParams) {
        ValueParam valueParam = initParams.getValueParam("force-xml-configuration");
        return valueParam != null ? Boolean.valueOf(valueParam.getValue()) : false;
    }

    private List<RepositoryEntry> repConfigurations() {
        return this.repositoryService.getConfig().getRepositoryConfigurations();
    }

    private void checkGroup(SessionProvider sessionProvider, String groupPath) throws RepositoryException {
        String[] groupNames = groupPath.split("/");
        String prefix = "/exo:registry";
        Session session = this.session(sessionProvider, this.repositoryService.getCurrentRepository());
        for (String name : groupNames) {
            String path = prefix + "/" + name;
            try {
                Node group = (Node)session.getItem(path);
                if (!group.isNodeType(EXO_REGISTRYGROUP_NT)) {
                    throw new RepositoryException("Node at " + path + " should be  " + EXO_REGISTRYGROUP_NT + " type");
                }
            }
            catch (PathNotFoundException e) {
                Node parent = (Node)session.getItem(prefix);
                parent.addNode(name, EXO_REGISTRYGROUP_NT);
                parent.save();
            }
            prefix = path;
        }
    }

    public void addPlugin(ComponentPlugin plugin) {
        if (RegistryInitializationEntryPlugin.class.isAssignableFrom(plugin.getClass())) {
            RegistryInitializationEntryPlugin registryPlugin = (RegistryInitializationEntryPlugin)plugin;
            this.appConfigurations = registryPlugin.getAppConfiguration();
            this.entryLocation = registryPlugin.getLocation();
            if (this.entryLocation == null) {
                this.entryLocation = EXO_APPLICATIONS;
            }
        }
    }
}

