/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.space.spi.SpaceService;

public final class Util {
    private Util() {
    }

    public static Response getResponse(Object entity, UriInfo uriInfo, MediaType mediaType, Response.Status status) {
        return Response.created((URI)UriBuilder.fromUri((URI)uriInfo.getAbsolutePath()).build(new Object[0])).entity(entity).type(mediaType).status(status).build();
    }

    @Deprecated
    public static MediaType getMediaType(String format) throws WebApplicationException {
        if (format.equals("json")) {
            return MediaType.APPLICATION_JSON_TYPE;
        }
        if (format.equals("xml")) {
            return MediaType.APPLICATION_XML_TYPE;
        }
        throw new WebApplicationException(Response.Status.BAD_REQUEST);
    }

    public static MediaType getMediaType(String expectedFormat, String[] supportedFormats) {
        if (!Util.isSupportedFormat(expectedFormat, supportedFormats)) {
            throw new WebApplicationException(Response.Status.UNSUPPORTED_MEDIA_TYPE);
        }
        if (expectedFormat.equals("json") && Util.isSupportedFormat("json", supportedFormats)) {
            return MediaType.APPLICATION_JSON_TYPE;
        }
        if (expectedFormat.equals("xml") && Util.isSupportedFormat("xml", supportedFormats)) {
            return MediaType.APPLICATION_XML_TYPE;
        }
        if (expectedFormat.equals("atom") && Util.isSupportedFormat("atom", supportedFormats)) {
            return MediaType.APPLICATION_ATOM_XML_TYPE;
        }
        throw new WebApplicationException(Response.Status.NOT_ACCEPTABLE);
    }

    public static String getViewerId(UriInfo uriInfo) {
        URI uri = uriInfo.getRequestUri();
        String requestString = uri.getQuery();
        if (requestString == null) {
            return null;
        }
        String[] queryParts = requestString.split("&");
        String viewerId = null;
        for (String queryPart : queryParts) {
            if (!queryPart.startsWith("opensocial_viewer_id")) continue;
            viewerId = queryPart.substring(queryPart.indexOf("=") + 1, queryPart.length());
            break;
        }
        return viewerId;
    }

    public static Identity getViewerIdentity(String viewerId) {
        return Util.getUserIdentity(viewerId, false);
    }

    public static Identity getUserIdentity(String userName, boolean loadProfile) {
        return Util.getIdentityManager().getOrCreateIdentity("organization", userName, loadProfile);
    }

    public static final IdentityManager getIdentityManager() {
        return (IdentityManager)Util.getDefaultPortalContainer().getComponentInstanceOfType(IdentityManager.class);
    }

    public static final IdentityManager getIdentityManager(String portalContainerName) {
        return (IdentityManager)Util.getPortalContainerByName(portalContainerName).getComponentInstanceOfType(IdentityManager.class);
    }

    public static final SpaceService getSpaceService() {
        return (SpaceService)Util.getDefaultPortalContainer().getComponentInstanceOfType(SpaceService.class);
    }

    public static final SpaceService getSpaceService(String portalContainerName) {
        return (SpaceService)Util.getPortalContainerByName(portalContainerName).getComponentInstanceOfType(SpaceService.class);
    }

    public static final ActivityManager getActivityManager() {
        return (ActivityManager)Util.getDefaultPortalContainer().getComponentInstanceOfType(ActivityManager.class);
    }

    public static final ActivityManager getActivityManager(String portalContainerName) {
        return (ActivityManager)Util.getPortalContainerByName(portalContainerName).getComponentInstanceOfType(ActivityManager.class);
    }

    public static final RelationshipManager getRelationshipManager() {
        return (RelationshipManager)Util.getDefaultPortalContainer().getComponentInstanceOfType(RelationshipManager.class);
    }

    public static final RelationshipManager getRelationshipManager(String portalContainerName) {
        return (RelationshipManager)Util.getPortalContainerByName(portalContainerName).getComponentInstanceOfType(RelationshipManager.class);
    }

    public static final String convertTimestampToTimeString(long timestamp) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss Z yyyy");
        dateFormat.setTimeZone(TimeZone.getDefault());
        return dateFormat.format(new Date(timestamp));
    }

    private static boolean isSupportedFormat(String expectedFormat, String[] supportedFormats) {
        for (String supportedFormat : supportedFormats) {
            if (!supportedFormat.equals(expectedFormat)) continue;
            return true;
        }
        return false;
    }

    private static PortalContainer getDefaultPortalContainer() {
        return PortalContainer.getInstance();
    }

    private static PortalContainer getPortalContainerByName(String portalContainerName) {
        return (PortalContainer)ExoContainerContext.getContainerByName((String)portalContainerName);
    }

    public static Identity getOwnerIdentityIdFromActivity(ExoSocialActivity activity) {
        IdentityManager identityManager = Util.getIdentityManager();
        ActivityStream activityStream = activity.getActivityStream();
        ActivityStream.Type activityType = activityStream.getType();
        String name = activity.getStreamOwner();
        if (activityType.equals((Object)ActivityStream.Type.USER)) {
            return identityManager.getOrCreateIdentity("organization", name, false);
        }
        return identityManager.getOrCreateIdentity("space", name, false);
    }
}

