/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl;

import javax.jcr.RepositoryException;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.security.JCRRuntimePermissions;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

@Managed
@NameTemplate(value={@Property(key="service", value="RepositorySuspendController")})
public class RepositorySuspendController
implements Startable {
    private final ManageableRepository repository;
    protected static Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.RepositorySuspendController");

    public RepositorySuspendController(ManageableRepository repository) {
        this.repository = repository;
    }

    @Managed
    @ManagedDescription(value="Suspend repository which means that allow only read operations. All writing threads will wait until resume operations invoked.")
    public String suspend() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(JCRRuntimePermissions.MANAGE_REPOSITORY_PERMISSION);
        }
        try {
            this.repository.setState(3);
        }
        catch (RepositoryException e) {
            log.error((Object)e);
        }
        return this.getState();
    }

    @Managed
    @ManagedDescription(value="Resume repository. All previously suspended threads continue working.")
    public String resume() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(JCRRuntimePermissions.MANAGE_REPOSITORY_PERMISSION);
        }
        try {
            this.repository.setState(1);
        }
        catch (RepositoryException e) {
            log.error((Object)e);
        }
        return this.getState();
    }

    @Managed
    @ManagedDescription(value="Returns repository state.")
    public String getState() {
        return this.repository.getStateTitle();
    }

    public void start() {
    }

    public void stop() {
    }
}

