/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.provider;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import org.exoplatform.services.rest.BaseObjectModel;
import org.exoplatform.services.rest.ComponentLifecycleScope;
import org.exoplatform.services.rest.impl.header.MediaTypeHelper;
import org.exoplatform.services.rest.provider.ProviderDescriptor;
import org.exoplatform.services.rest.resource.ResourceDescriptorVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderDescriptorImpl
extends BaseObjectModel
implements ProviderDescriptor {
    private final List<MediaType> consumes;
    private final List<MediaType> produces;

    public ProviderDescriptorImpl(Class<?> providerClass) {
        this(providerClass, ComponentLifecycleScope.PER_REQUEST);
    }

    public ProviderDescriptorImpl(Object provider) {
        this(provider.getClass(), ComponentLifecycleScope.SINGLETON);
    }

    private ProviderDescriptorImpl(Class<?> providerClass, ComponentLifecycleScope scope) {
        super(providerClass, scope);
        this.consumes = MediaTypeHelper.createConsumesList(providerClass.getAnnotation(Consumes.class));
        this.produces = MediaTypeHelper.createProducesList(providerClass.getAnnotation(Produces.class));
    }

    @Override
    public void accept(ResourceDescriptorVisitor visitor) {
        visitor.visitProviderDescriptor(this);
    }

    @Override
    public List<MediaType> consumes() {
        return this.consumes;
    }

    @Override
    public List<MediaType> produces() {
        return this.produces;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[ ProviderDescriptorImpl: ");
        sb.append("provider class: " + this.getObjectClass() + "; ").append("produces media type: " + this.produces() + "; ").append("consumes media type: " + this.consumes() + "; ").append(this.getConstructorDescriptors() + "; ").append(this.getFieldInjectors()).append(" ]");
        return sb.toString();
    }
}

