/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Token;
import com.google.caja.lexer.TokenStream;
import com.google.caja.lexer.TokenType;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.Criterion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenQueue<T extends TokenType> {
    private final TokenStream<T> tstream;
    private final InputSource file;
    private FilePosition inputRange;
    private final Criterion<Token<T>> tokenFilter;
    private TokenList<T> current;
    private TokenList<T> prev;
    private boolean eof = false;

    public TokenQueue(TokenStream<T> tokenStream, InputSource file, Criterion<Token<T>> tokenFilter) {
        this.tstream = tokenStream;
        this.file = file;
        this.tokenFilter = tokenFilter;
    }

    public TokenQueue(TokenStream<T> tokenStream, InputSource file) {
        this(tokenStream, file, Criterion.Factory.optimist());
    }

    public InputSource getInputSource() {
        return this.file;
    }

    public FilePosition getInputRange() {
        return this.inputRange;
    }

    public void setInputRange(FilePosition range) {
        this.inputRange = range;
    }

    public Criterion<Token<T>> getTokenFilter() {
        return this.tokenFilter;
    }

    public boolean isEmpty() throws ParseException {
        this.fetch(false);
        return null == this.current;
    }

    public void expectEmpty() throws ParseException {
        if (!this.isEmpty()) {
            throw new ParseException(new Message((MessageTypeInt)MessageType.UNUSED_TOKENS, this.currentPosition(), MessagePart.Factory.valueOf(this.peek().text)));
        }
    }

    private void fetch(boolean failOnEof) throws ParseException {
        if (null != this.current) {
            return;
        }
        ArrayList<Token<T>> filtered = null;
        Token<T> t = null;
        if (!this.eof) {
            while (this.tstream.hasNext() && !this.tokenFilter.accept(t = this.tstream.next())) {
                if (null == filtered) {
                    filtered = new ArrayList<Token<T>>();
                }
                filtered.add(t);
                t = null;
            }
        }
        if (null == t) {
            this.eof = true;
            if (failOnEof) {
                throw new ParseException(new Message((MessageTypeInt)MessageType.END_OF_FILE, null != this.inputRange ? this.inputRange : this.file));
            }
            return;
        }
        TokenList tl = new TokenList();
        tl.t = t;
        tl.filteredTokens = null != filtered ? Collections.unmodifiableList(filtered) : Collections.emptyList();
        this.current = tl;
        if (null != this.prev) {
            this.prev.next = tl;
        }
    }

    public void advance() throws ParseException {
        this.fetch(true);
        this.prev = this.current;
        this.current = this.current.next;
    }

    public Token<T> peek() throws ParseException {
        this.fetch(true);
        return this.current.t;
    }

    public Token<T> pop() throws ParseException {
        Token<T> t = this.peek();
        this.advance();
        return t;
    }

    public List<Token<T>> filteredTokens() throws ParseException {
        this.fetch(true);
        return this.current.filteredTokens;
    }

    public Mark mark() throws ParseException {
        if (null == this.current && null == this.prev) {
            this.fetch(true);
        }
        return new Mark(this);
    }

    public void rewind(Mark m) {
        if (m.tq != this) {
            throw new IllegalStateException();
        }
        this.prev = m.savedPrev;
        this.current = null != this.prev ? this.prev.next : m.savedCurrent;
    }

    public FilePosition currentPosition() throws ParseException {
        return this.peek().pos;
    }

    public FilePosition lastPosition() {
        return this.prev != null ? this.prev.t.pos : null;
    }

    public boolean checkToken(String text) throws ParseException {
        if (this.isEmpty()) {
            return false;
        }
        if (this.peek().text.equals(text)) {
            this.advance();
            return true;
        }
        return false;
    }

    public void expectToken(String text) throws ParseException {
        Token<T> t;
        try {
            t = this.peek();
        }
        catch (ParseException ex) {
            if (this.prev != null && ex.getCajaMessage().getMessageType() == MessageType.END_OF_FILE) {
                throw new ParseException(new Message((MessageTypeInt)MessageType.EXPECTED_TOKEN, FilePosition.endOf(this.prev.t.pos), MessagePart.Factory.valueOf(text), MessagePart.Factory.valueOf("EOF")));
            }
            throw ex;
        }
        if (t.text.equals(text)) {
            this.advance();
            return;
        }
        throw new ParseException(new Message((MessageTypeInt)MessageType.EXPECTED_TOKEN, t.pos, MessagePart.Factory.valueOf(text), MessagePart.Factory.valueOf(t.text)));
    }

    public boolean lookaheadToken(String text) throws ParseException {
        return !this.isEmpty() && this.peek().text.equals(text);
    }

    public Token<T> expectTokenOfType(T tt) throws ParseException {
        Token<T> t = this.peek();
        if (t.type == tt) {
            this.advance();
            return t;
        }
        throw new ParseException(new Message((MessageTypeInt)MessageType.EXPECTED_TOKEN, t.pos, MessagePart.Factory.valueOf(tt.toString()), MessagePart.Factory.valueOf(t.text)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TokenList<TT extends TokenType> {
        Token<TT> t;
        TokenList<TT> next;
        List<Token<TT>> filteredTokens;

        private TokenList() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Mark {
        final TokenList<?> savedCurrent;
        final TokenList<?> savedPrev;
        final TokenQueue<?> tq;

        Mark(TokenQueue<?> tq) {
            this.tq = tq;
            this.savedCurrent = ((TokenQueue)tq).current;
            this.savedPrev = ((TokenQueue)tq).prev;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FilePosition getFilePosition() throws ParseException {
            Mark endMark = this.tq.mark();
            this.tq.rewind(this);
            try {
                if (this.tq.isEmpty()) {
                    FilePosition filePosition = FilePosition.endOf(this.tq.lastPosition());
                    return filePosition;
                }
                FilePosition filePosition = this.tq.currentPosition();
                return filePosition;
            }
            finally {
                this.tq.rewind(endMark);
            }
        }
    }
}

