/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.jlr;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.reflext.api.ClassKind;
import org.reflext.api.LiteralType;
import org.reflext.spi.model.GenericDeclarationKind;
import org.reflext.spi.model.TypeKind;
import org.reflext.spi.model.TypeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaLangReflectTypeModel
implements TypeModel<Type> {
    private static final Map<Class<?>, LiteralType> primitiveMap = new HashMap();

    public JavaLangReflectTypeModel() {
        primitiveMap.put(Boolean.class, LiteralType.BOOLEAN);
        primitiveMap.put(Boolean.TYPE, LiteralType.BOOLEAN);
        primitiveMap.put(Byte.class, LiteralType.BYTE);
        primitiveMap.put(Byte.TYPE, LiteralType.BYTE);
        primitiveMap.put(Short.class, LiteralType.SHORT);
        primitiveMap.put(Short.TYPE, LiteralType.SHORT);
        primitiveMap.put(Integer.class, LiteralType.INT);
        primitiveMap.put(Integer.TYPE, LiteralType.INT);
        primitiveMap.put(Long.class, LiteralType.LONG);
        primitiveMap.put(Long.TYPE, LiteralType.LONG);
        primitiveMap.put(Float.class, LiteralType.FLOAT);
        primitiveMap.put(Float.TYPE, LiteralType.FLOAT);
        primitiveMap.put(Double.class, LiteralType.DOUBLE);
        primitiveMap.put(Double.TYPE, LiteralType.DOUBLE);
    }

    public TypeKind getKind(Type type) {
        if (type instanceof Class) {
            Class classType = (Class)type;
            if (classType.isArray()) {
                return TypeKind.ARRAY;
            }
            if (classType.isPrimitive()) {
                if (classType == Void.TYPE) {
                    return TypeKind.VOID;
                }
                return TypeKind.SIMPLE;
            }
            if (classType == Boolean.class || classType == Float.class || classType == Byte.class || classType == Short.class || classType == Integer.class || classType == Long.class || classType == Double.class) {
                return TypeKind.SIMPLE;
            }
            if (classType == Void.class) {
                return TypeKind.VOID;
            }
            return TypeKind.CLASS;
        }
        if (type instanceof ParameterizedType) {
            return TypeKind.PARAMETERIZED;
        }
        if (type instanceof TypeVariable) {
            return TypeKind.VARIABLE;
        }
        if (type instanceof WildcardType) {
            return TypeKind.WILDCARD;
        }
        if (type instanceof GenericArrayType) {
            return TypeKind.ARRAY;
        }
        throw new AssertionError();
    }

    public LiteralType getLiteralType(Type simpleType) {
        Class classType = (Class)simpleType;
        return primitiveMap.get(classType);
    }

    public Type getComponentType(Type arrayType) {
        if (arrayType instanceof Class) {
            return ((Class)arrayType).getComponentType();
        }
        return ((GenericArrayType)arrayType).getGenericComponentType();
    }

    public boolean isPrimitive(Type simpleType) {
        Class classType = (Class)simpleType;
        return classType.isPrimitive();
    }

    public Type getEnclosing(Type classType) {
        return ((Class)classType).getEnclosingClass();
    }

    public String getClassName(Type classType) {
        return ((Class)classType).getName();
    }

    public ClassKind getClassKind(Type classType) {
        Class tmp = (Class)classType;
        if (tmp.isAnnotation()) {
            return ClassKind.ANNOTATION;
        }
        if (tmp.isEnum()) {
            return ClassKind.ENUM;
        }
        if (tmp.isInterface()) {
            return ClassKind.INTERFACE;
        }
        return ClassKind.CLASS;
    }

    public Iterable<Type> getInterfaces(Type classType) {
        return Arrays.asList(((Class)classType).getGenericInterfaces());
    }

    public Type getSuperClass(Type classType) {
        return ((Class)classType).getGenericSuperclass();
    }

    public Iterable<Type> getTypeParameters(Type classType) {
        ArrayList<Type> typeParameters = new ArrayList<Type>();
        for (TypeVariable typeParameter : ((Class)classType).getTypeParameters()) {
            typeParameters.add(typeParameter);
        }
        return typeParameters;
    }

    public Type getGenericDeclaration(Type typeVariable) {
        return (Type)((TypeVariable)typeVariable).getGenericDeclaration();
    }

    public GenericDeclarationKind getGenericDeclarationKind(Type typeVariable) {
        Object genDecl = ((TypeVariable)typeVariable).getGenericDeclaration();
        if (genDecl instanceof Type) {
            return GenericDeclarationKind.TYPE;
        }
        if (genDecl instanceof Method) {
            return GenericDeclarationKind.METHOD;
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public String getName(Type typeVariable) {
        return ((TypeVariable)typeVariable).getName();
    }

    public Iterable<Type> getBounds(Type typeVariable) {
        return Arrays.asList(((TypeVariable)typeVariable).getBounds());
    }

    public Type getRawType(Type parameterizedType) {
        return ((ParameterizedType)parameterizedType).getRawType();
    }

    public Iterable<Type> getTypeArguments(Type parameterizedType) {
        return Arrays.asList(((ParameterizedType)parameterizedType).getActualTypeArguments());
    }

    public Iterable<Type> getUpperBounds(Type wildcardType) {
        Type[] upperBounds = ((WildcardType)wildcardType).getUpperBounds();
        return Arrays.asList(upperBounds);
    }

    public Iterable<Type> getLowerBounds(Type wildcardType) {
        return Arrays.asList(((WildcardType)wildcardType).getLowerBounds());
    }
}

