/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.social.common.Invocation;
import org.exoplatform.social.common.LockInterceptor;
import org.exoplatform.web.filter.Filter;
import org.gatein.pc.api.invocation.InvocationException;

public class RequestQueueingFilter
implements Filter {
    private SessionLockInterceptor interceptor = new SessionLockInterceptor();

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            this.interceptor.invoke(new ServletFilterInvocation(chain, request, response));
        }
        catch (Throwable t) {
            throw new ServletException(t.getCause());
        }
    }

    public class ServletFilterInvocation
    implements Invocation {
        private FilterChain filterChain;
        private ServletRequest request;
        private ServletResponse response;

        public ServletFilterInvocation(FilterChain filterChain, ServletRequest request, ServletResponse response) {
            this.filterChain = filterChain;
            this.request = request;
            this.response = response;
        }

        public Object invokeNext() throws InvocationException {
            try {
                this.filterChain.doFilter(this.request, this.response);
            }
            catch (Throwable t) {
                throw new InvocationException(t.getCause());
            }
            return null;
        }

        public HttpServletRequest getRequest() {
            return (HttpServletRequest)this.request;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SessionLockInterceptor
    extends LockInterceptor<ServletFilterInvocation> {
        @Override
        protected Object getLockId(ServletFilterInvocation invocation) throws InvocationException {
            HttpServletRequest req = invocation.getRequest();
            return req.getRequestedSessionId();
        }
    }
}

