/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.checker;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.core.nodetype.NodeDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.checker.AbstractInconsistencyRepair;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.storage.JCRInvalidItemStateException;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCStorageConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCUtils;
import org.exoplatform.services.jcr.impl.storage.jdbc.PrimaryTypeNotFoundException;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.WorkspaceStorageConnectionFactory;

public class NodeRemover
extends AbstractInconsistencyRepair {
    private final NodeTypeDataManager nodeTypeManager;
    private final String iTable;

    public NodeRemover(WorkspaceStorageConnectionFactory connFactory, String iTable, NodeTypeDataManager nodeTypeManager) {
        super(connFactory);
        this.nodeTypeManager = nodeTypeManager;
        this.iTable = iTable;
    }

    void repairRow(JDBCStorageConnection conn, ResultSet resultSet) throws SQLException {
        try {
            this.validateIfRequiredByParent(conn, resultSet);
            this.removeChildrenItems(conn, resultSet);
            NodeData data = this.createNodeData(resultSet);
            conn.delete(data);
        }
        catch (JCRInvalidItemStateException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)e.getMessage(), (Throwable)((Object)e));
            }
        }
        catch (IllegalStateException e) {
            throw new SQLException(e);
        }
        catch (RepositoryException e) {
            throw new SQLException(e);
        }
        catch (IllegalNameException e) {
            throw new SQLException(e);
        }
    }

    private void validateIfRequiredByParent(JDBCStorageConnection conn, ResultSet resultSet) throws RepositoryException, SQLException, IllegalNameException {
        String parentId = this.exctractId(resultSet, "PARENT_ID");
        InternalQName nodeName = InternalQName.parse(resultSet.getString("NAME"));
        NodeData parent = null;
        try {
            parent = (NodeData)conn.getItemData(parentId);
        }
        catch (PrimaryTypeNotFoundException e) {
            return;
        }
        if (parent == null) {
            return;
        }
        NodeDefinitionData def = this.nodeTypeManager.getChildNodeDefinition(nodeName, parent.getPrimaryTypeName(), parent.getMixinTypeNames());
        if (!def.isResidualSet()) {
            throw new SQLException("Node is required by its parent.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChildrenItems(JDBCStorageConnection conn, ResultSet resultSet) throws SQLException, IllegalNameException, IllegalStateException, UnsupportedOperationException, InvalidItemStateException, RepositoryException {
        String parentId = resultSet.getString("ID");
        String selectStatement = "select * from " + this.iTable + " where I_CLASS = 1 and PARENT_ID = '" + parentId + "'";
        String deleteStatement = "delete from " + this.iTable + " where I_CLASS = 1 and PARENT_ID = '" + parentId + "'";
        PreparedStatement statement = conn.getJdbcConnection().prepareStatement(selectStatement);
        ResultSet selResult = statement.executeQuery();
        try {
            while (selResult.next()) {
                this.removeChildrenItems(conn, selResult);
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            JDBCUtils.freeResources(selResult, statement, null);
            throw throwable;
        }
        JDBCUtils.freeResources(selResult, statement, null);
        NodeData node = this.createNodeData(resultSet);
        for (PropertyData prop : conn.getChildPropertiesData(node)) {
            conn.delete(prop);
        }
        statement = conn.getJdbcConnection().prepareStatement(deleteStatement);
        try {
            statement.execute();
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            JDBCUtils.freeResources(null, statement, null);
            throw throwable;
        }
        JDBCUtils.freeResources(null, statement, null);
    }

    private NodeData createNodeData(ResultSet resultSet) throws SQLException, IllegalPathException, IllegalNameException {
        String nodeId = this.exctractId(resultSet, "ID");
        int orderNum = resultSet.getInt("N_ORDER_NUM");
        int version = resultSet.getInt("VERSION");
        QPath path = QPath.makeChildPath(QPath.parse("[]unknown-parent-node-remover"), this.extractName(resultSet));
        return new TransientNodeData(path, nodeId, version, Constants.NT_UNSTRUCTURED, new InternalQName[0], orderNum, "00exo0jcr0root0uuid0000000000000", new AccessControlList());
    }
}

