/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.mgt;

import java.util.Collection;
import org.jsecurity.authc.AuthenticationException;
import org.jsecurity.authc.AuthenticationInfo;
import org.jsecurity.authc.AuthenticationListener;
import org.jsecurity.authc.AuthenticationListenerRegistrar;
import org.jsecurity.authc.AuthenticationToken;
import org.jsecurity.authc.Authenticator;
import org.jsecurity.authc.pam.ModularAuthenticationStrategy;
import org.jsecurity.authc.pam.ModularRealmAuthenticator;
import org.jsecurity.mgt.RealmSecurityManager;
import org.jsecurity.realm.Realm;
import org.jsecurity.util.LifecycleUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AuthenticatingSecurityManager
extends RealmSecurityManager
implements AuthenticationListenerRegistrar {
    private Authenticator authenticator = new ModularRealmAuthenticator();

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) throws IllegalArgumentException {
        if (authenticator == null) {
            String msg = "Authenticator argument cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        this.authenticator = authenticator;
    }

    public void setModularAuthenticationStrategy(ModularAuthenticationStrategy strategy) {
        if (!(this.authenticator instanceof ModularRealmAuthenticator)) {
            String msg = "Configuring a ModularAuthenticationStrategy is only applicable when the underlying Authenticator implementation is a " + ModularRealmAuthenticator.class.getName() + " implementation.  This SecurityManager has been configured with an Authenticator of type " + this.authenticator.getClass().getName();
            throw new IllegalStateException(msg);
        }
        ((ModularRealmAuthenticator)this.authenticator).setModularAuthenticationStrategy(strategy);
    }

    @Override
    public void setAuthenticationListeners(Collection<AuthenticationListener> listeners) {
        this.assertAuthenticatorListenerSupport();
        if (!(this.authenticator instanceof AuthenticationListenerRegistrar)) {
            String msg = "Configuring a ModularAuthenticationStrategy is only applicable when the underlying Authenticator implementation is a " + AuthenticationListenerRegistrar.class.getName() + " implementation.  This SecurityManager has been configured with an Authenticator of type " + this.authenticator.getClass().getName() + ", which does not implement that interface.";
            throw new IllegalStateException(msg);
        }
        ((AuthenticationListenerRegistrar)((Object)this.authenticator)).setAuthenticationListeners(listeners);
    }

    private void assertAuthenticatorListenerSupport() {
        if (!(this.authenticator instanceof AuthenticationListenerRegistrar)) {
            String msg = "AuthenticationListener registration failed:  The underlying Authenticator instance of type [" + this.authenticator.getClass().getName() + "] does not implement the " + AuthenticationListenerRegistrar.class.getName() + " interface and therefore cannot support " + "runtime registration of AuthenticationListeners.";
            throw new IllegalStateException(msg);
        }
    }

    @Override
    public void add(AuthenticationListener listener) {
        this.assertAuthenticatorListenerSupport();
        Authenticator authc = this.getAuthenticator();
        ((AuthenticationListenerRegistrar)((Object)authc)).add(listener);
    }

    @Override
    public boolean remove(AuthenticationListener listener) {
        Authenticator authc = this.getAuthenticator();
        return authc instanceof AuthenticationListenerRegistrar && ((AuthenticationListenerRegistrar)((Object)authc)).remove(listener);
    }

    @Override
    public void setRealms(Collection<Realm> realms) {
        super.setRealms(realms);
        if (this.authenticator instanceof ModularRealmAuthenticator) {
            ((ModularRealmAuthenticator)this.authenticator).setRealms(realms);
        }
    }

    @Override
    protected void beforeRealmsDestroyed() {
        this.beforeAuthenticatorDestroyed();
        this.destroyAuthenticator();
    }

    protected void beforeAuthenticatorDestroyed() {
    }

    protected void destroyAuthenticator() {
        LifecycleUtils.destroy(this.getAuthenticator());
    }

    @Override
    public AuthenticationInfo authenticate(AuthenticationToken token) throws AuthenticationException {
        this.ensureRealms();
        return this.authenticator.authenticate(token);
    }
}

