/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.EventFilter;
import javax.portlet.filter.FilterChain;
import javax.portlet.filter.FilterConfig;
import javax.portlet.filter.RenderFilter;
import javax.portlet.filter.ResourceFilter;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.ApplicationStatistic;
import org.exoplatform.portal.application.ApplicationStatisticService;

public class ApplicationMonitoringFilter
implements ActionFilter,
RenderFilter,
EventFilter,
ResourceFilter {
    public void init(FilterConfig cfg) throws PortletException {
    }

    public void destroy() {
    }

    public void doFilter(ActionRequest req, ActionResponse resp, FilterChain chain) throws IOException, PortletException {
        ApplicationStatistic stat = this.get((PortletRequest)req);
        if (stat != null) {
            long t = -System.currentTimeMillis();
            chain.doFilter(req, resp);
            stat.logTime(t += System.currentTimeMillis());
        } else {
            chain.doFilter(req, resp);
        }
    }

    public void doFilter(EventRequest req, EventResponse resp, FilterChain chain) throws IOException, PortletException {
        ApplicationStatistic stat = this.get((PortletRequest)req);
        if (stat != null) {
            long t = -System.currentTimeMillis();
            chain.doFilter(req, resp);
            stat.logTime(t += System.currentTimeMillis());
        } else {
            chain.doFilter(req, resp);
        }
    }

    public void doFilter(RenderRequest req, RenderResponse resp, FilterChain chain) throws IOException, PortletException {
        ApplicationStatistic stat = this.get((PortletRequest)req);
        if (stat != null) {
            long t = -System.currentTimeMillis();
            chain.doFilter(req, resp);
            stat.logTime(t += System.currentTimeMillis());
        } else {
            chain.doFilter(req, resp);
        }
    }

    public void doFilter(ResourceRequest req, ResourceResponse resp, FilterChain chain) throws IOException, PortletException {
        ApplicationStatistic stat = this.get((PortletRequest)req);
        if (stat != null) {
            long t = -System.currentTimeMillis();
            chain.doFilter(req, resp);
            stat.logTime(t += System.currentTimeMillis());
        } else {
            chain.doFilter(req, resp);
        }
    }

    private ApplicationStatistic get(PortletRequest req) throws IOException, PortletException {
        PortalContainer container = PortalContainer.getInstance();
        ApplicationStatisticService service = (ApplicationStatisticService)container.getComponentInstance(ApplicationStatisticService.class);
        if (service != null) {
            PortletConfig portletConfig = (PortletConfig)req.getAttribute("javax.portlet.config");
            String portletName = portletConfig.getPortletName();
            String phase = (String)req.getAttribute("javax.portlet.lifecycle_phase");
            String applicationId = portletName + "/" + phase;
            return service.getApplicationStatistic(applicationId);
        }
        return null;
    }
}

