/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.impl.util.io.SpoolFile;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class EditableValueData
extends TransientValueData {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.EditableValueData");

    public EditableValueData(byte[] bytes, int orderNumber, FileCleaner fileCleaner, int maxBufferSize, File tempDirectory) throws IOException {
        this.delegate = new NewEditableValueData(bytes, orderNumber, fileCleaner, maxBufferSize, tempDirectory);
    }

    public EditableValueData(SpoolFile spoolFile, int orderNumber, FileCleaner fileCleaner, int maxBufferSize, File tempDirectory) throws IOException {
        this.delegate = new NewEditableValueData(spoolFile, orderNumber, fileCleaner, maxBufferSize, tempDirectory);
    }

    public EditableValueData(InputStream stream, int orderNumber, FileCleaner fileCleaner, int maxBufferSize, File tempDirectory) throws IOException {
        this.delegate = new NewEditableValueData(stream, orderNumber, fileCleaner, maxBufferSize, tempDirectory);
    }

    public void update(InputStream stream, long length, long position) throws IOException {
        ((NewEditableValueData)this.delegate).update(stream, length, position);
    }

    public void setLength(long size) throws IOException {
        ((NewEditableValueData)this.delegate).setLength(size);
    }

    protected class NewEditableValueData
    extends TransientValueData.NewValueData {
        protected final int maxIOBuffSize;

        public NewEditableValueData(byte[] bytes, int orderNumber, FileCleaner fileCleaner, int maxBufferSize, File tempDirectory) throws IOException {
            super(orderNumber, bytes, null, null, fileCleaner, maxBufferSize, tempDirectory, true, true);
            this.maxIOBuffSize = this.calcMaxIOSize();
            this.spooled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NewEditableValueData(SpoolFile spoolFile, int orderNumber, FileCleaner fileCleaner, int maxBufferSize, File tempDirectory) throws IOException {
            super(orderNumber, null, null, null, fileCleaner, maxBufferSize, tempDirectory, true, true);
            this.maxIOBuffSize = this.calcMaxIOSize();
            SpoolFile sf = null;
            AbstractInterruptibleChannel sch = null;
            try {
                sf = SpoolFile.createTempFile("jcrvdedit", null, tempDirectory);
                sch = new RandomAccessFile(sf, "rw").getChannel();
                FileChannel sourceCh = PrivilegedFileHelper.fileInputStream((File)spoolFile).getChannel();
                try {
                    ((FileChannel)sch).transferFrom(sourceCh, 0L, sourceCh.size());
                    Object var11_11 = null;
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    sourceCh.close();
                    throw throwable;
                }
                sourceCh.close();
                {
                }
            }
            catch (IOException e) {
                block7: {
                    try {
                        sch.close();
                        PrivilegedFileHelper.delete((File)sf);
                    }
                    catch (Exception e1) {
                        if (!LOG.isTraceEnabled()) break block7;
                        LOG.trace((Object)("An exception occurred: " + e1.getMessage()));
                    }
                }
                throw new IOException("init error " + e.getMessage()){

                    public Throwable getCause() {
                        return e;
                    }
                };
            }
            this.data = null;
            this.spoolFile = sf;
            this.spoolChannel = sch;
            this.spooled = true;
        }

        public NewEditableValueData(InputStream stream, int orderNumber, FileCleaner fileCleaner, int maxBufferSize, File tempDirectory) throws IOException {
            super(orderNumber, null, null, null, fileCleaner, maxBufferSize, tempDirectory, true, true);
            this.maxIOBuffSize = this.calcMaxIOSize();
            SpoolFile sf = SpoolFile.createTempFile("jcrvdedit", null, tempDirectory);
            FileOutputStream sfout = PrivilegedFileHelper.fileOutputStream((File)sf);
            try {
                byte[] tmpBuff = new byte[2048];
                int read = 0;
                int len = 0;
                while ((read = stream.read(tmpBuff)) >= 0) {
                    ((OutputStream)sfout).write(tmpBuff, 0, read);
                    len += read;
                }
            }
            catch (IOException e) {
                block5: {
                    try {
                        ((OutputStream)sfout).close();
                        PrivilegedFileHelper.delete((File)sf);
                    }
                    catch (Exception e1) {
                        if (!LOG.isTraceEnabled()) break block5;
                        LOG.trace((Object)("An exception occurred: " + e1.getMessage()));
                    }
                }
                throw new IOException("init error " + e.getMessage()){

                    public Throwable getCause() {
                        return e;
                    }
                };
            }
            this.data = null;
            this.spoolFile = sf;
            this.spoolChannel = PrivilegedFileHelper.randomAccessFile((File)sf, (String)"rw").getChannel();
            this.spooled = true;
        }

        protected int calcMaxIOSize() {
            return this.maxBufferSize < 1024 ? 1024 : (this.maxBufferSize < 256000 ? this.maxBufferSize : 256000);
        }

        protected int calcBuffSize(long length) {
            int buffSize = (int)(length > (long)this.maxIOBuffSize ? (long)this.maxIOBuffSize : length / 4L);
            buffSize = buffSize < 1024 ? 256 : buffSize;
            return buffSize;
        }

        public void update(InputStream stream, long length, long position) throws IOException {
            if (position < 0L) {
                throw new IOException("Position must be higher or equals 0. But given " + position);
            }
            if (length < 0L) {
                throw new IOException("Length must be higher or equals 0. But given " + length);
            }
            if (this.isByteArray()) {
                long newSize;
                long updateSize = position + length;
                long l = newSize = updateSize > (long)this.data.length ? updateSize : (long)this.data.length;
                if (newSize <= (long)this.maxBufferSize && newSize <= Integer.MAX_VALUE || this.maxBufferSize <= 0 || this.tempDirectory == null) {
                    byte[] newBytes = new byte[(int)newSize];
                    int newIndex = 0;
                    newIndex = (int)position;
                    if (newIndex > 0) {
                        System.arraycopy(this.data, 0, newBytes, 0, newIndex < this.data.length ? newIndex : this.data.length);
                    }
                    int i = -1;
                    boolean doRead = true;
                    byte[] buff = new byte[this.calcBuffSize(length)];
                    while (doRead && (i = stream.read(buff)) >= 0) {
                        if (newIndex + i > newBytes.length) {
                            i = newBytes.length - newIndex;
                            doRead = false;
                        }
                        System.arraycopy(buff, 0, newBytes, newIndex, i);
                        newIndex += i;
                    }
                    if (newIndex < this.data.length) {
                        System.arraycopy(this.data, newIndex, newBytes, newIndex, this.data.length - newIndex);
                    }
                    this.data = newBytes;
                    this.spoolFile = null;
                    this.spoolChannel = null;
                } else {
                    SpoolFile chf = null;
                    AbstractInterruptibleChannel chch = null;
                    long newIndex = 0L;
                    try {
                        chf = SpoolFile.createTempFile("jcrvdedit", null, this.tempDirectory);
                        chch = new RandomAccessFile(chf, "rw").getChannel();
                        MappedByteBuffer bb = ((FileChannel)chch).map(FileChannel.MapMode.READ_WRITE, position + length, 0L);
                        bb.force();
                        bb = null;
                        ReadableByteChannel bch = Channels.newChannel(new ByteArrayInputStream(this.data));
                        newIndex = (int)position;
                        if (newIndex > 0L) {
                            ((FileChannel)chch).transferFrom(bch, 0L, newIndex < (long)this.data.length ? newIndex : (long)this.data.length);
                            bch.close();
                        }
                        ReadableByteChannel sch = Channels.newChannel(stream);
                        ((FileChannel)chch).transferFrom(sch, newIndex, length);
                        sch.close();
                        if ((newIndex += length) < (long)this.data.length) {
                            ((FileChannel)chch).transferFrom(bch, newIndex, (long)this.data.length - newIndex);
                        }
                        bch.close();
                    }
                    catch (IOException e) {
                        block16: {
                            try {
                                chch.close();
                                PrivilegedFileHelper.delete((File)chf);
                            }
                            catch (Exception e1) {
                                if (!LOG.isTraceEnabled()) break block16;
                                LOG.trace((Object)("An exception occurred: " + e1.getMessage()));
                            }
                        }
                        throw new IOException("update error " + e.getMessage()){

                            public Throwable getCause() {
                                return e;
                            }
                        };
                    }
                    this.spoolFile = chf;
                    this.spoolChannel = chch;
                    this.data = null;
                }
            } else {
                MappedByteBuffer bb = this.spoolChannel.map(FileChannel.MapMode.READ_WRITE, position, length);
                ReadableByteChannel ch = Channels.newChannel(stream);
                ch.read(bb);
                ch.close();
                bb.force();
            }
        }

        public void setLength(long size) throws IOException {
            if (size < 0L) {
                throw new IOException("Size must be higher or equals 0. But given " + size);
            }
            if (this.isByteArray()) {
                if (size < (long)this.maxBufferSize || this.maxBufferSize <= 0 || this.tempDirectory == null) {
                    byte[] newBytes;
                    System.arraycopy(this.data, 0, newBytes, 0, this.data.length < (newBytes = new byte[(int)size]).length ? this.data.length : newBytes.length);
                    this.data = newBytes;
                } else {
                    SpoolFile chf = null;
                    AbstractInterruptibleChannel chch = null;
                    try {
                        chf = SpoolFile.createTempFile("jcrvdedit", null, this.tempDirectory);
                        chch = new RandomAccessFile(chf, "rw").getChannel();
                        ReadableByteChannel bch = Channels.newChannel(new ByteArrayInputStream(this.data));
                        ((FileChannel)chch).transferFrom(bch, 0L, this.data.length);
                        bch.close();
                        if (((FileChannel)chch).size() < size) {
                            MappedByteBuffer bb = ((FileChannel)chch).map(FileChannel.MapMode.READ_WRITE, size, 0L);
                            bb.force();
                        }
                    }
                    catch (IOException e) {
                        block19: {
                            try {
                                chch.close();
                                PrivilegedFileHelper.delete((File)chf);
                            }
                            catch (Exception e1) {
                                if (!LOG.isTraceEnabled()) break block19;
                                LOG.trace((Object)("An exception occurred: " + e1.getMessage()));
                            }
                        }
                        throw new IOException("setLength(" + size + ") error. " + e.getMessage()){

                            public Throwable getCause() {
                                return e;
                            }
                        };
                    }
                    this.spoolFile = chf;
                    this.spoolChannel = chch;
                    this.data = null;
                }
            } else if (size < (long)this.maxBufferSize) {
                ByteBuffer bb = ByteBuffer.allocate((int)size);
                this.spoolChannel.force(false);
                this.spoolChannel.position(0L);
                this.spoolChannel.read(bb);
                byte[] tmpb = null;
                if (bb.hasArray()) {
                    tmpb = bb.array();
                } else {
                    tmpb = new byte[bb.capacity()];
                    bb.get(tmpb);
                }
                this.spoolChannel.close();
                if (!PrivilegedFileHelper.delete((File)this.spoolFile)) {
                    if (this.fileCleaner != null) {
                        LOG.info((Object)("Could not remove file. Add to fileCleaner " + this.spoolFile));
                        this.fileCleaner.addFile(this.spoolFile);
                    } else {
                        LOG.warn((Object)("Could not remove temporary file on switch to bytes, fileCleaner not found. " + PrivilegedFileHelper.getAbsolutePath((File)this.spoolFile)));
                    }
                }
                this.data = tmpb;
                this.spoolChannel = null;
                this.spoolFile = null;
            } else if (this.spoolChannel.size() < size) {
                MappedByteBuffer bb = this.spoolChannel.map(FileChannel.MapMode.READ_WRITE, size, 0L);
                bb.force();
            } else {
                this.spoolChannel.truncate(size);
            }
        }
    }
}

