/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest.api.models;

import java.util.HashMap;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityStreamRestOut
extends HashMap<String, Object> {
    public ActivityStreamRestOut() {
        this.initialize();
    }

    public ActivityStreamRestOut(ActivityStream activityStream, String portalContainerName) {
        this.initialize();
        this.setType(activityStream.getType().toString());
        this.setPrettyId(activityStream.getPrettyId());
        this.setFaviconUrl(activityStream.getFaviconUrl());
        this.setTitle(activityStream.getTitle());
        this.setPermaLink(activityStream.getPermaLink());
        if (activityStream.getType() != null) {
            IdentityManager identityManager;
            Identity identity;
            ActivityStream.Type activityStreamType = activityStream.getType();
            if (activityStreamType.equals((Object)ActivityStream.Type.SPACE)) {
                SpaceService spaceService = Util.getSpaceService(portalContainerName);
                Space space = spaceService.getSpaceByPrettyName(activityStream.getPrettyId());
                if (space != null && space.getDisplayName() != null) {
                    this.setFullName(space.getDisplayName());
                }
            } else if (activityStreamType.equals((Object)ActivityStream.Type.USER) && (identity = (identityManager = Util.getIdentityManager(portalContainerName)).getOrCreateIdentity("organization", activityStream.getPrettyId(), true)) != null && identity.getProfile() != null && identity.getProfile().getFullName() != null) {
                this.setFullName(identity.getProfile().getFullName());
            }
        }
    }

    public String getType() {
        return (String)this.get(Field.TYPE.toString());
    }

    public void setType(String type) {
        if (type == null) {
            this.put(Field.TYPE.toString(), "");
        } else {
            this.put(Field.TYPE.toString(), type);
        }
    }

    public String getPrettyId() {
        return (String)this.get(Field.PRETTY_ID.toString());
    }

    public void setPrettyId(String prettyId) {
        if (prettyId == null) {
            this.put(Field.PRETTY_ID.toString(), "");
        } else {
            this.put(Field.PRETTY_ID.toString(), prettyId);
        }
    }

    public String getFullName() {
        return (String)this.get(Field.FULL_NAME.toString());
    }

    public void setFullName(String fullName) {
        if (fullName == null) {
            this.put(Field.FULL_NAME.toString(), "");
        } else {
            this.put(Field.FULL_NAME.toString(), fullName);
        }
    }

    public String getTitle() {
        return (String)this.get(Field.TITLE.toString());
    }

    public void setTitle(String title) {
        if (title == null) {
            this.put(Field.TITLE.toString(), "");
        } else {
            this.put(Field.TITLE.toString(), title);
        }
    }

    public String getPermaLink() {
        return (String)this.get(Field.PERMA_LINK.toString());
    }

    public void setPermaLink(String permalink) {
        if (permalink == null) {
            this.put(Field.PERMA_LINK.toString(), "");
        } else {
            this.put(Field.PERMA_LINK.toString(), Util.getBaseUrl() + permalink);
        }
    }

    public String getFaviconUrl() {
        return (String)this.get(Field.FAVICON_URL.toString());
    }

    public void setFaviconUrl(String faviconUrl) {
        if (faviconUrl == null) {
            this.put(Field.FAVICON_URL.toString(), "");
        } else {
            this.put(Field.FAVICON_URL.toString(), Util.getBaseUrl() + faviconUrl);
        }
    }

    private void initialize() {
        this.setType("");
        this.setPrettyId("");
        this.setFullName(null);
        this.setFaviconUrl(null);
        this.setTitle("");
        this.setPermaLink(null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Field {
        TYPE("type"),
        PRETTY_ID("prettyId"),
        FULL_NAME("fullName"),
        FAVICON_URL("faviconUrl"),
        TITLE("title"),
        PERMA_LINK("permaLink");

        private final String fieldName;

        private Field(String str) {
            this.fieldName = str;
        }

        public String toString() {
            return this.fieldName;
        }
    }
}

