/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest.api.models;

import java.util.HashMap;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.social.service.rest.api.models.ProfileRestOut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityRestOut
extends HashMap<String, Object> {
    public IdentityRestOut() {
        this.initialize();
    }

    public IdentityRestOut(String identityId, String portalContainerName) {
        IdentityManager identityManager = Util.getIdentityManager(portalContainerName);
        Identity identity = identityManager.getIdentity(identityId, true);
        this.setId(identity.getId());
        this.setRemoteId(identity.getRemoteId());
        this.setProviderId(identity.getProviderId());
        this.setProfile(new ProfileRestOut(identity.getProfile()));
        Util.buildAbsoluteAvatarURL(this);
    }

    public IdentityRestOut(Identity identity) {
        this.setId(identity.getId());
        this.setRemoteId(identity.getRemoteId());
        this.setProviderId(identity.getProviderId());
        this.setProfile(new ProfileRestOut(identity.getProfile()));
        Util.buildAbsoluteAvatarURL(this);
    }

    public String getId() {
        return (String)this.get(Field.ID.toString());
    }

    public void setId(String id) {
        if (id != null) {
            this.put(Field.ID.toString(), id);
        } else {
            this.put(Field.ID.toString(), "");
        }
    }

    public String getRemoteId() {
        return (String)this.get(Field.REMOTE_ID.toString());
    }

    public void setRemoteId(String remoteId) {
        if (remoteId != null) {
            this.put(Field.REMOTE_ID.toString(), remoteId);
        } else {
            this.put(Field.REMOTE_ID.toString(), "");
        }
    }

    public String getProviderId() {
        return (String)this.get(Field.PROVIDER_ID.toString());
    }

    public void setProviderId(String providerId) {
        if (providerId != null) {
            this.put(Field.PROVIDER_ID.toString(), providerId);
        } else {
            this.put(Field.PROVIDER_ID.toString(), "");
        }
    }

    public ProfileRestOut getProfile() {
        return (ProfileRestOut)this.get(Field.PROFILE.toString());
    }

    public void setProfile(ProfileRestOut profile) {
        if (profile != null) {
            this.put(Field.PROFILE.toString(), profile);
        } else {
            this.put(Field.PROFILE.toString(), new HashMap());
            Util.buildAbsoluteAvatarURL(this);
        }
    }

    private void initialize() {
        this.setId("");
        this.setProfile(new ProfileRestOut());
        this.setProviderId("");
        this.setRemoteId("");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Field {
        ID("id"),
        REMOTE_ID("remoteId"),
        PROVIDER_ID("providerId"),
        PROFILE("profile");

        private final String fieldName;

        private Field(String string2) {
            this.fieldName = string2;
        }

        public String toString() {
            return this.fieldName;
        }
    }
}

