/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.web;

import java.net.InetAddress;
import java.util.Collection;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.mgt.DefaultSecurityManager;
import org.jsecurity.realm.Realm;
import org.jsecurity.session.Session;
import org.jsecurity.session.mgt.SessionManager;
import org.jsecurity.subject.PrincipalCollection;
import org.jsecurity.subject.Subject;
import org.jsecurity.util.LifecycleUtils;
import org.jsecurity.web.WebRememberMeManager;
import org.jsecurity.web.WebUtils;
import org.jsecurity.web.session.DefaultWebSessionManager;
import org.jsecurity.web.session.ServletContainerSessionManager;
import org.jsecurity.web.session.WebSessionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWebSecurityManager
extends DefaultSecurityManager {
    private static final Log log = LogFactory.getLog(DefaultWebSecurityManager.class);
    public static final String HTTP_SESSION_MODE = "http";
    public static final String JSECURITY_SESSION_MODE = "jsecurity";
    public static final String PRINCIPALS_SESSION_KEY = DefaultWebSecurityManager.class.getName() + "_PRINCIPALS_SESSION_KEY";
    public static final String AUTHENTICATED_SESSION_KEY = DefaultWebSecurityManager.class.getName() + "_AUTHENTICATED_SESSION_KEY";
    private String sessionMode = "http";

    public DefaultWebSecurityManager() {
        this.setRememberMeManager(new WebRememberMeManager());
    }

    public DefaultWebSecurityManager(Realm singleRealm) {
        this.setRealm(singleRealm);
    }

    public DefaultWebSecurityManager(Collection<Realm> realms) {
        this.setRealms(realms);
    }

    public void setRememberMeCookiePath(String rememberMeCookiePath) {
        ((WebRememberMeManager)this.getRememberMeManager()).setCookiePath(rememberMeCookiePath);
    }

    public void setRememberMeCookieMaxAge(Integer rememberMeMaxAge) {
        ((WebRememberMeManager)this.getRememberMeManager()).setCookieMaxAge(rememberMeMaxAge);
    }

    private DefaultWebSessionManager getSessionManagerForCookieAttributes() {
        SessionManager sessionManager = this.getSessionManager();
        if (!(sessionManager instanceof DefaultWebSessionManager)) {
            String msg = "The convenience passthrough methods for setting session id cookie attributes are only available when the underlying SessionManager implementation is " + DefaultWebSessionManager.class.getName() + ", which is enabled by default when the " + "sessionMode is 'jsecurity'.";
            throw new IllegalStateException(msg);
        }
        return (DefaultWebSessionManager)sessionManager;
    }

    public void setSessionIdCookieName(String name) {
        this.getSessionManagerForCookieAttributes().setSessionIdCookieName(name);
    }

    public void setSessionIdCookiePath(String path) {
        this.getSessionManagerForCookieAttributes().setSessionIdCookiePath(path);
    }

    public void setSessionIdCookieMaxAge(int maxAge) {
        this.getSessionManagerForCookieAttributes().setSessionIdCookieMaxAge(maxAge);
    }

    public void setSessionIdCookieSecure(boolean secure) {
        this.getSessionManagerForCookieAttributes().setSessionIdCookieSecure(secure);
    }

    public String getSessionMode() {
        return this.sessionMode;
    }

    public void setSessionMode(String sessionMode) {
        if (sessionMode == null || !sessionMode.equals(HTTP_SESSION_MODE) && !sessionMode.equals(JSECURITY_SESSION_MODE)) {
            String msg = "Invalid sessionMode [" + sessionMode + "].  Allowed values are " + "public static final String constants in the " + this.getClass().getName() + " class: '" + HTTP_SESSION_MODE + "' or '" + JSECURITY_SESSION_MODE + "', with '" + HTTP_SESSION_MODE + "' being the default.";
            throw new IllegalArgumentException(msg);
        }
        boolean recreate = this.sessionMode == null || !this.sessionMode.equals(sessionMode);
        this.sessionMode = sessionMode;
        if (recreate) {
            LifecycleUtils.destroy(this.getSessionManager());
            SessionManager sm = this.createSessionManager();
            this.setSessionManager(sm);
        }
    }

    public boolean isHttpSessionMode() {
        return this.sessionMode == null || this.sessionMode.equals(HTTP_SESSION_MODE);
    }

    @Override
    protected SessionManager newSessionManagerInstance() {
        if (this.isHttpSessionMode()) {
            if (log.isInfoEnabled()) {
                log.info((Object)"http mode - enabling ServletContainerSessionManager (Http Sessions)");
            }
            return new ServletContainerSessionManager();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"jsecurity mode - enabling WebSessionManager (JSecurity heterogenous sessions)");
        }
        return new DefaultWebSessionManager();
    }

    protected PrincipalCollection getPrincipals(Session session) {
        PrincipalCollection principals = null;
        if (session != null) {
            principals = (PrincipalCollection)session.getAttribute(PRINCIPALS_SESSION_KEY);
        }
        return principals;
    }

    protected PrincipalCollection getPrincipals(Session existing, ServletRequest servletRequest, ServletResponse servletResponse) {
        PrincipalCollection principals = this.getPrincipals(existing);
        if (principals == null && (principals = this.getRememberedIdentity()) != null && existing != null) {
            existing.setAttribute(PRINCIPALS_SESSION_KEY, principals);
        }
        return principals;
    }

    protected boolean isAuthenticated(Session session) {
        Boolean value = null;
        if (session != null) {
            value = (Boolean)session.getAttribute(AUTHENTICATED_SESSION_KEY);
        }
        return value != null && value != false;
    }

    protected boolean isAuthenticated(Session existing, ServletRequest servletRequest, ServletResponse servletResponse) {
        return this.isAuthenticated(existing);
    }

    @Override
    public Subject createSubject() {
        ServletRequest request = WebUtils.getRequiredServletRequest();
        ServletResponse response = WebUtils.getRequiredServletResponse();
        return this.createSubject(request, response);
    }

    public Subject createSubject(ServletRequest request, ServletResponse response) {
        Session session = ((WebSessionManager)this.getSessionManager()).getSession(request, response);
        if (session == null && log.isTraceEnabled()) {
            log.trace((Object)"No session found for the incoming request.  The Subject instance created for the incoming request will not have an associated Session.");
        }
        return this.createSubject(session, request, response);
    }

    public Subject createSubject(Session existing, ServletRequest request, ServletResponse response) {
        PrincipalCollection principals = this.getPrincipals(existing, request, response);
        boolean authenticated = this.isAuthenticated(existing, request, response);
        return this.createSubject(principals, authenticated, existing, request, response);
    }

    protected Subject createSubject(PrincipalCollection principals, boolean authenticated, Session existing, ServletRequest request, ServletResponse response) {
        InetAddress inetAddress = WebUtils.getInetAddress(request);
        return this.createSubject(principals, existing, authenticated, inetAddress);
    }

    @Override
    protected void bind(Subject subject) {
        super.bind(subject);
        ServletRequest request = WebUtils.getRequiredServletRequest();
        ServletResponse response = WebUtils.getRequiredServletResponse();
        this.bind(subject, request, response);
    }

    protected void bind(Subject subject, ServletRequest request, ServletResponse response) {
        Session session;
        PrincipalCollection principals = subject.getPrincipals();
        if (principals != null && !principals.isEmpty()) {
            session = subject.getSession();
            session.setAttribute(PRINCIPALS_SESSION_KEY, principals);
        } else {
            session = subject.getSession(false);
            if (session != null) {
                session.removeAttribute(PRINCIPALS_SESSION_KEY);
            }
        }
        if (subject.isAuthenticated()) {
            session = subject.getSession();
            session.setAttribute(AUTHENTICATED_SESSION_KEY, subject.isAuthenticated());
        } else {
            session = subject.getSession(false);
            if (session != null) {
                session.removeAttribute(AUTHENTICATED_SESSION_KEY);
            }
        }
    }
}

