/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.itemfilters;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.core.JCRPath;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.itemfilters.ExactQPathEntryFilter;
import org.exoplatform.services.jcr.impl.core.itemfilters.ItemDataFilter;
import org.exoplatform.services.jcr.impl.core.itemfilters.PatternQPathEntry;
import org.exoplatform.services.jcr.impl.core.itemfilters.PatternQPathEntryFilter;
import org.exoplatform.services.jcr.impl.core.itemfilters.QPathEntryFilter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNamePatternFilter
implements ItemDataFilter {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.ItemDataNamePatternFilter");
    private final SessionImpl session;
    private final boolean getAllItems;
    private final List<QPathEntryFilter> subFilters;
    private final QPathEntry[] exactNames;
    private final String[] wildcardExpressions;
    private Pattern[] expressionNamePatterns = null;

    public AbstractNamePatternFilter(String namePattern, SessionImpl session) throws RepositoryException {
        this.session = session;
        StringTokenizer parser = new StringTokenizer(namePattern, "|");
        boolean getAll = false;
        ArrayList<QPathEntryFilter> filters = new ArrayList<QPathEntryFilter>();
        ArrayList<QPathEntry> exactNamesList = new ArrayList<QPathEntry>();
        ArrayList<String> wildcardExpressionsList = new ArrayList<String>();
        HashSet<String> existedTokens = new HashSet<String>();
        while (parser.hasMoreTokens()) {
            String token = parser.nextToken().trim();
            if (existedTokens.contains(token)) continue;
            existedTokens.add(token);
            if (token.equals("*") || token.equals("*:*") || token.equals("*:*[*]")) {
                getAll = true;
                filters.clear();
                break;
            }
            if (token.startsWith(":")) {
                throw new RepositoryException("Name pattern can not start with colon.");
            }
            QPathEntry entry = null;
            if (this.isExactName(token)) {
                JCRPath path = session.getLocationFactory().parseRelPath(token);
                QPathEntry[] entries = path.getInternalPath().getEntries();
                entry = entries[entries.length - 1];
                exactNamesList.add(entry);
                filters.add(new ExactQPathEntryFilter(entry));
                continue;
            }
            entry = this.parsePatternQPathEntry(token, session);
            wildcardExpressionsList.add(token);
            filters.add(new PatternQPathEntryFilter(entry));
        }
        this.getAllItems = getAll;
        if (this.getAllItems) {
            this.subFilters = null;
            this.exactNames = null;
            this.wildcardExpressions = null;
        } else {
            this.subFilters = filters;
            this.exactNames = new QPathEntry[exactNamesList.size()];
            exactNamesList.toArray(this.exactNames);
            this.wildcardExpressions = new String[wildcardExpressionsList.size()];
            wildcardExpressionsList.toArray(this.wildcardExpressions);
        }
    }

    @Override
    public boolean accept(ItemData item) {
        if (this.getAllItems) {
            return true;
        }
        if (this.expressionNamePatterns == null) {
            this.initializePatterns();
        }
        try {
            QPathEntry itemEntry = item.getQPath().getEntries()[item.getQPath().getDepth()];
            for (QPathEntry entry : this.exactNames) {
                if (!entry.equals(itemEntry)) continue;
                return true;
            }
            JCRPath.PathElement[] pathElements = this.session.getLocationFactory().createRelPath(new QPathEntry[]{itemEntry});
            String name = pathElements[0].getAsString(true);
            for (Pattern pattern : this.expressionNamePatterns) {
                if (!pattern.matcher(name).matches()) continue;
                return true;
            }
        }
        catch (RepositoryException e) {
            LOG.error((Object)("Cannot parse JCR name for " + item.getQPath().getAsString()), (Throwable)e);
        }
        return false;
    }

    @Override
    public List<? extends ItemData> accept(List<? extends ItemData> itemData) {
        if (this.getAllItems) {
            return itemData;
        }
        if (this.expressionNamePatterns == null) {
            this.initializePatterns();
        }
        ArrayList<ItemData> result = new ArrayList<ItemData>();
        for (int i = 0; i < itemData.size(); ++i) {
            if (!this.accept(itemData.get(i))) continue;
            result.add(itemData.get(i));
        }
        return result;
    }

    public boolean isLookingAllData() {
        return this.getAllItems;
    }

    public List<QPathEntryFilter> getQPathEntryFilters() {
        return this.subFilters;
    }

    private void initializePatterns() {
        this.expressionNamePatterns = new Pattern[this.wildcardExpressions.length];
        for (int i = 0; i < this.wildcardExpressions.length; ++i) {
            StringBuilder sb = new StringBuilder();
            block5: for (char c : this.wildcardExpressions[i].toCharArray()) {
                switch (c) {
                    case '*': {
                        sb.append(".*");
                        continue block5;
                    }
                    case '!': 
                    case '$': 
                    case '&': 
                    case '(': 
                    case ')': 
                    case '+': 
                    case ',': 
                    case '-': 
                    case '.': 
                    case ':': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '?': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '{': 
                    case '}': {
                        sb.append('\\');
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            if (this.wildcardExpressions[i].indexOf(91) == -1) {
                sb.append("\\[.*\\]");
            }
            this.expressionNamePatterns[i] = Pattern.compile(sb.toString());
        }
    }

    private QPathEntry parsePatternQPathEntry(String namePattern, SessionImpl session) throws RepositoryException {
        String localName;
        String namespaceURI;
        int colonIndex = namePattern.indexOf(58);
        int bracketIndex = namePattern.lastIndexOf(91);
        int index = this.getDefaultIndex();
        if (bracketIndex != -1) {
            int rbracketIndex = namePattern.lastIndexOf(93);
            if (rbracketIndex < bracketIndex) {
                throw new RepositoryException("Malformed pattern expression " + namePattern);
            }
            index = Integer.parseInt(namePattern.substring(bracketIndex + 1, rbracketIndex));
        }
        if (colonIndex == -1) {
            namespaceURI = "";
            localName = bracketIndex == -1 ? namePattern : namePattern.substring(0, bracketIndex);
        } else {
            String prefix = namePattern.substring(0, colonIndex);
            localName = bracketIndex == -1 ? namePattern.substring(colonIndex + 1) : namePattern.substring(0, bracketIndex);
            namespaceURI = prefix.indexOf("*") != -1 ? "*" : session.getNamespaceURI(prefix);
        }
        return new PatternQPathEntry(namespaceURI, localName, index);
    }

    protected abstract boolean isExactName(String var1);

    protected abstract int getDefaultIndex();
}

