/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.LinkedList;
import junit.framework.Assert;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.tests.UnicastLoopbackTest;

public class UnicastUnitTest
extends ChannelTestBase {
    JChannel ch1;
    JChannel ch2 = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.ch1 = this.createChannel();
        this.ch2 = this.createChannel();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.ch2 != null) {
            this.ch2.close();
        }
        if (this.ch1 != null) {
            this.ch1.close();
        }
    }

    public void testUnicastMessageInCallbackExistingMember() throws Exception {
        this.ch1.connect("x");
        MyReceiver receiver = new MyReceiver(this.ch1);
        this.ch1.setReceiver(receiver);
        this.ch2.connect("x");
        Exception ex = receiver.getEx();
        if (ex != null) {
            throw ex;
        }
        this.ch1.setReceiver(null);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{UnicastLoopbackTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    private static class MyReceiver
    extends ReceiverAdapter {
        Channel channel;
        Exception ex;

        public MyReceiver(Channel channel) {
            this.channel = channel;
        }

        public Exception getEx() {
            return this.ex;
        }

        @Override
        public void viewAccepted(View new_view) {
            Address local_addr = this.channel.getLocalAddress();
            Assert.assertNotNull((Object)local_addr);
            System.out.println("[" + local_addr + "]: " + new_view);
            LinkedList<Address> members = new LinkedList<Address>(new_view.getMembers());
            Assert.assertEquals((String)("members=" + members + ", local_addr=" + local_addr), (int)2, (int)members.size());
            members.remove(local_addr);
            Assert.assertEquals((int)1, (int)members.size());
            Address dest = (Address)members.get(0);
            Message unicast_msg = new Message(dest, null, null);
            try {
                this.channel.send(unicast_msg);
            }
            catch (Exception e) {
                this.ex = e;
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }
}

