/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.rewrite.ResponseRewriterRegistry;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.apache.shindig.gadgets.servlet.ServletUtil;
import org.apache.shindig.gadgets.uri.ProxyUriManager;
import org.apache.shindig.gadgets.uri.UriUtils;

@Singleton
public class ProxyHandler {
    static final Integer LONG_LIVED_REFRESH = 31536000;
    static final Integer DEFAULT_REFRESH = 3600;
    private final RequestPipeline requestPipeline;
    private final ResponseRewriterRegistry contentRewriterRegistry;
    protected final boolean remapInternalServerError;

    @Inject
    public ProxyHandler(RequestPipeline requestPipeline, ResponseRewriterRegistry contentRewriterRegistry, @Named(value="shindig.proxy.remapInternalServerError") Boolean remapInternalServerError) {
        this.requestPipeline = requestPipeline;
        this.contentRewriterRegistry = contentRewriterRegistry;
        this.remapInternalServerError = remapInternalServerError;
    }

    private HttpRequest buildHttpRequest(ProxyUriManager.ProxyUri uriCtx, Uri tgt) throws GadgetException {
        ServletUtil.validateUrl(tgt);
        HttpRequest req = uriCtx.makeHttpRequest(tgt);
        req.setRewriteMimeType(uriCtx.getRewriteMimeType());
        return req;
    }

    public HttpResponse fetch(ProxyUriManager.ProxyUri proxyUri) throws IOException, GadgetException {
        HttpResponse results;
        HttpRequest rcr;
        block7: {
            Uri fallbackUri;
            rcr = this.buildHttpRequest(proxyUri, proxyUri.getResource());
            if (rcr == null) {
                throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "No url parameter in request", 400);
            }
            results = this.requestPipeline.execute(rcr);
            if (results.isError() && (fallbackUri = proxyUri.getFallbackUri()) != null) {
                HttpRequest fallbackRcr = this.buildHttpRequest(proxyUri, fallbackUri);
                results = this.requestPipeline.execute(fallbackRcr);
            }
            if (this.contentRewriterRegistry != null) {
                try {
                    results = this.contentRewriterRegistry.rewriteHttpResponse(rcr, results);
                }
                catch (RewritingException e) {
                    if (proxyUri.shouldReturnOrigOnErr() && this.isRecoverable(results)) break block7;
                    throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, e, e.getHttpStatusCode());
                }
            }
        }
        HttpResponseBuilder response = new HttpResponseBuilder(results);
        response.clearAllHeaders();
        try {
            ServletUtil.setCachingHeaders(response, proxyUri.translateStatusRefresh(LONG_LIVED_REFRESH, DEFAULT_REFRESH), false);
        }
        catch (GadgetException gex) {
            return ServletUtil.errorResponse(gex);
        }
        UriUtils.copyResponseHeadersAndStatusCode(results, response, this.remapInternalServerError, true, UriUtils.DisallowedHeaders.CACHING_DIRECTIVES, UriUtils.DisallowedHeaders.CLIENT_STATE_DIRECTIVES, UriUtils.DisallowedHeaders.OUTPUT_TRANSFER_DIRECTIVES);
        this.setResponseContentHeaders(response, results);
        UriUtils.maybeRewriteContentType(rcr, response);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)results.getResponse(), (OutputStream)baos);
        response.setResponse(baos.toByteArray());
        return response.create();
    }

    protected void setResponseContentHeaders(HttpResponseBuilder response, HttpResponse results) {
        if (!"application/x-shockwave-flash".equalsIgnoreCase(results.getHeader("Content-Type")) && !"application/x-shockwave-flash".equalsIgnoreCase(response.getHeader("Content-Type"))) {
            response.setHeader("Content-Disposition", "attachment;filename=p.txt");
        }
        if (results.getHeader("Content-Type") == null) {
            response.setHeader("Content-Type", "application/octet-stream");
        }
    }

    public boolean isRecoverable(HttpResponse results) {
        return !StringUtils.isEmpty((String)results.getResponseAsString()) || results.getHeaders() != null;
    }
}

