/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.filter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.filter.Filter;

public class FlateFilter
implements Filter {
    private static final Log log = LogFactory.getLog(FlateFilter.class);
    private static final int BUFFER_SIZE = 2048;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(InputStream compressedData, OutputStream result, COSDictionary options, int filterIndex) throws IOException {
        COSBase baseObj = options.getDictionaryObject(COSName.DECODE_PARMS, COSName.DP);
        COSDictionary dict = null;
        if (baseObj instanceof COSDictionary) {
            dict = (COSDictionary)baseObj;
        } else if (baseObj instanceof COSArray) {
            COSArray paramArray = (COSArray)baseObj;
            if (filterIndex < paramArray.size()) {
                dict = (COSDictionary)paramArray.getObject(filterIndex);
            }
        } else if (baseObj != null) {
            throw new IOException("Error: Expected COSArray or COSDictionary and not " + baseObj.getClass().getName());
        }
        int predictor = -1;
        int colors = -1;
        int bitsPerPixel = -1;
        int columns = -1;
        InflaterInputStream decompressor = null;
        ByteArrayInputStream bais = null;
        ByteArrayOutputStream baos = null;
        if (dict != null && (predictor = dict.getInt(COSName.PREDICTOR)) > 1) {
            colors = dict.getInt(COSName.COLORS);
            bitsPerPixel = options.getInt(COSName.BITS_PER_COMPONENT);
            columns = dict.getInt(COSName.COLUMNS);
        }
        try {
            decompressor = new InflaterInputStream(compressedData);
            int mayRead = compressedData.available();
            if (mayRead > 0) {
                byte[] buffer = new byte[Math.min(mayRead, 2048)];
                if (predictor == -1 || predictor == 1) {
                    try {
                        int amountRead;
                        while ((amountRead = decompressor.read(buffer, 0, Math.min(mayRead, 2048))) != -1) {
                            result.write(buffer, 0, amountRead);
                        }
                    }
                    catch (OutOfMemoryError exception) {
                        log.error((Object)"Stop reading corrupt stream");
                    }
                    catch (ZipException exception) {
                        log.error((Object)"Stop reading corrupt stream");
                    }
                    catch (EOFException exception) {
                        log.error((Object)"Stop reading corrupt stream");
                    }
                } else {
                    int amountRead;
                    if (colors == -1) {
                        colors = 1;
                    }
                    if (bitsPerPixel == -1) {
                        bitsPerPixel = 8;
                    }
                    if (columns == -1) {
                        columns = 1;
                    }
                    baos = new ByteArrayOutputStream();
                    while ((amountRead = decompressor.read(buffer, 0, Math.min(mayRead, 2048))) != -1) {
                        baos.write(buffer, 0, amountRead);
                    }
                    baos.flush();
                    bais = new ByteArrayInputStream(baos.toByteArray());
                    baos.close();
                    baos = null;
                    byte[] decodedData = this.decodePredictor(predictor, colors, bitsPerPixel, columns, bais);
                    bais.close();
                    bais = null;
                    result.write(decodedData);
                }
            }
            result.flush();
        }
        finally {
            if (decompressor != null) {
                decompressor.close();
            }
            if (bais != null) {
                bais.close();
            }
            if (baos != null) {
                baos.close();
            }
        }
    }

    private byte[] decodePredictor(int predictor, int colors, int bitsPerComponent, int columns, InputStream data) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        if (predictor == 1) {
            int i = 0;
            while ((i = data.read(buffer)) != -1) {
                baos.write(buffer, 0, i);
            }
        } else {
            int bpp = colors * (bitsPerComponent % 8 + 1);
            int rowlength = columns * bpp;
            byte[] actline = new byte[rowlength];
            byte[] lastline = new byte[rowlength];
            boolean done = false;
            int linepredictor = predictor;
            while (!done && data.available() > 0) {
                if (predictor >= 10) {
                    linepredictor = data.read();
                    if (linepredictor == -1) {
                        done = true;
                        break;
                    }
                    linepredictor += 10;
                }
                int i = 0;
                for (int offset = 0; offset < rowlength && (i = data.read(actline, offset, rowlength - offset)) != -1; offset += i) {
                }
                switch (linepredictor) {
                    case 2: {
                        int left;
                        int sub;
                        int p;
                        if (bitsPerComponent != 8) {
                            throw new IOException("TIFF-Predictor with " + bitsPerComponent + " bits per component not supported");
                        }
                        for (p = 0; p < rowlength; ++p) {
                            sub = actline[p] & 0xFF;
                            left = p - bpp >= 0 ? actline[p - bpp] & 0xFF : 0;
                            actline[p] = (byte)(sub + left);
                        }
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 11: {
                        int left;
                        int sub;
                        int p;
                        for (p = 0; p < rowlength; ++p) {
                            sub = actline[p];
                            left = p - bpp >= 0 ? actline[p - bpp] : 0;
                            actline[p] = (byte)(sub + left);
                        }
                        break;
                    }
                    case 12: {
                        int p;
                        for (p = 0; p < rowlength; ++p) {
                            int up = actline[p] & 0xFF;
                            int prior = lastline[p] & 0xFF;
                            actline[p] = (byte)(up + prior & 0xFF);
                        }
                        break;
                    }
                    case 13: {
                        int left;
                        int p;
                        for (p = 0; p < rowlength; ++p) {
                            int avg = actline[p] & 0xFF;
                            left = p - bpp >= 0 ? actline[p - bpp] & 0xFF : 0;
                            int up = lastline[p] & 0xFF;
                            actline[p] = (byte)(avg + (int)Math.floor((left + up) / 2) & 0xFF);
                        }
                        break;
                    }
                    case 14: {
                        int p;
                        for (p = 0; p < rowlength; ++p) {
                            int paeth = actline[p] & 0xFF;
                            int a = p - bpp >= 0 ? actline[p - bpp] & 0xFF : 0;
                            int b = lastline[p] & 0xFF;
                            int c = p - bpp >= 0 ? lastline[p - bpp] & 0xFF : 0;
                            int value = a + b - c;
                            int absa = Math.abs(value - a);
                            int absb = Math.abs(value - b);
                            int absc = Math.abs(value - c);
                            actline[p] = absa <= absb && absa <= absc ? (byte)(paeth + a & 0xFF) : (absb <= absc ? (byte)(paeth + b & 0xFF) : (byte)(paeth + c & 0xFF));
                        }
                        break;
                    }
                }
                lastline = (byte[])actline.clone();
                baos.write(actline, 0, actline.length);
            }
        }
        return baos.toByteArray();
    }

    public void encode(InputStream rawData, OutputStream result, COSDictionary options, int filterIndex) throws IOException {
        DeflaterOutputStream out = new DeflaterOutputStream(result);
        int amountRead = 0;
        int mayRead = rawData.available();
        if (mayRead > 0) {
            byte[] buffer = new byte[Math.min(mayRead, 2048)];
            while ((amountRead = rawData.read(buffer, 0, Math.min(mayRead, 2048))) != -1) {
                out.write(buffer, 0, amountRead);
            }
        }
        out.close();
        result.flush();
    }
}

