/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.persistence.util.COSObjectKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XrefTrailerResolver {
    private final Map<Integer, XrefTrailerObj> bytePosToXrefMap = new HashMap<Integer, XrefTrailerObj>();
    private XrefTrailerObj curXrefTrailerObj = null;
    private XrefTrailerObj resolvedXrefTrailer = null;
    private static final Log log = LogFactory.getLog(XrefTrailerResolver.class);

    public void nextXrefObj(int startBytePos) {
        this.curXrefTrailerObj = new XrefTrailerObj();
        this.bytePosToXrefMap.put(startBytePos, this.curXrefTrailerObj);
    }

    public void setXRef(COSObjectKey objKey, int offset) {
        if (this.curXrefTrailerObj == null) {
            log.warn((Object)("Cannot add XRef entry for '" + objKey.getNumber() + "' because XRef start was not signalled."));
            return;
        }
        this.curXrefTrailerObj.xrefTable.put(objKey, offset);
    }

    public void setTrailer(COSDictionary trailer) {
        if (this.curXrefTrailerObj == null) {
            log.warn((Object)"Cannot add trailer because XRef start was not signalled.");
            return;
        }
        this.curXrefTrailerObj.trailer = trailer;
    }

    public void setStartxref(int startxrefBytePos) {
        if (this.resolvedXrefTrailer != null) {
            log.warn((Object)"Method must be called only ones with last startxref value.");
            return;
        }
        this.resolvedXrefTrailer = new XrefTrailerObj();
        this.resolvedXrefTrailer.trailer = new COSDictionary();
        XrefTrailerObj curObj = this.bytePosToXrefMap.get(startxrefBytePos);
        ArrayList<Integer> xrefSeqBytePos = new ArrayList<Integer>();
        if (curObj == null) {
            log.warn((Object)("Did not found XRef object at specified startxref position " + startxrefBytePos));
            xrefSeqBytePos.addAll(this.bytePosToXrefMap.keySet());
            Collections.sort(xrefSeqBytePos);
        } else {
            int prevBytePos;
            xrefSeqBytePos.add(startxrefBytePos);
            while (curObj.trailer != null && (prevBytePos = curObj.trailer.getInt(COSName.PREV, -1)) != -1) {
                curObj = this.bytePosToXrefMap.get(prevBytePos);
                if (curObj == null) {
                    log.warn((Object)("Did not found XRef object pointed to by 'Prev' key at position " + prevBytePos));
                    break;
                }
                xrefSeqBytePos.add(prevBytePos);
                if (xrefSeqBytePos.size() < this.bytePosToXrefMap.size()) continue;
                break;
            }
            Collections.reverse(xrefSeqBytePos);
        }
        for (Integer bPos : xrefSeqBytePos) {
            curObj = this.bytePosToXrefMap.get(bPos);
            if (curObj.trailer != null) {
                this.resolvedXrefTrailer.trailer.addAll(curObj.trailer);
            }
            this.resolvedXrefTrailer.xrefTable.putAll(curObj.xrefTable);
        }
    }

    public COSDictionary getTrailer() {
        return this.resolvedXrefTrailer == null ? null : this.resolvedXrefTrailer.trailer;
    }

    public Map<COSObjectKey, Integer> getXrefTable() {
        return this.resolvedXrefTrailer == null ? null : this.resolvedXrefTrailer.xrefTable;
    }

    class XrefTrailerObj {
        private COSDictionary trailer = null;
        private final Map<COSObjectKey, Integer> xrefTable = new HashMap<COSObjectKey, Integer>();

        XrefTrailerObj() {
        }
    }
}

