/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.lock.jbosscache;

import java.sql.SQLException;
import javax.sql.DataSource;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.checker.DummyRepair;
import org.exoplatform.services.jcr.impl.checker.InspectionQuery;
import org.exoplatform.services.jcr.impl.core.lock.AbstractLockTableHandler;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class JBCLockTableHandler
extends AbstractLockTableHandler {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.JBCLockTableHandler");

    public JBCLockTableHandler(WorkspaceEntry workspaceEntry, DataSource ds) {
        super(workspaceEntry, ds);
    }

    protected InspectionQuery getSelectQuery() throws SQLException {
        return new InspectionQuery("SELECT * FROM " + this.getTableName() + " WHERE " + this.getParentColumn() + "='/" + "$LOCKS" + "'", new String[]{this.getIdColumn()}, "Locks table match", new DummyRepair());
    }

    protected InspectionQuery getDeleteQuery(String nodeId) throws SQLException {
        return new InspectionQuery("DELETE FROM " + this.getTableName() + " WHERE " + this.getIdColumn() + "='/" + "$LOCKS" + "/" + nodeId + "'", new String[0], "", new DummyRepair());
    }

    protected String getIdColumn() throws SQLException {
        try {
            return this.lockManagerEntry.getParameterValue("jbosscache-cl-cache.jdbc.fqn.column");
        }
        catch (RepositoryConfigurationException e) {
            throw new SQLException(e);
        }
    }

    protected String getParentColumn() throws SQLException {
        try {
            return this.lockManagerEntry.getParameterValue("jbosscache-cl-cache.jdbc.parent.column");
        }
        catch (RepositoryConfigurationException e) {
            throw new SQLException(e);
        }
    }

    protected String getTableName() throws SQLException {
        try {
            return this.lockManagerEntry.getParameterValue("jbosscache-cl-cache.jdbc.table.name");
        }
        catch (RepositoryConfigurationException e) {
            throw new SQLException(e);
        }
    }

    protected String extractNodeId(String value) {
        return value.substring(value.lastIndexOf("/") + 1);
    }
}

