/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Arrays;
import java.util.Vector;
import junit.framework.TestCase;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.TimeoutException;
import org.jgroups.View;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.pbcast.NAKACK;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Digest;
import org.jgroups.util.MutableDigest;
import org.jgroups.util.TimeScheduler;

public class NAKACK_SET_DIGEST_Test
extends TestCase {
    private NAKACK nak;
    private MutableDigest d1;
    private MutableDigest d2;
    private Address a;
    private Address b;
    private Address c;

    protected void setUp() throws Exception {
        super.setUp();
        this.a = new IpAddress(5000);
        this.b = new IpAddress(6000);
        this.c = new IpAddress(7000);
        this.nak = new NAKACK();
        this.d1 = new MutableDigest(2);
        this.d1.add(this.a, 0L, 10L, 10L);
        this.d1.add(this.b, 0L, 30L, 30L);
        this.d2 = new MutableDigest(3);
        this.d2.add(this.a, 0L, 10L, 11L);
        this.d2.add(this.b, 0L, 35L, 35L);
        this.d2.add(this.c, 10L, 50L, 50L);
        this.nak.setDownProtocol(new TP(){

            @Override
            public String getName() {
                return "blo";
            }

            @Override
            public String getInfo() {
                return null;
            }

            @Override
            public void postUnmarshalling(Message msg, Address dest, Address src, boolean multicast) {
            }

            @Override
            public void postUnmarshallingList(Message msg, Address dest, boolean multicast) {
            }

            @Override
            public Object down(Event evt) {
                return null;
            }

            @Override
            public TimeScheduler getTimer() {
                return new TimeScheduler(1);
            }

            @Override
            public void sendToAllMembers(byte[] data, int offset, int length) throws Exception {
            }

            @Override
            public void sendToSingleMember(Address dest, byte[] data, int offset, int length) throws Exception {
            }
        });
        this.nak.setUpProtocol(new Protocol(){

            @Override
            public String getName() {
                return "bla";
            }

            @Override
            public Object up(Event evt) {
                return null;
            }
        });
        this.nak.start();
        View view = new View(this.a, 1L, new Vector<Address>(Arrays.asList(this.a, this.b, this.c)));
        this.nak.down(new Event(6, view));
        this.nak.up(new Event(8, this.a));
    }

    public void testSetDigest() throws TimeoutException {
        System.out.println("d1: " + this.d1);
        System.out.println("d2: " + this.d2);
        System.out.println("setting d2:");
        this.nak.down(new Event(41, this.d2));
        Digest digest = (Digest)this.nak.down(new Event(39));
        System.out.println("digest = " + digest);
        NAKACK_SET_DIGEST_Test.assertEquals((int)3, (int)digest.size());
        NAKACK_SET_DIGEST_Test.assertTrue((boolean)digest.contains(this.a));
        NAKACK_SET_DIGEST_Test.assertTrue((boolean)digest.contains(this.b));
        NAKACK_SET_DIGEST_Test.assertTrue((boolean)digest.contains(this.c));
        System.out.println("setting d1:");
        this.nak.down(new Event(41, this.d1));
        digest = (Digest)this.nak.down(new Event(39));
        System.out.println("digest = " + digest);
        NAKACK_SET_DIGEST_Test.assertEquals((int)3, (int)digest.size());
        NAKACK_SET_DIGEST_Test.assertTrue((boolean)digest.contains(this.a));
        NAKACK_SET_DIGEST_Test.assertTrue((boolean)digest.contains(this.b));
        NAKACK_SET_DIGEST_Test.assertTrue((boolean)digest.contains(this.c));
    }
}

