/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security;

import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;

public class IdentityRegistry {
    public static final String INIT_PARAM_CONCURRENCY_LEVEL = "concurrency-level";
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.security.core.IdentityRegistry");
    private static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    private final ConcurrentHashMap<String, Identity> identities;

    public IdentityRegistry(InitParams params) {
        this(IdentityRegistry.parseConcurrencyLevel(params));
    }

    private static int parseConcurrencyLevel(InitParams params) {
        try {
            ValueParam concurrencyLevel;
            if (params != null && (concurrencyLevel = params.getValueParam(INIT_PARAM_CONCURRENCY_LEVEL)) != null) {
                return Integer.valueOf(concurrencyLevel.getValue());
            }
            return 16;
        }
        catch (NumberFormatException e) {
            LOG.error((Object)"Can't parse parameter concurrency-level", (Throwable)e);
            return 16;
        }
    }

    private IdentityRegistry(int concurrencyLevel) {
        this.identities = new ConcurrentHashMap(concurrencyLevel, 0.75f, concurrencyLevel);
    }

    public Identity getIdentity(String userId) {
        return this.identities.get(userId);
    }

    public void register(Identity identity) {
        this.identities.put(identity.getUserId(), identity);
    }

    public void unregister(String userId) {
        this.identities.remove(userId);
    }

    void clear() {
        this.identities.clear();
    }
}

