/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.xmlprocessor.filters;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringEscapeUtils;
import org.exoplatform.social.common.xmlprocessor.BaseXMLFilterPlugin;
import org.exoplatform.social.common.xmlprocessor.DOMParser;
import org.exoplatform.social.common.xmlprocessor.Tokenizer;
import org.exoplatform.social.common.xmlprocessor.filters.Util;
import org.exoplatform.social.common.xmlprocessor.model.Attributes;
import org.exoplatform.social.common.xmlprocessor.model.Node;
import org.exoplatform.social.common.xmlprocessor.model.XMLTagFilterPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLBalancerFilterPlugin
extends BaseXMLFilterPlugin {
    private LinkedHashMap<String, Attributes> allowedTags;

    public LinkedHashMap<String, Attributes> getAllowedTags() {
        return this.allowedTags;
    }

    public void setAllowedTags(LinkedHashMap<String, Attributes> allowedTags) {
        this.allowedTags = allowedTags;
    }

    public XMLBalancerFilterPlugin(XMLTagFilterPolicy tagFilterPolicy) {
        this.allowedTags = Util.getAllowedTagsFromTagFilterPolicy(tagFilterPolicy);
    }

    @Override
    public Object doFilter(Object input) {
        if (input instanceof String) {
            input = this.createDOMTree((String)input).toString();
        }
        return input;
    }

    private Node createDOMTree(String xmlString) {
        Node rootNode;
        Node parsingNode = rootNode = new Node();
        Node currentNode = rootNode;
        List<String> xmlTokens = Tokenizer.tokenize(xmlString);
        for (String token : xmlTokens) {
            String tag;
            Matcher startMatcher = DOMParser.TAGSTARTPATTERN.matcher(token);
            Matcher endMatcher = DOMParser.TAGCLOSEPATTERN.matcher(token);
            if (DOMParser.COMMENTPATTERN.matcher(token).find()) {
                parsingNode = new Node();
                parsingNode.setParentNode(currentNode);
                currentNode.addChildNode(parsingNode);
                parsingNode.setTitle(token);
                continue;
            }
            if (startMatcher.find() && this.allowedTags.containsKey(startMatcher.group(1).toLowerCase())) {
                tag = startMatcher.group(1).toLowerCase();
                parsingNode = new Node();
                parsingNode.setParentNode(currentNode);
                parsingNode.setTitle(tag);
                String tokenBody = startMatcher.group(2);
                Matcher attributes = DOMParser.ATTRIBUTESPATTERN.matcher(tokenBody);
                Attributes attributesWhiteList = this.allowedTags.get(tag);
                while (attributes.find()) {
                    String val;
                    String attr = attributes.group(1).toLowerCase();
                    String string = val = attributes.group(4) == null ? attributes.group(3) : attributes.group(4);
                    if (!attributesWhiteList.hasKey(attr)) continue;
                    parsingNode.addAttribute(attr, val);
                }
                currentNode.addChildNode(parsingNode);
                if (DOMParser.SELFTCLOSETAGPATTERN.matcher(token).find()) continue;
                currentNode = parsingNode;
                continue;
            }
            if (endMatcher.find() && this.allowedTags.containsKey(endMatcher.group(1).toLowerCase())) {
                tag = endMatcher.group(1).toLowerCase();
                Node searchOpenedNode = currentNode;
                while (!searchOpenedNode.getTitle().equals(tag) && searchOpenedNode.getParentNode() != null) {
                    searchOpenedNode = searchOpenedNode.getParentNode();
                }
                if (searchOpenedNode.getParentNode() == null) {
                    Node invalidNode = new Node();
                    invalidNode.setContent(StringEscapeUtils.escapeHtml((String)token));
                    currentNode.addChildNode(invalidNode);
                    continue;
                }
                if (searchOpenedNode.getTitle().equals(currentNode.getTitle())) {
                    currentNode = currentNode.getParentNode();
                    continue;
                }
                currentNode = searchOpenedNode.getParentNode();
                continue;
            }
            parsingNode = new Node();
            parsingNode.setParentNode(currentNode);
            parsingNode.setContent(StringEscapeUtils.escapeHtml((String)token));
            currentNode.addChildNode(parsingNode);
        }
        return rootNode;
    }
}

