/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer.escaping;

import com.google.caja.lexer.escaping.UriUtil;
import java.net.URISyntaxException;
import junit.framework.TestCase;

public class UriUtilTest
extends TestCase {
    public final void testUriNormalization() throws URISyntaxException {
        UriUtilTest.assertEquals((String)"http://www.foo.org:80/path?q=query#fragmento", (String)UriUtil.normalizeUri("http://www.foo.org:80/path?q=query#fragmento"));
        UriUtilTest.assertEquals((String)"x%3dfoo/bar?a=b%3ac=d", (String)UriUtil.normalizeUri("x=foo/bar?a=b:c=d"));
        UriUtilTest.assertEquals((String)"/foo%20bar", (String)UriUtil.normalizeUri("/foo bar"));
        UriUtilTest.assertEquals((String)"/foo%20bar", (String)UriUtil.normalizeUri("/foo%20bar"));
        UriUtilTest.assertEquals((String)"//bar.net:1234/?shazam", (String)UriUtil.normalizeUri("//bar.net:1234?shazam"));
        UriUtilTest.assertEquals((String)"../foo", (String)UriUtil.normalizeUri("../foo"));
        UriUtilTest.assertEquals((String)"../../foo", (String)UriUtil.normalizeUri("../../foo"));
        UriUtilTest.assertEquals((String)"../../bar", (String)UriUtil.normalizeUri("../../foo/../bar"));
        UriUtilTest.assertEquals((String)"../../bar", (String)UriUtil.normalizeUri("../../foo/./../bar"));
        UriUtilTest.assertEquals((String)"/bar", (String)UriUtil.normalizeUri("/../../bar"));
        UriUtilTest.assertEquals((String)"../../bar", (String)UriUtil.normalizeUri("%2e%2e/%2e./foo/%2E/.%2E/bar"));
        UriUtilTest.assertEquals((String)"http://foo/baz", (String)UriUtil.normalizeUri("http://foo/bar/../../../baz/"));
        UriUtilTest.assertEquals((String)"foo%25%20.bar%25%7e://baz%252/boo%252?foo%25%5b#far%25", (String)UriUtil.normalizeUri("foo% .bar%~://baz%2/boo%2?foo%[#far%"));
        UriUtilTest.assertEquals((String)"foo%41.bar%41://baz%41/boo%41?foo%41#far%41", (String)UriUtil.normalizeUri("foo%41.bar%41://baz%41/boo%41?foo%41#far%41"));
        UriUtilTest.assertEquals((String)"foo%21.bar%21://baz%21/boo%21?foo%21#far%21", (String)UriUtil.normalizeUri("foo!.bar!://baz!/boo!?foo!#far!"));
        UriUtilTest.assertEquals((String)"a-b.1+2://Foo/hiya", (String)UriUtil.normalizeUri("A-b.1+2://Foo/hiya"));
        UriUtilTest.assertEquals((String)"http://Hello+There-Now.com:80/", (String)UriUtil.normalizeUri("HTTP://Hello+There-Now.com:80"));
        UriUtilTest.assertEquals((String)"/Hello+There-N0w.", (String)UriUtil.normalizeUri("/Hello+There-N0w."));
        UriUtilTest.assertEquals((String)"zounds?foo=BAR&four=2+2-0.0", (String)UriUtil.normalizeUri("zounds?foo=BAR&four=2+2-0.0"));
        UriUtilTest.assertEquals((String)"#Hiya.%20%201-+1%3d0.0", (String)UriUtil.normalizeUri("#Hiya.  1-+1=0.0"));
        String enc = "%ef%bd%a1";
        UriUtilTest.assertEquals((String)("s" + enc + "://A" + enc + "/P" + enc + "?Q" + enc + "#F" + enc), (String)UriUtil.normalizeUri("S\uff61://A\uff61/P\uff61?Q\uff61#F\uff61"));
    }

    public final void testBlankAuthority1() {
        String result;
        try {
            result = UriUtil.normalizeUri("http:///www.google.com/foo");
        }
        catch (URISyntaxException ex) {
            return;
        }
        UriUtilTest.fail((String)result);
    }

    public final void testBlankAuthority2() {
        String result;
        try {
            result = UriUtil.normalizeUri("///www.google.com/foo");
        }
        catch (URISyntaxException ex) {
            return;
        }
        UriUtilTest.fail((String)result);
    }

    public final void testMissingAuthority() {
        String result;
        try {
            result = UriUtil.normalizeUri("http:/www.google.com/foo");
        }
        catch (URISyntaxException ex) {
            return;
        }
        UriUtilTest.fail((String)result);
    }

    public final void testMalformedPort() {
        String result;
        try {
            result = UriUtil.normalizeUri("http://www.google.com:paypal.com/foo");
        }
        catch (URISyntaxException ex) {
            return;
        }
        UriUtilTest.fail((String)result);
    }

    public final void testEncode() {
        UriUtilTest.assertEquals((String)"", (String)UriUtil.encode(""));
        UriUtilTest.assertEquals((String)"foo", (String)UriUtil.encode("foo"));
        UriUtilTest.assertEquals((String)"foo%2bbar", (String)UriUtil.encode("foo+bar"));
        UriUtilTest.assertEquals((String)"foo%2fbar", (String)UriUtil.encode("foo/bar"));
        UriUtilTest.assertEquals((String)"%e1%88%b4", (String)UriUtil.encode("\u1234"));
        UriUtilTest.assertEquals((String)"%3a%23%3f%2f%3d%26%40%25", (String)UriUtil.encode(":#?/=&@%"));
    }
}

