/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.auth;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.security.auth.login.LoginException;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.ExtendedUserHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Credential;
import org.exoplatform.services.security.DigestPasswordEncrypter;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.security.PasswordCredential;
import org.exoplatform.services.security.PasswordEncrypter;
import org.exoplatform.services.security.RolesExtractor;
import org.exoplatform.services.security.UsernameCredential;

public class OrganizationAuthenticatorImpl
implements Authenticator {
    protected static Log log = ExoLogger.getLogger((String)"exo.core.component.organization.api.OrganizationUserRegistry");
    private final OrganizationService orgService;
    private final PasswordEncrypter encrypter;
    private final RolesExtractor rolesExtractor;

    public OrganizationAuthenticatorImpl(OrganizationService orgService, RolesExtractor rolesExtractor, PasswordEncrypter encrypter) {
        this.orgService = orgService;
        this.encrypter = encrypter;
        this.rolesExtractor = rolesExtractor;
    }

    public OrganizationAuthenticatorImpl(OrganizationService orgService, RolesExtractor rolesExtractor) {
        this(orgService, rolesExtractor, null);
    }

    public OrganizationAuthenticatorImpl(OrganizationService orgService) {
        this(orgService, null, null);
    }

    public OrganizationService getOrganizationService() {
        return this.orgService;
    }

    public Identity createIdentity(String userId) throws Exception {
        HashSet<MembershipEntry> entries = new HashSet<MembershipEntry>();
        this.begin(this.orgService);
        Collection memberships = this.orgService.getMembershipHandler().findMembershipsByUser(userId);
        this.end(this.orgService);
        if (memberships != null) {
            for (Membership membership : memberships) {
                entries.add(new MembershipEntry(membership.getGroupId(), membership.getMembershipType()));
            }
        }
        if (this.rolesExtractor == null) {
            return new Identity(userId, entries);
        }
        return new Identity(userId, entries, (Collection)this.rolesExtractor.extractRoles(userId, entries));
    }

    public String validateUser(Credential[] credentials) throws LoginException, Exception {
        boolean success;
        String username = null;
        String password = null;
        Map passwordContext = null;
        for (Credential cred : credentials) {
            if (cred instanceof UsernameCredential) {
                username = ((UsernameCredential)cred).getUsername();
            }
            if (!(cred instanceof PasswordCredential)) continue;
            password = ((PasswordCredential)cred).getPassword();
            passwordContext = ((PasswordCredential)cred).getPasswordContext();
        }
        if (username == null || password == null) {
            throw new LoginException("Username or Password is not defined");
        }
        if (this.encrypter != null) {
            password = new String(this.encrypter.encrypt(password.getBytes()));
        }
        this.begin(this.orgService);
        UserHandler userHandler = this.orgService.getUserHandler();
        if (passwordContext != null && userHandler instanceof ExtendedUserHandler) {
            DigestPasswordEncrypter pe = new DigestPasswordEncrypter(username, passwordContext);
            success = ((ExtendedUserHandler)((Object)userHandler)).authenticate(username, password, (PasswordEncrypter)pe);
        } else {
            success = userHandler.authenticate(username, password);
        }
        this.end(this.orgService);
        if (!success) {
            throw new LoginException("Login failed for " + username.replace("\n", " ").replace("\r", " "));
        }
        return username;
    }

    public void begin(OrganizationService orgService) throws Exception {
        if (orgService instanceof ComponentRequestLifecycle) {
            RequestLifeCycle.begin((ComponentRequestLifecycle)((ComponentRequestLifecycle)orgService));
        }
    }

    public void end(OrganizationService orgService) throws Exception {
        if (orgService instanceof ComponentRequestLifecycle) {
            RequestLifeCycle.end();
        }
    }
}

