/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest.api.models;

import java.util.HashMap;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.social.service.rest.api.models.IdentityRestOut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentRestOut
extends HashMap<String, Object> {
    public CommentRestOut() {
        this.initialize();
    }

    public CommentRestOut(ExoSocialActivity commentActivity, String portalContainerName) {
        this.initialize();
        this.setId(commentActivity.getId());
        this.setPosterIdentity(new IdentityRestOut(commentActivity.getUserId(), portalContainerName));
        this.setText(commentActivity.getTitle());
        this.setPostedTime(commentActivity.getPostedTime());
        this.setCreatedAt(Util.convertTimestampToTimeString(commentActivity.getPostedTime()));
    }

    public String getId() {
        return (String)this.get(Field.ID.toString());
    }

    public void setId(String id) {
        if (id != null) {
            this.put(Field.ID.toString(), id);
        } else {
            this.put(Field.ID.toString(), "");
        }
    }

    public IdentityRestOut getPosterIdentity() {
        return (IdentityRestOut)this.get(Field.POSTER_IDENTITY.toString());
    }

    public void setPosterIdentity(IdentityRestOut posterIdentity) {
        if (posterIdentity != null) {
            this.put(Field.POSTER_IDENTITY.toString(), new IdentityRestOut());
        } else {
            this.put(Field.POSTER_IDENTITY.toString(), new HashMap());
        }
    }

    public void setPosterIdentity(ExoSocialActivity commentActivity, String portalContainerName) {
        if (commentActivity != null) {
            this.put(Field.POSTER_IDENTITY.toString(), new IdentityRestOut(commentActivity.getUserId(), portalContainerName));
        } else {
            this.put(Field.POSTER_IDENTITY.toString(), new HashMap());
        }
    }

    public String getText() {
        return (String)this.get(Field.TEXT.toString());
    }

    public void setText(String text) {
        if (text != null) {
            this.put(Field.TEXT.toString(), text);
        } else {
            this.put(Field.TEXT.toString(), "");
        }
    }

    public Long getPostedTime() {
        return (Long)this.get(Field.POSTED_TIME.toString());
    }

    public void setPostedTime(Long postedTime) {
        if (postedTime != null) {
            this.put(Field.POSTED_TIME.toString(), postedTime);
        } else {
            this.put(Field.POSTED_TIME.toString(), new Long(0L));
        }
    }

    public String getCreatedAt() {
        return (String)this.get(Field.CREATE_AT.toString());
    }

    public void setCreatedAt(String createdAt) {
        if (createdAt != null) {
            this.put(Field.CREATE_AT.toString(), createdAt);
        } else {
            this.put(Field.CREATE_AT.toString(), "");
        }
    }

    private void initialize() {
        this.setId("");
        this.setPostedTime(new Long(0L));
        this.setPosterIdentity(null);
        this.setText("");
        this.setCreatedAt("");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Field {
        ID("id"),
        TEXT("text"),
        POSTER_IDENTITY("posterIdentity"),
        POSTED_TIME("postedTime"),
        CREATE_AT("createdAt");

        private final String fieldName;

        private Field(String string2) {
            this.fieldName = string2;
        }

        public String toString() {
            return this.fieldName;
        }
    }
}

