/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.resource.representation;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.ext.resource.NodeRepresentation;
import org.exoplatform.services.jcr.ext.resource.NodeRepresentationFactory;
import org.exoplatform.services.jcr.ext.resource.NodeRepresentationService;
import org.exoplatform.services.jcr.ext.resource.representation.NtFileNodeRepresentation;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NtFileNodeRepresentationFactory
implements NodeRepresentationFactory {
    private static Log LOG = ExoLogger.getLogger("exo.jcr.component.ext.NtFileNodeRepresentationFactory");
    protected NodeRepresentationService nodeRepresentationService;

    public NtFileNodeRepresentationFactory(NodeRepresentationService nodeRepresentationService) {
        this.nodeRepresentationService = nodeRepresentationService;
    }

    public NodeRepresentation createNodeRepresentation(Node node, String mediaTypeHint) {
        try {
            NodeRepresentation content = this.nodeRepresentationService.getNodeRepresentation(node.getNode("jcr:content"), mediaTypeHint);
            return new NtFileNodeRepresentation(node, content);
        }
        catch (RepositoryException e) {
            LOG.error((Object)e.getLocalizedMessage(), e);
            return null;
        }
    }

    public String getNodeType() {
        return "nt:file";
    }
}

