/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.LockMode;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.SelectLockingStrategy;
import org.hibernate.dialect.lock.UpdateLockingStrategy;
import org.hibernate.persister.entity.Lockable;

public class PointbaseDialect
extends Dialect {
    public PointbaseDialect() {
        this.registerColumnType(-7, "smallint");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(-6, "smallint");
        this.registerColumnType(4, "integer");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double precision");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(-3, "blob($l)");
        this.registerColumnType(2, "numeric($p,$s)");
    }

    public String getAddColumnString() {
        return "add";
    }

    public boolean dropConstraints() {
        return false;
    }

    public String getCascadeConstraintsString() {
        return " cascade";
    }

    public String getForUpdateString() {
        return "";
    }

    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        if (lockMode.greaterThan(LockMode.READ)) {
            return new UpdateLockingStrategy(lockable, lockMode);
        }
        return new SelectLockingStrategy(lockable, lockMode);
    }
}

