/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form.input;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.form.UIFormInputBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="system:/groovy/webui/form/UIUploadInput.gtmpl")
public class UIUploadInput
extends UIFormInputBase<String> {
    private String[] uploadId;
    private boolean isAutoUpload = true;
    private int limitFile = 1;

    public UIUploadInput(String name, String bindingExpression, int limitFile) {
        super(name, bindingExpression, String.class);
        if (limitFile > 1) {
            this.limitFile = limitFile;
        }
        this.uploadId = new String[this.limitFile];
        for (int i = 0; i < this.uploadId.length; ++i) {
            this.uploadId[i] = new StringBuffer().append(Math.abs(this.hashCode())).append('-').append(i).toString();
        }
        UploadService service = (UploadService)this.getApplicationComponent(UploadService.class);
        for (int i = 0; i < this.uploadId.length; ++i) {
            service.addUploadLimit(this.uploadId[i], null);
        }
        this.setComponentConfig(UIUploadInput.class, null);
    }

    public UIUploadInput(String name, String bindingExpression, int limitFile, int limitSize) {
        this(name, bindingExpression, limitFile, limitSize, UploadService.UploadUnit.MB);
    }

    public UIUploadInput(String name, String bindingExpression, int limitFile, int limitSize, UploadService.UploadUnit unit) {
        super(name, bindingExpression, String.class);
        if (limitFile > 1) {
            this.limitFile = limitFile;
        }
        this.uploadId = new String[this.limitFile];
        for (int i = 0; i < this.uploadId.length; ++i) {
            this.uploadId[i] = new StringBuffer().append(Math.abs(this.hashCode())).append('-').append(i).toString();
        }
        UploadService service = (UploadService)this.getApplicationComponent(UploadService.class);
        for (int i = 0; i < this.uploadId.length; ++i) {
            service.addUploadLimit(this.uploadId[i], Integer.valueOf(limitSize), unit);
        }
        this.setComponentConfig(UIUploadInput.class, null);
    }

    public String[] getUploadId() {
        return this.uploadId;
    }

    public void setAutoUpload(boolean isAutoUpload) {
        this.isAutoUpload = isAutoUpload;
    }

    public boolean isAutoUpload() {
        return this.isAutoUpload;
    }

    public int getLimitFile() {
        return this.limitFile;
    }

    public UploadResource[] getUploadResources() {
        ArrayList<UploadResource> holder = new ArrayList<UploadResource>();
        UploadService service = (UploadService)this.getApplicationComponent(UploadService.class);
        for (int i = 0; i < this.uploadId.length; ++i) {
            UploadResource uploadResource = service.getUploadResource(this.uploadId[i]);
            if (uploadResource == null) continue;
            holder.add(uploadResource);
        }
        return holder.toArray(new UploadResource[holder.size()]);
    }

    public UploadResource getUploadResource(String uploadId) {
        UploadService service = (UploadService)this.getApplicationComponent(UploadService.class);
        return service.getUploadResource(uploadId);
    }

    public InputStream[] getUploadDataAsStreams() throws FileNotFoundException {
        ArrayList<FileInputStream> holder = new ArrayList<FileInputStream>();
        UploadService service = (UploadService)this.getApplicationComponent(UploadService.class);
        for (int i = 0; i < this.uploadId.length; ++i) {
            UploadResource uploadResource = service.getUploadResource(this.uploadId[i]);
            if (uploadResource == null) continue;
            File file = new File(uploadResource.getStoreLocation());
            holder.add(new FileInputStream(file));
        }
        return holder.toArray(new InputStream[holder.size()]);
    }

    public InputStream getUploadDataAsStream(String uploadId) throws FileNotFoundException {
        UploadService service = (UploadService)this.getApplicationComponent(UploadService.class);
        UploadResource uploadResource = service.getUploadResource(uploadId);
        if (uploadResource == null) {
            return null;
        }
        return new FileInputStream(new File(uploadResource.getStoreLocation()));
    }

    @Override
    public void decode(Object input, WebuiRequestContext context) throws Exception {
    }
}

