/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.jsdoc;

import com.google.caja.ancillary.jsdoc.Annotation;
import com.google.caja.ancillary.jsdoc.AnnotationHandlers;
import com.google.caja.ancillary.jsdoc.Comment;
import com.google.caja.ancillary.jsdoc.CommentParser;
import com.google.caja.ancillary.jsdoc.JsdocMessageType;
import com.google.caja.ancillary.jsdoc.TextAnnotation;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.ParseTreeNodes;
import com.google.caja.parser.js.Expression;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.util.CajaTestCase;

public class AnnotationHandlersTest
extends CajaTestCase {
    private AnnotationHandlers handlers;

    public void setUp() throws Exception {
        super.setUp();
        this.handlers = new AnnotationHandlers(this.mc);
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.handlers = null;
    }

    public final void testAuthor1() throws Exception {
        this.assertHandler("/** @author me@foo.com */", "{  'url': 'mailto:me@foo.com'}");
        this.assertNoErrors();
    }

    public final void testAuthor2() throws Exception {
        this.assertHandler("/** @author Dr. Evil */", "{  'name': 'Dr. Evil'}");
        this.assertNoErrors();
    }

    public final void testAuthor3() throws Exception {
        this.assertHandler("/** @author Dr. Evil <me@foo.com> */", "{  'name': 'Dr. Evil',  'url': 'mailto:me@foo.com'}");
        this.assertNoErrors();
    }

    public final void testAuthor4() throws Exception {
        this.assertHandler("/** @author me@foo.com (Dr. Evil) */", "{  'name': 'Dr. Evil',  'url': 'mailto:me@foo.com'}");
        this.assertNoErrors();
    }

    public final void testAuthor5() throws Exception {
        this.assertHandler("/** @author */", null);
        this.assertMessage(JsdocMessageType.EXPECTED_EMAIL_OR_NAME, MessageLevel.ERROR, new MessagePart[0]);
    }

    public final void testAuthor6() throws Exception {
        this.assertHandler("/** @author {@code h4xor} */", null);
        this.assertMessage(JsdocMessageType.EXPECTED_DOCUMENTATION_TEXT, MessageLevel.ERROR, new MessagePart[0]);
    }

    public final void testAuthor7() throws Exception {
        this.assertHandler("/** @author javascript:alert('h4xor') */", null);
        this.assertMessage(JsdocMessageType.EXPECTED_EMAIL_OR_NAME, MessageLevel.ERROR, new MessagePart[0]);
    }

    public final void testAuthor8() throws Exception {
        this.assertHandler("/** @author <a href=mailto:me@foo.com>Dr. Evil</a> */", "{  'name': 'Dr. Evil',  'url': 'mailto:me@foo.com'}");
        this.assertNoErrors();
    }

    public final void testAuthor9() throws Exception {
        this.assertHandler("/** @author <a name=mailto:me@foo.com>Dr. Evil</a> */", null);
        this.assertMessage(JsdocMessageType.EXPECTED_EMAIL_OR_NAME, MessageLevel.ERROR, new MessagePart[0]);
    }

    public final void testAuthor10() throws Exception {
        this.assertHandler("/** {@author me@foo.com} */", null);
        this.assertMessage(JsdocMessageType.ANNOTATION_OUT_OF_PLACE, MessageLevel.ERROR, new MessagePart[0]);
    }

    public final void testCode1() throws Exception {
        this.assertHandler("/** {@code x=y} */", AnnotationHandlersTest.promiseWrapper("'<code class=\\\"prettyprint\\\">' + jsdoc___.html('x=y') + '</code>'"));
        this.assertNoErrors();
    }

    public final void testCode2() throws Exception {
        this.assertHandler("/** @code x=y */", null);
        this.assertMessage(JsdocMessageType.ANNOTATION_OUT_OF_PLACE, MessageLevel.ERROR, new MessagePart[0]);
    }

    public final void testCode3() throws Exception {
        this.assertHandler("/** {@code} */", AnnotationHandlersTest.promiseWrapper("'<code class=\\\"prettyprint\\\">' + jsdoc___.html('') + '</code>'"));
        this.assertNoErrors();
    }

    public final void testConstructor1() throws Exception {
        this.assertHandler("/** @constructor */", "true");
        this.assertNoErrors();
    }

    public final void testConstructor2() throws Exception {
        this.assertHandler("/** {@constructor} */", null);
        this.assertMessage(JsdocMessageType.ANNOTATION_OUT_OF_PLACE, MessageLevel.ERROR, new MessagePart[0]);
    }

    public final void testConstructor3() throws Exception {
        this.assertHandler("/** @constructor foo */", null);
        this.assertMessage(JsdocMessageType.UNEXPECTED_CONTENT, MessageLevel.ERROR, MessagePart.Factory.valueOf("@constructor"));
    }

    public final void testExtends1() throws Exception {
        this.assertHandler("/** @extends Foo */", AnnotationHandlersTest.promiseWrapper("jsdoc___.nameOf(Foo)"));
    }

    public final void testFileOverview1() throws Exception {
        this.assertHandler("/** @fileoverview Fast, Spiffy, and {@link Taste delicious}. */", AnnotationHandlersTest.promiseWrapper("'Fast, Spiffy, and ' + ('<a href=\\\"' + jsdoc___.html(jsdoc___.linkTo(apiElement, apiElementName, Taste, 'Taste', 'testFileOverview1:1+44 - 49')) + '\\\">' + jsdoc___.html('delicious') + '</a>') + '. '"));
        this.assertNoErrors();
    }

    public final void testFileOverview2() throws Exception {
        this.assertHandler("/** {@fileoverview howdy} */", null);
        this.assertMessage(JsdocMessageType.ANNOTATION_OUT_OF_PLACE, MessageLevel.ERROR, new MessagePart[0]);
    }

    public final void testLink1() throws Exception {
        this.assertHandler("{@link foo}", AnnotationHandlersTest.promiseWrapper("'<a href=\\\"' + jsdoc___.html(jsdoc___.linkTo(apiElement, apiElementName, foo, 'foo', 'testLink1:1+1 - 12')) + '\\\">' + jsdoc___.html('foo') + '</a>'"));
        this.assertNoErrors();
    }

    public final void testLink2() throws Exception {
        this.assertHandler("{@link foo long description}", AnnotationHandlersTest.promiseWrapper("'<a href=\\\"' + jsdoc___.html(jsdoc___.linkTo(apiElement, apiElementName, foo, 'foo', 'testLink2:1+8 - 11')) + '\\\">' + jsdoc___.html('long description') + '</a>'"));
        this.assertNoErrors();
    }

    public final void testLink3() throws Exception {
        this.assertHandler("{@link}", null);
        this.assertMessage(JsdocMessageType.EXPECTED_DOCUMENTATION_TEXT, MessageLevel.ERROR, new MessagePart[0]);
    }

    public final void testLink4() throws Exception {
        this.assertHandler("{@link 4}", null);
        this.assertMessage(JsdocMessageType.EXPECTED_URL_OR_REFERENCE, MessageLevel.ERROR, new MessagePart[0]);
    }

    public final void testLink5() throws Exception {
        this.assertHandler("{@link /foo.html}", AnnotationHandlersTest.promiseWrapper("'<a href=\\\"' + jsdoc___.html('/foo.html') + '\\\">' + jsdoc___.html('/foo.html') + '</a>'"));
        this.assertNoErrors();
    }

    public final void testLink6() throws Exception {
        this.assertHandler("{@link /foo.html bar}", AnnotationHandlersTest.promiseWrapper("'<a href=\\\"' + jsdoc___.html('/foo.html') + '\\\">' + jsdoc___.html('bar') + '</a>'"));
        this.assertNoErrors();
    }

    public final void testParam1() throws Exception {
        this.assertHandler("@param foo", AnnotationHandlersTest.promiseWrapper("({ 'name': " + AnnotationHandlersTest.requireParamCall("'foo'") + "," + " 'summary': ''" + "})"));
        this.assertNoErrors();
    }

    public final void testParam2() throws Exception {
        this.assertHandler("@param foo bar", AnnotationHandlersTest.promiseWrapper("({ 'name': " + AnnotationHandlersTest.requireParamCall("'foo'") + "," + " 'summary': 'bar'" + "})"));
        this.assertNoErrors();
    }

    public final void testParam3() throws Exception {
        this.assertHandler("@param {string} foo", AnnotationHandlersTest.promiseWrapper("({ 'type': 'string', 'name': " + AnnotationHandlersTest.requireParamCall("'foo'") + "," + " 'summary': ''" + "})"));
        this.assertNoErrors();
    }

    public final void testParam4() throws Exception {
        this.assertHandler("@param {string | null} foo bar", AnnotationHandlersTest.promiseWrapper("({ 'type': 'string | null', 'name': " + AnnotationHandlersTest.requireParamCall("'foo'") + "," + " 'summary': 'bar'" + "})"));
        this.assertNoErrors();
    }

    public final void testParam5() throws Exception {
        this.assertHandler("@param { Array.<number> } opt_foo defaults to {@code [1,2,3]}", AnnotationHandlersTest.promiseWrapper("{ 'type': (jsdoc___.requireTypeAtoms(              'testParam5:1+8 - 26',              [function () { return Array}, 'Array']),          'Array.<number>'), 'name': " + AnnotationHandlersTest.requireParamCall("'opt_foo'") + "," + " 'summary': ('defaults to '" + "             + ('<code class=\\\"prettyprint\\\">'" + "                + jsdoc___.html('[1,2,3]') + '</code>'))" + "}"));
        this.assertNoErrors();
    }

    public final void testParam6() throws Exception {
        this.assertHandler("@param {string}", null);
        this.assertMessage(JsdocMessageType.EXPECTED_IDENTIFIER, MessageLevel.ERROR, new MessagePart[0]);
    }

    public final void testParam7() throws Exception {
        this.assertHandler("@param", null);
        this.assertMessage(JsdocMessageType.EXPECTED_DOCUMENTATION_TEXT, MessageLevel.ERROR, new MessagePart[0]);
    }

    public final void testParam8() throws Exception {
        this.assertHandler("@param #foo", null);
        this.assertMessage(JsdocMessageType.EXPECTED_IDENTIFIER, MessageLevel.ERROR, new MessagePart[0]);
    }

    public final void testRequires() throws Exception {
        this.assertHandler("@requires foo, bar", AnnotationHandlersTest.promiseWrapper("[ jsdoc___.linkTo(apiElement, apiElementName, foo, 'foo', 'testRequires:1+1 - 19'),  jsdoc___.linkTo(apiElement, apiElementName, bar, 'bar', 'testRequires:1+1 - 19') ].join(' ')"));
    }

    public final void testProvides() throws Exception {
        this.assertHandler("@provides foo, bar", AnnotationHandlersTest.promiseWrapper("[  jsdoc___.linkTo(apiElement, apiElementName, foo, 'foo', 'testProvides:1+1 - 19'),  jsdoc___.linkTo(apiElement, apiElementName, bar, 'bar', 'testProvides:1+1 - 19') ].join(' ')"));
    }

    public final void testReturn1() throws Exception {
        this.assertHandler("@return {string}", "({ 'type': 'string', 'summary': '' })");
        this.assertNoErrors();
    }

    public final void testReturn2() throws Exception {
        this.assertHandler("@return {string} foo like {@link #bar}", AnnotationHandlersTest.promiseWrapper("({ 'type': 'string', 'summary': 'foo like ' + ('<a href=\\\"' + jsdoc___.html('#bar') + '\\\">' + jsdoc___.html('#bar') + '</a>') })"));
        this.assertNoErrors();
    }

    public final void testReturn3() throws Exception {
        this.assertHandler("@return", null);
        this.assertMessage(JsdocMessageType.EXPECTED_DOCUMENTATION_TEXT, MessageLevel.ERROR, new MessagePart[0]);
    }

    public final void testReturn4() throws Exception {
        this.assertHandler("@return foo", "({ 'summary': 'foo' })");
        this.assertNoErrors();
    }

    public final void testSee1() throws Exception {
        this.assertHandler("@see foo", AnnotationHandlersTest.promiseWrapper("({  'url': jsdoc___.linkTo(apiElement, apiElementName, foo, 'foo', 'testSee1:1+6 - 9')})"));
        this.assertNoErrors();
    }

    public final void testSee2() throws Exception {
        this.assertHandler("@see<A title=zoicks href=/foo.html>external link</A>", "({ 'name': 'external link', 'url': '/foo.html' })");
        this.assertNoErrors();
    }

    public final void testSee3() throws Exception {
        this.assertHandler("@see<A title=zoicks name='bar'>external link</A>", null);
        this.assertMessage(JsdocMessageType.BAD_LINK, MessageLevel.ERROR, new MessagePart[0]);
    }

    public final void testSee4() throws Exception {
        this.assertHandler("@see <A href=\"javascript:alert('foo')\">external link</A>", null);
        this.assertMessage(JsdocMessageType.BAD_LINK, MessageLevel.ERROR, new MessagePart[0]);
    }

    public final void testSee5() throws Exception {
        this.assertHandler("@see", null);
        this.assertMessage(JsdocMessageType.BAD_LINK, MessageLevel.ERROR, new MessagePart[0]);
    }

    public final void testThrows1() throws Exception {
        this.assertHandler("@throws {string}", "({ 'type': 'string', 'summary': '' })");
        this.assertNoErrors();
    }

    public final void testThrows2() throws Exception {
        this.assertHandler("@throws {string} foo like {@link #bar}", AnnotationHandlersTest.promiseWrapper("({ 'type': 'string', 'summary': 'foo like ' + ('<a href=\\\"' + jsdoc___.html('#bar') + '\\\">' + jsdoc___.html('#bar') + '</a>') })"));
        this.assertNoErrors();
    }

    public final void testThrows3() throws Exception {
        this.assertHandler("@throws", null);
        this.assertMessage(JsdocMessageType.EXPECTED_DOCUMENTATION_TEXT, MessageLevel.ERROR, new MessagePart[0]);
    }

    public final void testThrows4() throws Exception {
        this.assertHandler("@throws foo", "({ 'summary': 'foo' })");
        this.assertNoErrors();
    }

    public final void testThrows5() throws Exception {
        this.assertHandler("{@throws foo}", null);
        this.assertMessage(JsdocMessageType.ANNOTATION_OUT_OF_PLACE, MessageLevel.ERROR, new MessagePart[0]);
    }

    public final void testType1() throws Exception {
        this.assertHandler("@type {string}", "'string'");
        this.assertNoErrors();
    }

    public final void testType2() throws Exception {
        this.assertHandler("@type", null);
        this.assertMessage(JsdocMessageType.EXPECTED_TYPE, MessageLevel.ERROR, new MessagePart[0]);
    }

    public final void testType3() throws Exception {
        this.assertHandler("{@type {foo}}", null);
        this.assertMessage(JsdocMessageType.ANNOTATION_OUT_OF_PLACE, MessageLevel.ERROR, new MessagePart[0]);
    }

    public final void testUpdoc1() throws Exception {
        this.assertHandler("/**\n * {@updoc\n * $ abs(5)\n * # 5\n * $ abs(-5)\n * # 5\n * $ abs(0)\n * # 0\n * }\n */", AnnotationHandlersTest.promiseWrapper("jsdoc___.updoc([    { doc:    '$ abs(5);\\n# 5;',      input:  function () { return abs(5); },      result: function () { return 5; },      pos:    'testUpdoc1:2+6 - 3+4' },    { doc:    '$ abs(-5);\\n# 5;',      input:  function () { return abs(-5); },      result: function () { return 5; },      pos:    'testUpdoc1:4+3 - 5+4' },    { doc:    '$ abs(0);\\n# 0;',      input:  function () { return abs(0); },      result: function () { return 0; },      pos:    'testUpdoc1:6+3 - 7+4' }])"));
    }

    public final void testGuessAnnotation() throws Exception {
        this.assertHandler("/** @authop me@foo.com */", null);
        this.assertMessage(JsdocMessageType.UNRECOGNIZED_ANNOTATION, MessageLevel.ERROR, MessagePart.Factory.valueOf("authop"));
        this.assertMessage(JsdocMessageType.DID_YOU_MEAN, MessageLevel.LINT, MessagePart.Factory.valueOf("author"));
    }

    public final void testUngessableAnnotation() throws Exception {
        this.assertHandler("/** @Zzyzx */", null);
        this.assertMessage(JsdocMessageType.UNRECOGNIZED_ANNOTATION, MessageLevel.ERROR, new MessagePart[0]);
        this.assertNoMessage(JsdocMessageType.DID_YOU_MEAN);
    }

    private void assertHandler(String inputComment, String goldenJson) throws ParseException {
        Comment comment = CommentParser.parseStructuredComment(this.fromString(inputComment));
        Annotation toTest = null;
        for (Annotation a : comment.children()) {
            if (a instanceof TextAnnotation && "".equals(a.getValue().trim())) continue;
            toTest = a;
            break;
        }
        this.mq.getMessages().clear();
        Expression actual = this.handlers.handlerFor(toTest).handle(toTest, this.mq);
        if (goldenJson == null || actual == null) {
            AnnotationHandlersTest.assertEquals((String)goldenJson, (String)(actual != null ? AnnotationHandlersTest.render(actual) : null));
        } else {
            Expression golden = this.jsExpr(this.fromString(goldenJson));
            if (!ParseTreeNodes.deepEquals(golden, actual)) {
                AnnotationHandlersTest.assertEquals((String)AnnotationHandlersTest.render(golden), (String)AnnotationHandlersTest.render(actual));
            }
        }
    }

    private static String promiseWrapper(String js) {
        return "(function (docRoot, apiElementName) {  var apiElement = this;  return " + js + ";" + "})";
    }

    private static String requireParamCall(String paramNameJs) {
        return "jsdoc___.requireParam(    apiElement, apiElementName, jsdoc___.resolvePromise(        " + paramNameJs + ", docRoot, apiElementName, apiElement))";
    }
}

