/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.rewrite.DomWalker;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbsolutePathReferenceVisitor
implements DomWalker.Visitor {
    private final Map<String, String> tagsToMakeAbsolute;

    @Inject
    public AbsolutePathReferenceVisitor(Tags ... resourceTags) {
        HashMap<String, String> tagsToMakeAbsolute = new HashMap<String, String>();
        for (Tags r : resourceTags) {
            tagsToMakeAbsolute.putAll(r.getResourceTags());
        }
        this.tagsToMakeAbsolute = tagsToMakeAbsolute;
    }

    @Override
    public DomWalker.Visitor.VisitStatus visit(Gadget gadget, Node node) throws RewritingException {
        Attr nodeAttr = AbsolutePathReferenceVisitor.getUriAttributeFromNode(node, this.tagsToMakeAbsolute);
        if (nodeAttr != null) {
            try {
                Uri nodeUri = Uri.parse((String)nodeAttr.getValue());
                Uri baseUri = this.getBaseResolutionUri(gadget, node);
                Uri resolved = baseUri.resolve(nodeUri);
                if (!resolved.equals((Object)nodeUri)) {
                    nodeAttr.setValue(resolved.toString());
                    return DomWalker.Visitor.VisitStatus.MODIFY;
                }
            }
            catch (Uri.UriException e) {
                // empty catch block
            }
        }
        return DomWalker.Visitor.VisitStatus.BYPASS;
    }

    @Override
    public boolean revisit(Gadget gadget, List<Node> node) throws RewritingException {
        return false;
    }

    public static Attr getUriAttributeFromNode(Node node, Map<String, String> resourceTags) {
        String nodeName = node.getNodeName().toLowerCase();
        if (node.getNodeType() == 1 && resourceTags.containsKey(nodeName)) {
            Attr attr;
            String nodeUri;
            if ("link".equals(nodeName)) {
                String type = ((Element)node).getAttribute("type");
                String rel = ((Element)node).getAttribute("rel");
                if (!"stylesheet".equalsIgnoreCase(rel) || !"text/css".equalsIgnoreCase(type)) {
                    return null;
                }
            }
            String string = nodeUri = (attr = (Attr)node.getAttributes().getNamedItem(resourceTags.get(nodeName))) != null ? attr.getValue() : null;
            if (!StringUtils.isEmpty((String)nodeUri)) {
                return attr;
            }
        }
        return null;
    }

    private Uri getBaseResolutionUri(Gadget gadget, Node node) {
        Uri pageUri = gadget.getSpec().getUrl();
        Uri baseUri = this.getBaseUri(node.getOwnerDocument());
        return baseUri != null ? baseUri : pageUri;
    }

    @VisibleForTesting
    Uri getBaseUri(Document doc) {
        String baseHref = this.getBaseHref(doc);
        if (baseHref != null) {
            try {
                return Uri.parse((String)baseHref);
            }
            catch (Uri.UriException uriException) {
                // empty catch block
            }
        }
        return null;
    }

    @VisibleForTesting
    String getBaseHref(Document doc) {
        NodeList list = doc.getElementsByTagName("base");
        if (list.getLength() == 0) {
            return null;
        }
        NamedNodeMap nodeMap = list.item(0).getAttributes();
        if (nodeMap == null) {
            return null;
        }
        Attr attr = (Attr)nodeMap.getNamedItem("href");
        return attr != null ? attr.getValue() : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Tags {
        RESOURCES((Map<String, String>)ImmutableMap.builder().put((Object)"body", (Object)"background").put((Object)"img", (Object)"src").put((Object)"input", (Object)"src").put((Object)"link", (Object)"href").put((Object)"script", (Object)"src").build()),
        HYPERLINKS((Map<String, String>)ImmutableMap.builder().put((Object)"a", (Object)"href").put((Object)"area", (Object)"href").put((Object)"q", (Object)"cite").build());

        Map<String, String> resourceTags;

        private Tags(Map<String, String> resourceTags) {
            this.resourceTags = resourceTags;
        }

        public Map<String, String> getResourceTags() {
            return this.resourceTags;
        }
    }
}

