/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.clean.rdbms;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.clean.rdbms.DBCleaner;
import org.exoplatform.services.jcr.impl.clean.rdbms.RecursiveDBCleanHelper;
import org.exoplatform.services.jcr.impl.storage.jdbc.DBConstants;
import org.exoplatform.services.jcr.impl.storage.jdbc.DialectDetecter;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializerHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBCleanService {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.DBCleanService");
    public static final String OLD_OBJECT_SUFFIX = "_OLD";
    private static final int DB2_CONSTRAINT_NAME_LENGTH_LIMIT = 18;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void cleanWorkspaceData(WorkspaceEntry wsEntry) throws RepositoryConfigurationException, NamingException, SQLException {
        String dsName = wsEntry.getContainer().getParameterValue("source-name");
        final DataSource ds = (DataSource)new InitialContext().lookup(dsName);
        if (ds == null) {
            throw new NameNotFoundException("Data source " + dsName + " not found");
        }
        Connection jdbcConn = (Connection)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Connection>(){

            @Override
            public Connection run() throws Exception {
                return ds.getConnection();
            }
        });
        DBCleaner dbCleaner = DBCleanService.getWorkspaceDBCleaner(jdbcConn, wsEntry);
        jdbcConn.setAutoCommit(false);
        try {
            try {
                dbCleaner.executeCleanScripts();
                try {
                    dbCleaner.executeCommitScripts();
                }
                catch (SQLException e) {
                    LOG.error((Object)"Can't remove temporary objects", (Throwable)e);
                }
                jdbcConn.commit();
            }
            catch (SQLException e) {
                jdbcConn.rollback();
                dbCleaner.executeRollbackScripts();
                jdbcConn.commit();
                Object var7_8 = null;
                jdbcConn.close();
                return;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            jdbcConn.close();
            throw throwable;
        }
        jdbcConn.close();
    }

    public static void cleanRepositoryData(RepositoryEntry rEntry) throws RepositoryConfigurationException, NamingException, SQLException {
        for (WorkspaceEntry wsEntry : rEntry.getWorkspaceEntries()) {
            DBCleanService.cleanWorkspaceData(wsEntry);
        }
    }

    public static DBCleaner getRepositoryDBCleaner(Connection jdbcConn, RepositoryEntry repoEntry) throws SQLException, RepositoryConfigurationException {
        boolean isMultiDB = Boolean.parseBoolean(repoEntry.getWorkspaceEntries().get(0).getContainer().getParameterValue("multi-db"));
        if (isMultiDB) {
            return null;
        }
        String dialect = repoEntry.getWorkspaceEntries().get(0).getContainer().getParameterValue("dialect", DBConstants.DB_DIALECT_AUTO);
        if (DBConstants.DB_DIALECT_GENERIC.equals(dialect) || DBConstants.DB_DIALECT_AUTO.equalsIgnoreCase(dialect)) {
            dialect = DialectDetecter.detect(jdbcConn.getMetaData());
        }
        if (dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_SYBASE) && !jdbcConn.getAutoCommit()) {
            jdbcConn.setAutoCommit(true);
        }
        if (dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_ORACLE) || dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_ORACLEOCI) || dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_MYSQL) || dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_MYSQL_UTF8) || dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_SYBASE) || dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_HSQLDB)) {
            ArrayList<String> dbCleanerScripts = new ArrayList<String>();
            dbCleanerScripts.addAll(DBCleanService.getRenameScripts(isMultiDB, dialect));
            dbCleanerScripts.addAll(DBCleanService.getInitializationDBScripts(isMultiDB, dialect));
            dbCleanerScripts.addAll(DBCleanService.getRemoveIndexesScripts(isMultiDB, dialect));
            ArrayList<String> afterRestoreScript = new ArrayList<String>();
            afterRestoreScript.addAll(DBCleanService.getRemoveOldObjectsScripts(isMultiDB, dialect));
            afterRestoreScript.addAll(DBCleanService.getRestoreIndexesScripts(isMultiDB, dialect));
            return new DBCleaner(jdbcConn, dbCleanerScripts, DBCleanService.getRollbackScripts(isMultiDB, dialect), afterRestoreScript);
        }
        ArrayList<String> dbCleanerScripts = new ArrayList<String>();
        dbCleanerScripts.addAll(DBCleanService.getDropTableScripts(isMultiDB, dialect));
        dbCleanerScripts.addAll(DBCleanService.getInitializationDBScripts(isMultiDB, dialect));
        dbCleanerScripts.addAll(DBCleanService.getRemoveIndexesScripts(isMultiDB, dialect));
        return new DBCleaner(jdbcConn, dbCleanerScripts, new ArrayList<String>(), DBCleanService.getRestoreIndexesScripts(isMultiDB, dialect));
    }

    private static List<String> getRemoveIndexesScripts(boolean isMultiDB, String dialect) {
        String multiDb;
        ArrayList<String> dropScript = new ArrayList<String>();
        String string = multiDb = isMultiDB ? "M" : "S";
        if (dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_MYSQL) || dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_MYSQL)) {
            return dropScript;
        }
        String constraintName = DBCleanService.validateConstraintName("JCR_FK_" + multiDb + "ITEM_PARENT", dialect);
        dropScript.add("ALTER TABLE JCR_" + multiDb + "ITEM " + DBCleanService.dropCommand(false, constraintName, dialect));
        if (dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_ORACLE) || dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_ORACLEOCI)) {
            constraintName = DBCleanService.validateConstraintName("JCR_PK_" + multiDb + "VALUE", dialect);
            dropScript.add("ALTER TABLE JCR_" + multiDb + "VALUE " + DBCleanService.dropCommand(true, constraintName, dialect));
            constraintName = DBCleanService.validateConstraintName("JCR_FK_" + multiDb + "VALUE_PROPERTY", dialect);
            dropScript.add("ALTER TABLE JCR_" + multiDb + "VALUE " + DBCleanService.dropCommand(false, constraintName, dialect));
            constraintName = DBCleanService.validateConstraintName("JCR_PK_" + multiDb + "ITEM", dialect);
            dropScript.add("ALTER TABLE JCR_" + multiDb + "ITEM " + DBCleanService.dropCommand(true, constraintName, dialect));
            constraintName = DBCleanService.validateConstraintName("JCR_PK_" + multiDb + "REF", dialect);
            dropScript.add("ALTER TABLE JCR_" + multiDb + "REF " + DBCleanService.dropCommand(true, constraintName, dialect));
            dropScript.add("DROP INDEX JCR_IDX_" + multiDb + "ITEM_PARENT_FK");
            dropScript.add("DROP INDEX JCR_IDX_" + multiDb + "ITEM_PARENT");
            dropScript.add("DROP INDEX JCR_IDX_" + multiDb + "ITEM_PARENT_NAME");
            dropScript.add("DROP INDEX JCR_IDX_" + multiDb + "ITEM_PARENT_ID");
            dropScript.add("DROP INDEX JCR_IDX_" + multiDb + "VALUE_PROPERTY");
            dropScript.add("DROP INDEX JCR_IDX_" + multiDb + "REF_PROPERTY");
        } else if (dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_SYBASE)) {
            dropScript.add("ALTER TABLE  JCR_" + multiDb + "VALUE DROP CONSTRAINT JCR_FK_" + multiDb + "VALUE_PROPERTY");
            dropScript.add("ALTER TABLE  JCR_" + multiDb + "ITEM DROP CONSTRAINT JCR_PK_" + multiDb + "ITEM");
            dropScript.add("ALTER TABLE  JCR_" + multiDb + "VALUE DROP CONSTRAINT JCR_PK_" + multiDb + "VALUE");
        }
        return dropScript;
    }

    private static List<String> getRestoreIndexesScripts(boolean isMultiDB, String dialect) throws RepositoryConfigurationException {
        String constraint;
        String constraintName;
        String multiDb;
        ArrayList<String> addScript = new ArrayList<String>();
        String string = multiDb = isMultiDB ? "M" : "S";
        if (dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_SYBASE)) {
            addScript.add("ALTER TABLE JCR_" + multiDb + "ITEM ADD CONSTRAINT JCR_PK_" + multiDb + "ITEM PRIMARY KEY(ID)");
            addScript.add("ALTER TABLE JCR_" + multiDb + "VALUE ADD CONSTRAINT JCR_PK_" + multiDb + "VALUE PRIMARY KEY(ID)");
            String constraintName2 = DBCleanService.validateConstraintName("JCR_FK_" + multiDb + "ITEM_PARENT", dialect);
            String constraint2 = "CONSTRAINT " + constraintName2 + " FOREIGN KEY(PARENT_ID) REFERENCES JCR_" + multiDb + "ITEM(ID)";
            addScript.add("ALTER TABLE JCR_" + multiDb + "ITEM ADD " + constraint2);
            addScript.add("ALTER TABLE JCR_" + multiDb + "VALUE ADD CONSTRAINT JCR_FK_" + multiDb + "VALUE_PROPERTY FOREIGN KEY(PROPERTY_ID) REFERENCES JCR_" + multiDb + "ITEM(ID)");
            addScript.add(DBInitializerHelper.getObjectScript("CREATE UNIQUE INDEX JCR_IDX_" + multiDb + "ITEM_PARENT ON JCR_" + multiDb + "ITEM", isMultiDB, dialect));
            addScript.add(DBInitializerHelper.getObjectScript("CREATE UNIQUE INDEX JCR_IDX_" + multiDb + "ITEM_PARENT_NAME ON JCR_" + multiDb + "ITEM", isMultiDB, dialect));
            addScript.add(DBInitializerHelper.getObjectScript("CREATE UNIQUE INDEX JCR_IDX_" + multiDb + "ITEM_PARENT_ID ON JCR_" + multiDb + "ITEM", isMultiDB, dialect));
            addScript.add(DBInitializerHelper.getObjectScript("CREATE UNIQUE INDEX JCR_IDX_" + multiDb + "VALUE_PROPERTY ON JCR_" + multiDb + "VALUE", isMultiDB, dialect));
            addScript.add(DBInitializerHelper.getObjectScript("CREATE UNIQUE INDEX JCR_IDX_" + multiDb + "REF_PROPERTY ON JCR_" + multiDb + "REF", isMultiDB, dialect));
            return addScript;
        }
        if (dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_MYSQL) || dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_MYSQL)) {
            constraintName = DBCleanService.validateConstraintName("JCR_FK_" + multiDb + "VALUE_PROPERTY", dialect);
            constraint = "CONSTRAINT " + constraintName + " FOREIGN KEY(PROPERTY_ID) REFERENCES JCR_" + multiDb + "ITEM(ID)";
            addScript.add("ALTER TABLE JCR_" + multiDb + "VALUE ADD " + constraint);
        }
        if (dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_ORACLE) || dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_ORACLEOCI)) {
            constraintName = DBCleanService.validateConstraintName("JCR_PK_" + multiDb + "VALUE", dialect);
            constraint = "CONSTRAINT " + constraintName + " PRIMARY KEY(ID)";
            addScript.add("ALTER TABLE JCR_" + multiDb + "VALUE ADD " + constraint);
            constraintName = DBCleanService.validateConstraintName("JCR_PK_" + multiDb + "ITEM", dialect);
            constraint = "CONSTRAINT " + constraintName + " PRIMARY KEY(ID)";
            addScript.add("ALTER TABLE JCR_" + multiDb + "ITEM ADD " + constraint);
            constraintName = DBCleanService.validateConstraintName("JCR_FK_" + multiDb + "VALUE_PROPERTY", dialect);
            constraint = "CONSTRAINT " + constraintName + " FOREIGN KEY(PROPERTY_ID) REFERENCES JCR_" + multiDb + "ITEM(ID)";
            addScript.add("ALTER TABLE JCR_" + multiDb + "VALUE ADD " + constraint);
            constraintName = DBCleanService.validateConstraintName("JCR_PK_" + multiDb + "REF", dialect);
            constraint = "CONSTRAINT " + constraintName + " PRIMARY KEY(NODE_ID, PROPERTY_ID, ORDER_NUM)";
            addScript.add("ALTER TABLE JCR_" + multiDb + "REF ADD " + constraint);
            addScript.add(DBInitializerHelper.getObjectScript("JCR_IDX_" + multiDb + "ITEM_PARENT_FK ON JCR_" + multiDb + "ITEM", isMultiDB, dialect));
            addScript.add(DBInitializerHelper.getObjectScript("JCR_IDX_" + multiDb + "ITEM_PARENT ON JCR_" + multiDb + "ITEM", isMultiDB, dialect));
            addScript.add(DBInitializerHelper.getObjectScript("JCR_IDX_" + multiDb + "ITEM_PARENT_NAME ON JCR_" + multiDb + "ITEM", isMultiDB, dialect));
            addScript.add(DBInitializerHelper.getObjectScript("JCR_IDX_" + multiDb + "ITEM_PARENT_ID ON JCR_" + multiDb + "ITEM", isMultiDB, dialect));
            addScript.add(DBInitializerHelper.getObjectScript("JCR_IDX_" + multiDb + "VALUE_PROPERTY ON JCR_" + multiDb + "VALUE", isMultiDB, dialect));
            addScript.add(DBInitializerHelper.getObjectScript("JCR_IDX_" + multiDb + "REF_PROPERTY ON JCR_" + multiDb + "REF", isMultiDB, dialect));
        }
        constraintName = DBCleanService.validateConstraintName("JCR_FK_" + multiDb + "ITEM_PARENT", dialect);
        constraint = "CONSTRAINT " + constraintName + " FOREIGN KEY(PARENT_ID) REFERENCES JCR_" + multiDb + "ITEM(ID)";
        addScript.add("ALTER TABLE JCR_" + multiDb + "ITEM ADD " + constraint);
        return addScript;
    }

    private static String validateConstraintName(String string, String dialect) {
        if (dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_DB2) || dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_DB2V8)) {
            return string.substring(0, 18);
        }
        return string;
    }

    protected static String dropCommand(boolean isPrimaryKey, String constraintName, String dialect) {
        if (dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_MYSQL) || dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_MYSQL_UTF8)) {
            return isPrimaryKey ? "DROP PRIMARY KEY" : "DROP FOREIGN KEY " + constraintName;
        }
        return "DROP CONSTRAINT " + constraintName;
    }

    protected static List<String> getDropTableScripts(boolean multiDb, String dialect) {
        String isMultiDB = multiDb ? "M" : "S";
        ArrayList<String> cleanScripts = new ArrayList<String>();
        if (dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_ORACLE) || dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_ORACLEOCI)) {
            cleanScripts.add("DROP TRIGGER BI_JCR_" + isMultiDB + "VALUE");
            cleanScripts.add("DROP SEQUENCE JCR_" + isMultiDB + "VALUE_SEQ");
        }
        cleanScripts.add("DROP TABLE JCR_" + isMultiDB + "VALUE");
        cleanScripts.add("DROP TABLE JCR_" + isMultiDB + "ITEM");
        cleanScripts.add("DROP TABLE JCR_" + isMultiDB + "REF");
        return cleanScripts;
    }

    protected static List<String> getRenameScripts(boolean multiDb, String dialect) {
        String isMultiDB = multiDb ? "M" : "S";
        ArrayList<String> renameScripts = new ArrayList<String>();
        if (dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_ORACLE) || dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_ORACLEOCI)) {
            renameScripts.add("ALTER TABLE JCR_" + isMultiDB + "VALUE RENAME TO JCR_" + isMultiDB + "VALUE" + OLD_OBJECT_SUFFIX);
            renameScripts.add("ALTER TABLE JCR_" + isMultiDB + "VALUE" + OLD_OBJECT_SUFFIX + " RENAME CONSTRAINT JCR_PK_" + isMultiDB + "VALUE TO JCR_PK_" + isMultiDB + "VALUE" + OLD_OBJECT_SUFFIX);
            renameScripts.add("ALTER TABLE JCR_" + isMultiDB + "VALUE" + OLD_OBJECT_SUFFIX + " RENAME CONSTRAINT JCR_FK_" + isMultiDB + "VALUE_PROPERTY TO JCR_FK_" + isMultiDB + "VALUE_PROPERTY" + OLD_OBJECT_SUFFIX);
            renameScripts.add("ALTER INDEX JCR_PK_" + isMultiDB + "VALUE RENAME TO JCR_PK_" + isMultiDB + "VALUE" + OLD_OBJECT_SUFFIX);
            renameScripts.add("ALTER INDEX JCR_IDX_" + isMultiDB + "VALUE_PROPERTY RENAME TO JCR_IDX_" + isMultiDB + "VALUE_PROPERTY" + OLD_OBJECT_SUFFIX);
            renameScripts.add("RENAME JCR_" + isMultiDB + "VALUE_SEQ TO JCR_" + isMultiDB + "VALUE_SEQ" + OLD_OBJECT_SUFFIX);
            renameScripts.add("ALTER TRIGGER BI_JCR_" + isMultiDB + "VALUE RENAME TO BI_JCR_" + isMultiDB + "VALUE" + OLD_OBJECT_SUFFIX);
            renameScripts.add("ALTER TABLE JCR_" + isMultiDB + "ITEM RENAME TO JCR_" + isMultiDB + "ITEM" + OLD_OBJECT_SUFFIX);
            renameScripts.add("ALTER TABLE JCR_" + isMultiDB + "ITEM" + OLD_OBJECT_SUFFIX + " RENAME CONSTRAINT JCR_PK_" + isMultiDB + "ITEM TO JCR_PK_" + isMultiDB + "ITEM" + OLD_OBJECT_SUFFIX);
            renameScripts.add("ALTER TABLE JCR_" + isMultiDB + "ITEM" + OLD_OBJECT_SUFFIX + " RENAME CONSTRAINT JCR_FK_" + isMultiDB + "ITEM_PARENT TO JCR_FK_" + isMultiDB + "ITEM_PARENT" + OLD_OBJECT_SUFFIX);
            renameScripts.add("ALTER INDEX JCR_PK_" + isMultiDB + "ITEM RENAME TO JCR_PK_" + isMultiDB + "ITEM" + OLD_OBJECT_SUFFIX);
            renameScripts.add("ALTER INDEX JCR_IDX_" + isMultiDB + "ITEM_PARENT_FK RENAME TO JCR_IDX_" + isMultiDB + "ITEM_PARENT_FK" + OLD_OBJECT_SUFFIX);
            renameScripts.add("ALTER INDEX JCR_IDX_" + isMultiDB + "ITEM_PARENT RENAME TO JCR_IDX_" + isMultiDB + "ITEM_PARENT" + OLD_OBJECT_SUFFIX);
            renameScripts.add("ALTER INDEX JCR_IDX_" + isMultiDB + "ITEM_PARENT_NAME RENAME TO JCR_IDX_" + isMultiDB + "ITEM_PARENT_NAME" + OLD_OBJECT_SUFFIX);
            renameScripts.add("ALTER INDEX JCR_IDX_" + isMultiDB + "ITEM_PARENT_ID RENAME TO JCR_IDX_" + isMultiDB + "ITEM_PARENT_ID" + OLD_OBJECT_SUFFIX);
            renameScripts.add("ALTER TABLE JCR_" + isMultiDB + "REF RENAME TO JCR_" + isMultiDB + "REF" + OLD_OBJECT_SUFFIX);
            renameScripts.add("ALTER TABLE JCR_" + isMultiDB + "REF" + OLD_OBJECT_SUFFIX + " RENAME CONSTRAINT JCR_PK_" + isMultiDB + "REF TO JCR_PK_" + isMultiDB + "REF" + OLD_OBJECT_SUFFIX);
            renameScripts.add("ALTER INDEX JCR_PK_" + isMultiDB + "REF RENAME TO JCR_PK_" + isMultiDB + "REF" + OLD_OBJECT_SUFFIX);
            renameScripts.add("ALTER INDEX JCR_IDX_" + isMultiDB + "REF_PROPERTY RENAME TO JCR_IDX_" + isMultiDB + "REF_PROPERTY" + OLD_OBJECT_SUFFIX);
        } else if (dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_MYSQL) || dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_MYSQL_UTF8)) {
            renameScripts.add("ALTER TABLE JCR_" + isMultiDB + "VALUE RENAME TO JCR_" + isMultiDB + "VALUE" + OLD_OBJECT_SUFFIX);
            renameScripts.add("ALTER TABLE JCR_" + isMultiDB + "ITEM RENAME TO JCR_" + isMultiDB + "ITEM" + OLD_OBJECT_SUFFIX);
            renameScripts.add("ALTER TABLE JCR_" + isMultiDB + "REF RENAME TO JCR_" + isMultiDB + "REF" + OLD_OBJECT_SUFFIX);
        } else if (dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_SYBASE)) {
            renameScripts.add("sp_rename JCR_" + isMultiDB + "VALUE, JCR_" + isMultiDB + "VALUE" + OLD_OBJECT_SUFFIX);
            renameScripts.add("sp_rename JCR_" + isMultiDB + "ITEM, JCR_" + isMultiDB + "ITEM" + OLD_OBJECT_SUFFIX);
            renameScripts.add("sp_rename JCR_" + isMultiDB + "REF, JCR_" + isMultiDB + "REF" + OLD_OBJECT_SUFFIX);
            renameScripts.add("sp_rename JCR_FK_" + isMultiDB + "VALUE_PROPERTY, JCR_FK_" + isMultiDB + "VALUE_PROPERTY" + OLD_OBJECT_SUFFIX);
            renameScripts.add("sp_rename JCR_FK_" + isMultiDB + "ITEM_PARENT, JCR_FK_" + isMultiDB + "ITEM_PARENT_OLD");
        } else if (dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_HSQLDB)) {
            renameScripts.add("ALTER TABLE JCR_" + isMultiDB + "VALUE RENAME TO JCR_" + isMultiDB + "VALUE" + OLD_OBJECT_SUFFIX);
            renameScripts.add("ALTER TABLE JCR_" + isMultiDB + "ITEM RENAME TO JCR_" + isMultiDB + "ITEM" + OLD_OBJECT_SUFFIX);
            renameScripts.add("ALTER TABLE JCR_" + isMultiDB + "REF RENAME TO JCR_" + isMultiDB + "REF" + OLD_OBJECT_SUFFIX);
            renameScripts.add("ALTER TABLE  JCR_" + isMultiDB + "VALUE" + OLD_OBJECT_SUFFIX + " DROP CONSTRAINT JCR_FK_" + isMultiDB + "VALUE_PROPERTY");
            renameScripts.add("ALTER TABLE  JCR_" + isMultiDB + "ITEM" + OLD_OBJECT_SUFFIX + " DROP CONSTRAINT JCR_FK_" + isMultiDB + "ITEM_PARENT");
            renameScripts.add("ALTER TABLE  JCR_" + isMultiDB + "ITEM" + OLD_OBJECT_SUFFIX + " DROP CONSTRAINT JCR_PK_" + isMultiDB + "ITEM");
            renameScripts.add("ALTER TABLE  JCR_" + isMultiDB + "VALUE" + OLD_OBJECT_SUFFIX + " DROP CONSTRAINT JCR_PK_" + isMultiDB + "VALUE");
            renameScripts.add("ALTER TABLE  JCR_" + isMultiDB + "REF" + OLD_OBJECT_SUFFIX + " DROP CONSTRAINT JCR_PK_" + isMultiDB + "REF");
            renameScripts.add("ALTER INDEX  JCR_IDX_" + isMultiDB + "ITEM_PARENT RENAME TO JCR_IDX_" + isMultiDB + "ITEM_PARENT" + OLD_OBJECT_SUFFIX);
            renameScripts.add("ALTER INDEX  JCR_IDX_" + isMultiDB + "ITEM_PARENT_NAME RENAME TO JCR_IDX_" + isMultiDB + "ITEM_PARENT_NAME" + OLD_OBJECT_SUFFIX);
            renameScripts.add("ALTER INDEX  JCR_IDX_" + isMultiDB + "ITEM_PARENT_ID RENAME TO JCR_IDX_" + isMultiDB + "ITEM_PARENT_ID" + OLD_OBJECT_SUFFIX);
            renameScripts.add("ALTER INDEX  JCR_IDX_" + isMultiDB + "VALUE_PROPERTY RENAME TO JCR_IDX_" + isMultiDB + "VALUE_PROPERTY" + OLD_OBJECT_SUFFIX);
            renameScripts.add("ALTER INDEX  JCR_IDX_" + isMultiDB + "REF_PROPERTY RENAME TO JCR_IDX_" + isMultiDB + "REF_PROPERTY" + OLD_OBJECT_SUFFIX);
        }
        return renameScripts;
    }

    protected static List<String> getRollbackScripts(boolean multiDb, String dialect) throws RepositoryConfigurationException {
        String isMultiDB = multiDb ? "M" : "S";
        ArrayList<String> rollbackScripts = new ArrayList<String>();
        rollbackScripts.addAll(DBCleanService.getDropTableScripts(multiDb, dialect));
        if (dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_ORACLE) || dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_ORACLEOCI)) {
            rollbackScripts.add("ALTER TABLE JCR_" + isMultiDB + "VALUE" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_" + isMultiDB + "VALUE");
            rollbackScripts.add("ALTER TABLE JCR_" + isMultiDB + "VALUE RENAME CONSTRAINT JCR_PK_" + isMultiDB + "VALUE" + OLD_OBJECT_SUFFIX + " TO JCR_PK_" + isMultiDB + "VALUE");
            rollbackScripts.add("ALTER TABLE JCR_" + isMultiDB + "VALUE RENAME CONSTRAINT JCR_FK_" + isMultiDB + "VALUE_PROPERTY" + OLD_OBJECT_SUFFIX + " TO JCR_FK_" + isMultiDB + "VALUE_PROPERTY");
            rollbackScripts.add("ALTER INDEX JCR_PK_" + isMultiDB + "VALUE" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_PK_" + isMultiDB + "VALUE");
            rollbackScripts.add("ALTER INDEX JCR_IDX_" + isMultiDB + "VALUE_PROPERTY" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_IDX_" + isMultiDB + "VALUE_PROPERTY");
            rollbackScripts.add("RENAME JCR_" + isMultiDB + "VALUE_SEQ" + OLD_OBJECT_SUFFIX + " TO JCR_" + isMultiDB + "VALUE_SEQ");
            rollbackScripts.add("ALTER TRIGGER BI_JCR_" + isMultiDB + "VALUE" + OLD_OBJECT_SUFFIX + " RENAME TO BI_JCR_" + isMultiDB + "VALUE");
            rollbackScripts.add("ALTER TABLE JCR_" + isMultiDB + "ITEM" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_" + isMultiDB + "ITEM");
            rollbackScripts.add("ALTER TABLE JCR_" + isMultiDB + "ITEM RENAME CONSTRAINT JCR_PK_" + isMultiDB + "ITEM" + OLD_OBJECT_SUFFIX + " TO JCR_PK_" + isMultiDB + "ITEM");
            rollbackScripts.add("ALTER TABLE JCR_" + isMultiDB + "ITEM RENAME CONSTRAINT JCR_FK_" + isMultiDB + "ITEM_PARENT" + OLD_OBJECT_SUFFIX + " TO JCR_FK_" + isMultiDB + "ITEM_PARENT");
            rollbackScripts.add("ALTER INDEX JCR_PK_" + isMultiDB + "ITEM" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_PK_" + isMultiDB + "ITEM");
            rollbackScripts.add("ALTER INDEX JCR_IDX_" + isMultiDB + "ITEM_PARENT_FK" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_IDX_" + isMultiDB + "ITEM_PARENT_FK");
            rollbackScripts.add("ALTER INDEX JCR_IDX_" + isMultiDB + "ITEM_PARENT" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_IDX_" + isMultiDB + "ITEM_PARENT");
            rollbackScripts.add("ALTER INDEX JCR_IDX_" + isMultiDB + "ITEM_PARENT_NAME" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_IDX_" + isMultiDB + "ITEM_PARENT_NAME");
            rollbackScripts.add("ALTER INDEX JCR_IDX_" + isMultiDB + "ITEM_PARENT_ID" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_IDX_" + isMultiDB + "ITEM_PARENT_ID");
            rollbackScripts.add("ALTER TABLE JCR_" + isMultiDB + "REF" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_" + isMultiDB + "REF");
            rollbackScripts.add("ALTER TABLE JCR_" + isMultiDB + "REF RENAME CONSTRAINT JCR_PK_" + isMultiDB + "REF" + OLD_OBJECT_SUFFIX + " TO JCR_PK_" + isMultiDB + "REF");
            rollbackScripts.add("ALTER INDEX JCR_PK_" + isMultiDB + "REF" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_PK_" + isMultiDB + "REF");
            rollbackScripts.add("ALTER INDEX JCR_IDX_" + isMultiDB + "REF_PROPERTY" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_IDX_" + isMultiDB + "REF_PROPERTY");
        } else if (dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_MYSQL) || dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_MYSQL_UTF8)) {
            rollbackScripts.add("ALTER TABLE JCR_" + isMultiDB + "ITEM" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_" + isMultiDB + "ITEM");
            rollbackScripts.add("ALTER TABLE JCR_" + isMultiDB + "VALUE" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_" + isMultiDB + "VALUE");
            rollbackScripts.add("ALTER TABLE JCR_" + isMultiDB + "REF" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_" + isMultiDB + "REF");
        } else if (dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_SYBASE)) {
            rollbackScripts.add("sp_rename JCR_" + isMultiDB + "VALUE" + OLD_OBJECT_SUFFIX + ", JCR_" + isMultiDB + "VALUE");
            rollbackScripts.add("sp_rename JCR_" + isMultiDB + "ITEM" + OLD_OBJECT_SUFFIX + ", JCR_" + isMultiDB + "ITEM");
            rollbackScripts.add("sp_rename JCR_" + isMultiDB + "REF" + OLD_OBJECT_SUFFIX + ", JCR_" + isMultiDB + "REF");
            rollbackScripts.add("sp_rename JCR_FK_" + isMultiDB + "VALUE_PROPERTY" + OLD_OBJECT_SUFFIX + ", JCR_FK_" + isMultiDB + "VALUE_PROPERTY");
            rollbackScripts.add("sp_rename JCR_FK_" + isMultiDB + "ITEM_PARENT" + OLD_OBJECT_SUFFIX + ", JCR_FK_" + isMultiDB + "ITEM_PARENT");
        } else if (dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_HSQLDB)) {
            rollbackScripts.add("ALTER TABLE JCR_" + isMultiDB + "VALUE" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_" + isMultiDB + "VALUE");
            rollbackScripts.add("ALTER TABLE JCR_" + isMultiDB + "ITEM" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_" + isMultiDB + "ITEM");
            rollbackScripts.add("ALTER TABLE JCR_" + isMultiDB + "REF" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_" + isMultiDB + "REF");
            rollbackScripts.add("ALTER TABLE  JCR_" + isMultiDB + "ITEM ADD CONSTRAINT JCR_PK_" + isMultiDB + "ITEM PRIMARY KEY(ID)");
            rollbackScripts.add("ALTER TABLE  JCR_" + isMultiDB + "VALUE ADD CONSTRAINT JCR_FK_" + isMultiDB + "VALUE_PROPERTY FOREIGN KEY(PROPERTY_ID) REFERENCES JCR_" + isMultiDB + "ITEM(ID)");
            rollbackScripts.add("ALTER TABLE  JCR_" + isMultiDB + "ITEM ADD CONSTRAINT JCR_FK_" + isMultiDB + "ITEM_PARENT FOREIGN KEY(PARENT_ID) REFERENCES JCR_" + isMultiDB + "ITEM(ID)");
            rollbackScripts.add("ALTER TABLE  JCR_" + isMultiDB + "VALUE ADD CONSTRAINT JCR_PK_" + isMultiDB + "VALUE PRIMARY KEY(ID)");
            rollbackScripts.add("ALTER TABLE  JCR_" + isMultiDB + "REF ADD CONSTRAINT JCR_PK_" + isMultiDB + "REF PRIMARY KEY(NODE_ID, PROPERTY_ID, ORDER_NUM)");
            rollbackScripts.add("ALTER INDEX  JCR_IDX_" + isMultiDB + "ITEM_PARENT" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_IDX_" + isMultiDB + "ITEM_PARENT");
            rollbackScripts.add("ALTER INDEX  JCR_IDX_" + isMultiDB + "ITEM_PARENT_NAME" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_IDX_" + isMultiDB + "ITEM_PARENT_NAME");
            rollbackScripts.add("ALTER INDEX  JCR_IDX_" + isMultiDB + "ITEM_PARENT_ID" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_IDX_" + isMultiDB + "ITEM_PARENT_ID");
            rollbackScripts.add("ALTER INDEX  JCR_IDX_" + isMultiDB + "VALUE_PROPERTY" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_IDX_" + isMultiDB + "VALUE_PROPERTY");
            rollbackScripts.add("ALTER INDEX  JCR_IDX_" + isMultiDB + "REF_PROPERTY" + OLD_OBJECT_SUFFIX + " RENAME TO JCR_IDX_" + isMultiDB + "REF_PROPERTY");
        }
        return rollbackScripts;
    }

    protected static List<String> getRemoveOldObjectsScripts(boolean multiDb, String dialect) {
        ArrayList<String> afterRetoreScripts = new ArrayList<String>();
        for (String query : DBCleanService.getDropTableScripts(multiDb, dialect)) {
            afterRetoreScripts.add(query + OLD_OBJECT_SUFFIX);
        }
        return afterRetoreScripts;
    }

    protected static List<String> getInitializationDBScripts(boolean isMultiDb, String dialect) throws RepositoryConfigurationException {
        ArrayList<String> scripts;
        block7: {
            String multiDb;
            block6: {
                String script;
                multiDb = isMultiDb ? "M" : "S";
                String scriptsPath = DBInitializerHelper.scriptPath(dialect, isMultiDb);
                try {
                    script = DBInitializerHelper.readScriptResource(scriptsPath);
                }
                catch (IOException e) {
                    throw new RepositoryConfigurationException("Can not read script file " + scriptsPath, e);
                }
                scripts = new ArrayList<String>();
                for (String query : DBInitializerHelper.scripts(script)) {
                    if (query.contains("CREATE TABLE JCR_" + multiDb + "CONTAINER")) continue;
                    scripts.add(DBInitializerHelper.cleanWhitespaces(query));
                }
                scripts.add(DBInitializerHelper.getRootNodeInitializeScript(isMultiDb));
                if (!dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_MYSQL) && !dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_MYSQL_UTF8)) break block6;
                for (int i = 0; i < scripts.size(); ++i) {
                    String query = (String)scripts.get(i);
                    if (query.contains("JCR_PK_" + multiDb + "ITEM PRIMARY KEY(ID),")) {
                        query = query.replace("JCR_PK_" + multiDb + "ITEM PRIMARY KEY(ID),", "JCR_PK_" + multiDb + "ITEM PRIMARY KEY(ID)");
                        query = query.replace("CONSTRAINT JCR_FK_" + multiDb + "ITEM_PARENT FOREIGN KEY(PARENT_ID) REFERENCES JCR_" + multiDb + "ITEM(ID)", "");
                        scripts.set(i, query);
                        continue;
                    }
                    if (!query.contains("CONSTRAINT JCR_PK_" + multiDb + "VALUE PRIMARY KEY(ID),")) continue;
                    query = query.replace("CONSTRAINT JCR_PK_" + multiDb + "VALUE PRIMARY KEY(ID),", "CONSTRAINT JCR_PK_" + multiDb + "VALUE PRIMARY KEY(ID)");
                    query = query.replace("CONSTRAINT JCR_FK_" + multiDb + "VALUE_PROPERTY FOREIGN KEY(PROPERTY_ID) REFERENCES JCR_" + multiDb + "ITEM(ID)", "");
                    scripts.set(i, query);
                }
                break block7;
            }
            if (!dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_SYBASE)) break block7;
            for (int i = 0; i < scripts.size(); ++i) {
                String query = (String)scripts.get(i);
                if (!query.contains("JCR_IDX_" + multiDb + "ITEM_PARENT") && !query.contains("JCR_IDX_" + multiDb + "ITEM_PARENT_NAME") && !query.contains("JCR_IDX_" + multiDb + "ITEM_PARENT_ID") && !query.contains("JCR_IDX_" + multiDb + "VALUE_PROPERTY") && !query.contains("JCR_IDX_" + multiDb + "REF_PROPERTY")) continue;
                scripts.remove(i);
                --i;
            }
        }
        return scripts;
    }

    public static DBCleaner getWorkspaceDBCleaner(Connection jdbcConn, WorkspaceEntry wsEntry) throws SQLException, RepositoryConfigurationException {
        boolean isMultiDB = Boolean.parseBoolean(wsEntry.getContainer().getParameterValue("multi-db"));
        String dialect = wsEntry.getContainer().getParameterValue("dialect", DBConstants.DB_DIALECT_AUTO);
        if (DBConstants.DB_DIALECT_GENERIC.equals(dialect) || DBConstants.DB_DIALECT_AUTO.equalsIgnoreCase(dialect)) {
            dialect = DialectDetecter.detect(jdbcConn.getMetaData());
        }
        if (dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_SYBASE) && !jdbcConn.getAutoCommit()) {
            jdbcConn.setAutoCommit(true);
        }
        if (!isMultiDB) {
            boolean cleanWithHelper = false;
            if (dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_HSQLDB)) {
                cleanWithHelper = true;
            } else if (dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_MYSQL) || dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_MYSQL_UTF8)) {
                String engine;
                cleanWithHelper = true;
                Statement st = jdbcConn.createStatement();
                st.execute("SELECT ENGINE FROM information_schema.TABLES where TABLE_SCHEMA='" + jdbcConn.getCatalog() + "' and (TABLE_NAME='JCR_SITEM' or TABLE_NAME='JCR_MITEM')");
                ResultSet result = st.getResultSet();
                if (result.next() && (engine = result.getString("ENGINE")).equalsIgnoreCase("MyISAM")) {
                    cleanWithHelper = false;
                }
            }
            String containerName = wsEntry.getName();
            String multiDb = isMultiDB ? "M" : "S";
            ArrayList<String> cleanScripts = new ArrayList<String>();
            ArrayList<String> commitScripts = new ArrayList<String>();
            ArrayList<String> rollbackScripts = new ArrayList<String>();
            String constraintName = DBCleanService.validateConstraintName("JCR_FK_" + multiDb + "ITEM_PARENT", dialect);
            cleanScripts.add("ALTER TABLE JCR_" + multiDb + "ITEM " + DBCleanService.dropCommand(false, constraintName, dialect));
            constraintName = DBCleanService.validateConstraintName("JCR_FK_" + multiDb + "ITEM_PARENT", dialect);
            String constraint = "CONSTRAINT " + constraintName + " FOREIGN KEY(PARENT_ID) REFERENCES JCR_" + multiDb + "ITEM(ID)";
            commitScripts.add("ALTER TABLE JCR_" + multiDb + "ITEM ADD " + constraint);
            rollbackScripts.add("ALTER TABLE JCR_" + multiDb + "ITEM ADD " + constraint);
            cleanScripts.add("delete from JCR_SVALUE where PROPERTY_ID IN (select ID from JCR_SITEM where CONTAINER_NAME='" + containerName + "')");
            cleanScripts.add("delete from JCR_SREF where PROPERTY_ID IN (select ID from JCR_SITEM where CONTAINER_NAME='" + containerName + "')");
            if (cleanWithHelper) {
                cleanScripts.add("delete from JCR_SITEM where I_CLASS=2 and CONTAINER_NAME='" + containerName + "'");
                String selectItems = "select ID from JCR_SITEM where I_CLASS=1 and CONTAINER_NAME='" + containerName + "' and PARENT_ID=?";
                String deleteItems = "delete from JCR_SITEM where I_CLASS=1 and CONTAINER_NAME='" + containerName + "' and PARENT_ID=?";
                return new DBCleaner(jdbcConn, cleanScripts, rollbackScripts, commitScripts, new RecursiveDBCleanHelper(jdbcConn, selectItems, deleteItems));
            }
            cleanScripts.add("delete from JCR_SITEM where CONTAINER_NAME='" + containerName + "'");
            return new DBCleaner(jdbcConn, cleanScripts, rollbackScripts, commitScripts);
        }
        if (dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_ORACLE) || dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_ORACLEOCI) || dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_MYSQL) || dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_MYSQL_UTF8) || dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_SYBASE)) {
            ArrayList<String> cleanScripts = new ArrayList<String>();
            cleanScripts.addAll(DBCleanService.getRenameScripts(isMultiDB, dialect));
            cleanScripts.addAll(DBCleanService.getInitializationDBScripts(isMultiDB, dialect));
            cleanScripts.addAll(DBCleanService.getRemoveIndexesScripts(isMultiDB, dialect));
            ArrayList<String> commitScript = new ArrayList<String>();
            commitScript.addAll(DBCleanService.getRemoveOldObjectsScripts(isMultiDB, dialect));
            commitScript.addAll(DBCleanService.getRestoreIndexesScripts(isMultiDB, dialect));
            return new DBCleaner(jdbcConn, cleanScripts, DBCleanService.getRollbackScripts(isMultiDB, dialect), commitScript);
        }
        ArrayList<String> cleanScripts = new ArrayList<String>();
        cleanScripts.addAll(DBCleanService.getDropTableScripts(isMultiDB, dialect));
        cleanScripts.addAll(DBCleanService.getInitializationDBScripts(isMultiDB, dialect));
        cleanScripts.addAll(DBCleanService.getRemoveIndexesScripts(isMultiDB, dialect));
        return new DBCleaner(jdbcConn, cleanScripts, new ArrayList<String>(), DBCleanService.getRestoreIndexesScripts(isMultiDB, dialect));
    }
}

