/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.beans;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import org.htmlparser.Parser;
import org.htmlparser.filters.NodeClassFilter;
import org.htmlparser.tags.LinkTag;
import org.htmlparser.util.EncodingChangeException;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;

public class LinkBean
implements Serializable {
    public static final String PROP_LINKS_PROPERTY = "links";
    public static final String PROP_URL_PROPERTY = "URL";
    protected PropertyChangeSupport mPropertySupport = new PropertyChangeSupport(this);
    protected URL[] mLinks = null;
    protected Parser mParser = new Parser();

    protected URL[] extractLinks() throws ParserException {
        NodeList list;
        this.mParser.reset();
        NodeClassFilter filter = new NodeClassFilter(LinkTag.class);
        try {
            list = this.mParser.extractAllNodesThatMatch(filter);
        }
        catch (EncodingChangeException ece) {
            this.mParser.reset();
            list = this.mParser.extractAllNodesThatMatch(filter);
        }
        Vector<URL> vector = new Vector<URL>();
        for (int i = 0; i < list.size(); ++i) {
            try {
                LinkTag link = (LinkTag)list.elementAt(i);
                vector.add(new URL(link.getLink()));
                continue;
            }
            catch (MalformedURLException murle) {
                // empty catch block
            }
        }
        Object[] ret = new URL[vector.size()];
        vector.copyInto(ret);
        return ret;
    }

    protected boolean equivalent(URL[] array1, URL[] array2) {
        boolean ret = false;
        if (null == array1 && null == array2) {
            ret = true;
        } else if (null != array1 && null != array2 && array1.length == array2.length) {
            ret = true;
            for (int i = 0; i < array1.length && ret; ++i) {
                if (array1[i] == array2[i]) continue;
                ret = false;
            }
        }
        return ret;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.mPropertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.mPropertySupport.removePropertyChangeListener(listener);
    }

    private void setLinks() {
        String url = this.getURL();
        if (null != url) {
            try {
                URL[] urls = this.extractLinks();
                if (!this.equivalent(this.mLinks, urls)) {
                    URL[] oldValue = this.mLinks;
                    this.mLinks = urls;
                    this.mPropertySupport.firePropertyChange(PROP_LINKS_PROPERTY, oldValue, this.mLinks);
                }
            }
            catch (ParserException hpe) {
                this.mLinks = null;
            }
        }
    }

    public URL[] getLinks() {
        if (null == this.mLinks) {
            try {
                this.mLinks = this.extractLinks();
                this.mPropertySupport.firePropertyChange(PROP_LINKS_PROPERTY, null, this.mLinks);
            }
            catch (ParserException hpe) {
                this.mLinks = null;
            }
        }
        return this.mLinks;
    }

    public String getURL() {
        return this.mParser.getURL();
    }

    public void setURL(String url) {
        String old = this.getURL();
        if (null == old && null != url || null != old && !old.equals(url)) {
            try {
                this.mParser.setURL(url);
                this.mPropertySupport.firePropertyChange(PROP_URL_PROPERTY, old, this.getURL());
                this.setLinks();
            }
            catch (ParserException parserException) {
                // empty catch block
            }
        }
    }

    public URLConnection getConnection() {
        return this.mParser.getConnection();
    }

    public void setConnection(URLConnection connection) {
        try {
            this.mParser.setConnection(connection);
            this.setLinks();
        }
        catch (ParserException parserException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        if (0 >= args.length) {
            System.out.println("Usage: java -classpath htmlparser.jar org.htmlparser.beans.LinkBean <http://whatever_url>");
        } else {
            LinkBean lb = new LinkBean();
            lb.setURL(args[0]);
            URL[] urls = lb.getLinks();
            for (int i = 0; i < urls.length; ++i) {
                System.out.println(urls[i]);
            }
        }
    }
}

