/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.swing;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.exoplatform.swing.Application;
import org.exoplatform.swing.event.EventManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Workspaces
extends JDesktopPane {
    public static final String OPEN_FRAME_EVENT = "app.event.open-frame";
    public static final String CLOSE_FRAME_EVENT = "app.event.close-frame";
    private static Map<String, ViewFrame> openFrames_ = new HashMap<String, ViewFrame>();
    public static ViewFrame frame;

    public Workspaces() {
        this.setDragMode(1);
        this.setName("Workspaces");
    }

    public void closeFrame(JInternalFrame frame) throws Exception {
        openFrames_.remove(Integer.toString(frame.hashCode()));
        EventManager.getInstance().broadcast(CLOSE_FRAME_EVENT, this, frame);
    }

    public JInternalFrame openFrame(String label) throws Exception {
        frame = new ViewFrame(label);
        frame.setSize(700, 500);
        frame.setLocation(15 * openFrames_.size(), 15 * openFrames_.size());
        frame.setVisible(true);
        frame.setSelected(true);
        frame.addInternalFrameListener(new FrameEventListener());
        this.add(frame);
        openFrames_.put(Integer.toString(frame.hashCode()), frame);
        frame.toFront();
        System.out.println("frame:" + frame.getTitle());
        EventManager.getInstance().broadcast(OPEN_FRAME_EVENT, this, frame);
        return frame;
    }

    public JInternalFrame getFrame(String id) {
        return openFrames_.get(id);
    }

    public Map<String, ViewFrame> getOpenFrames() {
        return openFrames_;
    }

    public static class FrameEventListener
    implements InternalFrameListener {
        public void internalFrameActivated(InternalFrameEvent event) {
        }

        public void internalFrameClosed(InternalFrameEvent event) {
        }

        public void internalFrameClosing(InternalFrameEvent event) {
            Workspaces workspaces = Application.getInstance().getWorkspaces();
            JInternalFrame frame = (JInternalFrame)event.getSource();
            try {
                workspaces.closeFrame(frame);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void internalFrameDeactivated(InternalFrameEvent event) {
        }

        public void internalFrameDeiconified(InternalFrameEvent event) {
        }

        public void internalFrameIconified(InternalFrameEvent event) {
            event.getInternalFrame().hide();
        }

        public void internalFrameOpened(InternalFrameEvent event) {
        }
    }

    public static class ViewFrame
    extends JInternalFrame {
        public ViewFrame(String label) {
            super(label, true, true, true, true);
        }
    }
}

