/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.Dashboard;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageBody;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.SiteBody;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.pom.spi.gadget.Gadget;
import org.exoplatform.portal.webui.application.PortletState;
import org.exoplatform.portal.webui.application.UIGadget;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.container.UIColumnContainer;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.container.UITabContainer;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.page.UISiteBody;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.core.UIComponent;
import org.gatein.common.net.media.MediaType;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.info.ModeInfo;
import org.gatein.pc.api.info.PortletInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalDataMapper {
    protected static final Log log = ExoLogger.getLogger((String)"portal:PortalDataMapper");

    public static ModelObject buildModelObject(UIComponent uiComponent) {
        Application<Gadget> model = null;
        if (uiComponent instanceof UIPortal) {
            model = PortalDataMapper.toPortal((UIPortal)uiComponent);
        } else if (uiComponent instanceof UIPageBody) {
            model = new PageBody(((UIPageBody)uiComponent).getStorageId());
        } else if (uiComponent instanceof UIPage) {
            model = PortalDataMapper.toPageModel((UIPage)uiComponent);
        } else if (uiComponent instanceof UIPortlet) {
            model = PortalDataMapper.toPortletModel((UIPortlet)uiComponent);
        } else if (uiComponent instanceof UIContainer) {
            model = PortalDataMapper.toContainer((UIContainer)uiComponent);
        } else if (uiComponent instanceof UIGadget) {
            model = PortalDataMapper.toGadget((UIGadget)uiComponent);
        }
        return model;
    }

    private static Application<Gadget> toGadget(UIGadget uiGadget) {
        Application app = Application.createGadgetApplication((String)uiGadget.getStorageId());
        app.setState(uiGadget.getState());
        app.setProperties(uiGadget.getProperties());
        app.setStorageName(uiGadget.getStorageName());
        return app;
    }

    public static void toContainer(Container model, UIContainer uiContainer) {
        model.setId(uiContainer.getId());
        model.setName(uiContainer.getName());
        model.setTitle(uiContainer.getTitle());
        model.setIcon(uiContainer.getIcon());
        model.setDescription(uiContainer.getDescription());
        model.setHeight(uiContainer.getHeight());
        model.setWidth(uiContainer.getWidth());
        model.setTemplate(uiContainer.getTemplate());
        model.setFactoryId(uiContainer.getFactoryId());
        model.setAccessPermissions(uiContainer.getAccessPermissions());
        List uiChildren = uiContainer.getChildren();
        if (uiChildren == null) {
            return;
        }
        ArrayList<ModelObject> children = new ArrayList<ModelObject>();
        for (UIComponent child : uiChildren) {
            ModelObject component = PortalDataMapper.buildModelObject(child);
            if (component == null) continue;
            children.add(component);
        }
        model.setChildren(children);
    }

    private static <S> Application<S> toPortletModel(UIPortlet<S, ?> uiPortlet) {
        Application model;
        PortletState<S> state = uiPortlet.getState();
        ApplicationType<S> type = state.getApplicationType();
        if (type == ApplicationType.PORTLET) {
            model = Application.createPortletApplication((String)uiPortlet.getStorageId());
        } else if (type == ApplicationType.GADGET) {
            model = Application.createGadgetApplication((String)uiPortlet.getStorageId());
        } else if (type == ApplicationType.WSRP_PORTLET) {
            model = Application.createWSRPApplication((String)uiPortlet.getStorageId());
        } else {
            throw new AssertionError();
        }
        model.setStorageName(uiPortlet.getStorageName());
        model.setState(state.getApplicationState());
        model.setTitle(uiPortlet.getTitle());
        model.setWidth(uiPortlet.getWidth());
        model.setHeight(uiPortlet.getHeight());
        model.setDescription(uiPortlet.getDescription());
        model.setShowInfoBar(uiPortlet.getShowInfoBar());
        model.setShowApplicationState(uiPortlet.getShowWindowState());
        model.setShowApplicationMode(uiPortlet.getShowPortletMode());
        model.setDescription(uiPortlet.getDescription());
        model.setIcon(uiPortlet.getIcon());
        model.setProperties(uiPortlet.getProperties());
        model.setTheme(uiPortlet.getTheme());
        model.setAccessPermissions(uiPortlet.getAccessPermissions());
        model.setModifiable(uiPortlet.isModifiable());
        return model;
    }

    private static Container toContainer(UIContainer uiContainer) {
        Container model = new Container(uiContainer.getStorageId());
        PortalDataMapper.toContainer(model, uiContainer);
        return model;
    }

    public static Page toPageModel(UIPage uiPage) {
        Page model = new Page(uiPage.getStorageId());
        PortalDataMapper.toContainer((Container)model, uiPage);
        model.setOwnerId(uiPage.getSiteKey().getName());
        model.setOwnerType(uiPage.getSiteKey().getTypeName());
        model.setIcon(uiPage.getIcon());
        model.setPageId(uiPage.getPageId());
        model.setTitle(uiPage.getTitle());
        model.setAccessPermissions(uiPage.getAccessPermissions());
        model.setEditPermission(uiPage.getEditPermission());
        model.setFactoryId(uiPage.getFactoryId());
        model.setShowMaxWindow(Boolean.valueOf(uiPage.isShowMaxWindow()));
        model.setModifiable(uiPage.isModifiable());
        return model;
    }

    private static PortalConfig toPortal(UIPortal uiPortal) {
        PortalConfig model = new PortalConfig(uiPortal.getSiteType().getName(), uiPortal.getName(), uiPortal.getStorageId());
        model.setAccessPermissions(uiPortal.getAccessPermissions());
        model.setEditPermission(uiPortal.getEditPermission());
        model.setLabel(uiPortal.getLabel());
        model.setDescription(uiPortal.getDescription());
        model.setLocale(uiPortal.getLocale());
        model.setSkin(uiPortal.getSkin());
        model.setModifiable(uiPortal.isModifiable());
        model.setProperties(uiPortal.getProperties());
        model.setPortalLayout(new Container());
        List children = uiPortal.getChildren();
        if (children == null) {
            return model;
        }
        ArrayList<ModelObject> newChildren = new ArrayList<ModelObject>();
        for (UIComponent child : children) {
            ModelObject component = PortalDataMapper.buildModelObject(child);
            if (component == null) continue;
            newChildren.add(component);
        }
        model.getPortalLayout().setChildren(newChildren);
        return model;
    }

    public static void toUIGadget(UIGadget uiGadget, Application<Gadget> model) throws Exception {
        uiGadget.setProperties(model.getProperties());
        uiGadget.setState((ApplicationState<Gadget>)model.getState());
    }

    private static <S> void toUIPortlet(UIPortlet<S, ?> uiPortlet, Application<S> model) throws Exception {
        PortletState portletState = new PortletState(model.getState(), model.getType());
        uiPortlet.setWidth(model.getWidth());
        uiPortlet.setHeight(model.getHeight());
        uiPortlet.setState(portletState);
        uiPortlet.setTitle(model.getTitle());
        uiPortlet.setIcon(model.getIcon());
        uiPortlet.setDescription(model.getDescription());
        uiPortlet.setShowInfoBar(model.getShowInfoBar());
        uiPortlet.setShowWindowState(model.getShowApplicationState());
        uiPortlet.setShowPortletMode(model.getShowApplicationMode());
        uiPortlet.setProperties(model.getProperties());
        uiPortlet.setTheme(model.getTheme());
        if (model.getAccessPermissions() != null) {
            uiPortlet.setAccessPermissions(model.getAccessPermissions());
        }
        uiPortlet.setModifiable(model.isModifiable());
        Portlet portlet = uiPortlet.getProducedOfferedPortlet();
        if (portlet == null || portlet.getInfo() == null) {
            return;
        }
        PortletInfo portletInfo = portlet.getInfo();
        Set modes = portletInfo.getCapabilities().getModes(MediaType.create((String)"text/html"));
        ArrayList<String> supportModes = new ArrayList<String>();
        for (ModeInfo modeInfo : modes) {
            String modeName = modeInfo.getModeName().toLowerCase();
            if ("config".equals(modeInfo.getModeName())) {
                supportModes.add(modeName);
                continue;
            }
            supportModes.add(modeName);
        }
        if (supportModes.size() > 1) {
            supportModes.remove("view");
        }
        uiPortlet.setSupportModes(supportModes);
    }

    public static void toUIContainer(UIContainer uiContainer, Container model) throws Exception {
        PortalDataMapper.toUIContainer(uiContainer, model, model instanceof Dashboard);
    }

    private static void toUIContainer(UIContainer uiContainer, Container model, boolean dashboard) throws Exception {
        ArrayList children;
        uiContainer.setStorageId(model.getStorageId());
        uiContainer.setId(model.getId());
        uiContainer.setWidth(model.getWidth());
        uiContainer.setHeight(model.getHeight());
        uiContainer.setTitle(model.getTitle());
        uiContainer.setIcon(model.getIcon());
        uiContainer.setDescription(model.getDescription());
        uiContainer.setFactoryId(model.getFactoryId());
        uiContainer.setName(model.getName());
        uiContainer.setTemplate(model.getTemplate());
        if (model.getAccessPermissions() != null) {
            uiContainer.setAccessPermissions(model.getAccessPermissions());
        }
        if ((children = model.getChildren()) == null) {
            return;
        }
        for (ModelObject child : children) {
            PortalDataMapper.buildUIContainer(uiContainer, child, dashboard);
        }
    }

    public static void toUIPage(UIPage uiPage, Page model) throws Exception {
        PortalDataMapper.toUIContainer(uiPage, (Container)model);
        uiPage.setSiteKey(new SiteKey(model.getOwnerType(), model.getOwnerId()));
        uiPage.setIcon(model.getIcon());
        uiPage.setAccessPermissions(model.getAccessPermissions());
        uiPage.setEditPermission(model.getEditPermission());
        uiPage.setFactoryId(model.getFactoryId());
        uiPage.setPageId(model.getPageId());
        uiPage.setTitle(model.getTitle());
        uiPage.setShowMaxWindow(model.isShowMaxWindow());
        uiPage.setModifiable(model.isModifiable());
        ArrayList portlets = new ArrayList();
        uiPage.findComponentOfType(portlets, UIPortlet.class);
        for (UIPortlet portlet : portlets) {
            portlet.setPortletInPortal(false);
        }
    }

    public static void toUIPortal(UIPortal uiPortal, PortalConfig model) throws Exception {
        uiPortal.setSiteKey(new SiteKey(model.getType(), model.getName()));
        uiPortal.setStorageId(model.getStorageId());
        uiPortal.setName(model.getName());
        uiPortal.setId("UIPortal");
        uiPortal.setModifiable(model.isModifiable());
        uiPortal.setLabel(model.getLabel());
        uiPortal.setDescription(model.getDescription());
        uiPortal.setLocale(model.getLocale());
        uiPortal.setSkin(model.getSkin());
        uiPortal.setAccessPermissions(model.getAccessPermissions());
        uiPortal.setEditPermission(model.getEditPermission());
        uiPortal.setProperties(model.getProperties());
        ArrayList children = model.getPortalLayout().getChildren();
        if (children != null) {
            for (ModelObject child : children) {
                PortalDataMapper.buildUIContainer(uiPortal, child, false);
            }
        }
    }

    private static void buildUIContainer(UIContainer uiContainer, Object model, boolean dashboard) throws Exception {
        Object uiComponent = null;
        PortalRequestContext context = Util.getPortalRequestContext();
        if (model instanceof SiteBody) {
            UISiteBody uiSiteBody = (UISiteBody)uiContainer.createUIComponent(context, UISiteBody.class, null, null);
            uiSiteBody.setStorageId(((SiteBody)model).getStorageId());
            uiComponent = uiSiteBody;
        } else if (model instanceof PageBody) {
            UIPageBody uiPageBody = (UIPageBody)uiContainer.createUIComponent(context, UIPageBody.class, null, null);
            uiPageBody.setStorageId(((PageBody)model).getStorageId());
            uiComponent = uiPageBody;
        } else if (model instanceof Application) {
            Application application = (Application)model;
            if (dashboard && application.getType() == ApplicationType.GADGET) {
                Application ga = application;
                UIGadget uiGadget = (UIGadget)uiContainer.createUIComponent(context, UIGadget.class, null, null);
                uiGadget.setStorageId(application.getStorageId());
                PortalDataMapper.toUIGadget(uiGadget, (Application<Gadget>)ga);
                uiComponent = uiGadget;
            } else {
                UIPortlet uiPortlet = (UIPortlet)uiContainer.createUIComponent(context, UIPortlet.class, null, null);
                uiPortlet.setStorageId(application.getStorageId());
                if (application.getStorageName() != null) {
                    uiPortlet.setStorageName(application.getStorageName());
                }
                PortalDataMapper.toUIPortlet(uiPortlet, application);
                uiComponent = uiPortlet;
            }
        } else if (model instanceof Container) {
            Container container = (Container)model;
            UIContainer uiTempContainer = "TabContainer".equals(container.getFactoryId()) ? (UIContainer)uiContainer.createUIComponent(context, UITabContainer.class, null, null) : ("ColumnContainer".equals(container.getFactoryId()) ? (UIContainer)uiContainer.createUIComponent(context, UIColumnContainer.class, null, null) : (UIContainer)uiContainer.createUIComponent(context, UIContainer.class, null, null));
            PortalDataMapper.toUIContainer(uiTempContainer, (Container)model, dashboard);
            uiComponent = uiTempContainer;
        }
        uiContainer.addChild((UIComponent)uiComponent);
    }
}

