/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.query.AndQueryNode;
import org.exoplatform.services.jcr.impl.core.query.DefaultQueryNodeVisitor;
import org.exoplatform.services.jcr.impl.core.query.DerefQueryNode;
import org.exoplatform.services.jcr.impl.core.query.ExactQueryNode;
import org.exoplatform.services.jcr.impl.core.query.LocationStepQueryNode;
import org.exoplatform.services.jcr.impl.core.query.NodeTypeQueryNode;
import org.exoplatform.services.jcr.impl.core.query.NotQueryNode;
import org.exoplatform.services.jcr.impl.core.query.OrQueryNode;
import org.exoplatform.services.jcr.impl.core.query.OrderQueryNode;
import org.exoplatform.services.jcr.impl.core.query.PathQueryNode;
import org.exoplatform.services.jcr.impl.core.query.PropertyFunctionQueryNode;
import org.exoplatform.services.jcr.impl.core.query.PropertyTypeRegistry;
import org.exoplatform.services.jcr.impl.core.query.QueryNode;
import org.exoplatform.services.jcr.impl.core.query.QueryNodeVisitor;
import org.exoplatform.services.jcr.impl.core.query.QueryRootNode;
import org.exoplatform.services.jcr.impl.core.query.RelationQueryNode;
import org.exoplatform.services.jcr.impl.core.query.TextsearchQueryNode;
import org.exoplatform.services.jcr.impl.core.query.lucene.CaseTermQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.ChildAxisQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.DateField;
import org.exoplatform.services.jcr.impl.core.query.lucene.DerefQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.DescendantSelfAxisQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.DoubleField;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexFormatVersion;
import org.exoplatform.services.jcr.impl.core.query.lucene.JcrQueryParser;
import org.exoplatform.services.jcr.impl.core.query.lucene.JcrTermQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.LongField;
import org.exoplatform.services.jcr.impl.core.query.lucene.MatchAllDocsQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.NameQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.NamespaceMappings;
import org.exoplatform.services.jcr.impl.core.query.lucene.NotQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.ParentAxisQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.RangeQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.SimilarityQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.SynonymProvider;
import org.exoplatform.services.jcr.impl.core.query.lucene.Util;
import org.exoplatform.services.jcr.impl.core.query.lucene.VirtualTableResolver;
import org.exoplatform.services.jcr.impl.core.query.lucene.WildcardQuery;
import org.exoplatform.services.jcr.impl.util.ISO9075;
import org.exoplatform.services.jcr.impl.xml.XMLChar;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneQueryBuilder
implements QueryNodeVisitor {
    private static final String NS_FN_PREFIX = "fn";
    public static final String NS_FN_URI = "http://www.w3.org/2005/xpath-functions";
    private static final String NS_FN_OLD_PREFIX = "fn_old";
    public static final String NS_FN_OLD_URI = "http://www.w3.org/2004/10/xpath-functions";
    private static final String NS_XS_PREFIX = "xs";
    public static final String NS_XS_URI = "http://www.w3.org/2001/XMLSchema";
    private static final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.LuceneQueryBuilder");
    private final QueryRootNode root;
    private final SessionImpl session;
    private final ItemDataConsumer sharedItemMgr;
    private final NamespaceMappings nsMappings;
    private final LocationFactory resolver;
    private final Analyzer analyzer;
    private final PropertyTypeRegistry propRegistry;
    private final SynonymProvider synonymProvider;
    private final IndexFormatVersion indexFormatVersion;
    private final List exceptions = new ArrayList();
    private final NodeTypeDataManager nodeTypeDataManager;
    private final VirtualTableResolver<Query> virtualTableResolver;

    private LuceneQueryBuilder(QueryRootNode root, SessionImpl session, ItemDataConsumer sharedItemMgr, NamespaceMappings nsMappings, Analyzer analyzer, PropertyTypeRegistry propReg, SynonymProvider synonymProvider, IndexFormatVersion indexFormatVersion, VirtualTableResolver<Query> virtualTableResolver) throws RepositoryException {
        this.root = root;
        this.session = session;
        this.sharedItemMgr = sharedItemMgr;
        this.nsMappings = nsMappings;
        this.analyzer = analyzer;
        this.propRegistry = propReg;
        this.synonymProvider = synonymProvider;
        this.indexFormatVersion = indexFormatVersion;
        this.virtualTableResolver = virtualTableResolver;
        this.nodeTypeDataManager = session.getWorkspace().getNodeTypesHolder();
        this.resolver = new LocationFactory(nsMappings);
    }

    public static Query createQuery(QueryRootNode root, SessionImpl session, ItemDataConsumer sharedItemMgr, NamespaceMappings nsMappings, Analyzer analyzer, PropertyTypeRegistry propReg, SynonymProvider synonymProvider, IndexFormatVersion indexFormatVersion, VirtualTableResolver<Query> virtualTableResolver) throws RepositoryException {
        LuceneQueryBuilder builder = new LuceneQueryBuilder(root, session, sharedItemMgr, nsMappings, analyzer, propReg, synonymProvider, indexFormatVersion, virtualTableResolver);
        Query q = builder.createLuceneQuery();
        if (builder.exceptions.size() > 0) {
            StringBuffer msg = new StringBuffer();
            Iterator it = builder.exceptions.iterator();
            while (it.hasNext()) {
                msg.append(it.next().toString()).append('\n');
            }
            throw new RepositoryException("Exception building query: " + msg.toString());
        }
        return q;
    }

    private Query createLuceneQuery() throws RepositoryException {
        return (Query)this.root.accept(this, null);
    }

    @Override
    public Object visit(QueryRootNode node, Object data) throws RepositoryException {
        BooleanQuery root;
        BooleanQuery wrapped = root = new BooleanQuery();
        if (node.getLocationNode() != null) {
            wrapped = (Query)node.getLocationNode().accept(this, root);
        }
        return wrapped;
    }

    @Override
    public Object visit(OrQueryNode node, Object data) throws RepositoryException {
        BooleanQuery orQuery = new BooleanQuery();
        Object[] result = node.acceptOperands(this, null);
        for (int i = 0; i < result.length; ++i) {
            Query operand = (Query)result[i];
            orQuery.add(operand, BooleanClause.Occur.SHOULD);
        }
        return orQuery;
    }

    @Override
    public Object visit(AndQueryNode node, Object data) throws RepositoryException {
        Object[] result = node.acceptOperands(this, null);
        if (result.length == 0) {
            return null;
        }
        BooleanQuery andQuery = new BooleanQuery();
        for (int i = 0; i < result.length; ++i) {
            Query operand = (Query)result[i];
            andQuery.add(operand, BooleanClause.Occur.MUST);
        }
        return andQuery;
    }

    @Override
    public Object visit(NotQueryNode node, Object data) throws RepositoryException {
        Object[] result = node.acceptOperands(this, null);
        if (result.length == 0) {
            return data;
        }
        BooleanQuery b = new BooleanQuery();
        for (int i = 0; i < result.length; ++i) {
            b.add((Query)result[i], BooleanClause.Occur.SHOULD);
        }
        return new NotQuery((Query)b);
    }

    @Override
    public Object visit(ExactQueryNode node, Object data) {
        String field = "";
        String value = "";
        try {
            field = this.resolver.createJCRName(node.getPropertyName()).getAsString();
            value = this.resolver.createJCRName(node.getValue()).getAsString();
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        return new JcrTermQuery(new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, value)));
    }

    @Override
    public Object visit(NodeTypeQueryNode node, Object data) {
        try {
            return this.virtualTableResolver.resolve(node.getValue(), true);
        }
        catch (InvalidQueryException e1) {
            this.exceptions.add(e1);
        }
        catch (RepositoryException e1) {
            this.exceptions.add(e1);
        }
        return new BooleanQuery();
    }

    @Override
    public Object visit(TextsearchQueryNode node, Object data) {
        try {
            String fieldname;
            QPath relPath = node.getRelativePath();
            if (relPath == null || !node.getReferencesProperty()) {
                fieldname = FieldNames.FULLTEXT;
            } else {
                fieldname = this.resolver.createJCRName(relPath.getName()).getAsString();
                int idx = fieldname.indexOf(58);
                fieldname = fieldname.substring(0, idx + 1) + "FULL:" + fieldname.substring(idx + 1);
            }
            JcrQueryParser parser = new JcrQueryParser(fieldname, this.analyzer, this.synonymProvider);
            Query context = parser.parse(node.getQuery());
            if (!(relPath == null || node.getReferencesProperty() && relPath.getEntries().length <= 1)) {
                QPathEntry[] elements = relPath.getEntries();
                for (int i = elements.length - 1; i >= 0; --i) {
                    QPathEntry name = null;
                    if (!elements[i].equals((Object)RelationQueryNode.STAR_NAME_TEST)) {
                        name = elements[i];
                    }
                    if (name != null && (node.getReferencesProperty() && i == elements.length - 2 || !node.getReferencesProperty() && i == elements.length - 1)) {
                        NameQuery q = new NameQuery(name, this.indexFormatVersion, this.nsMappings);
                        BooleanQuery and = new BooleanQuery();
                        and.add((Query)q, BooleanClause.Occur.MUST);
                        and.add(context, BooleanClause.Occur.MUST);
                        context = and;
                        continue;
                    }
                    if ((!node.getReferencesProperty() || i >= elements.length - 2) && (node.getReferencesProperty() || i >= elements.length - 1)) continue;
                    context = new ParentAxisQuery(context, name, this.indexFormatVersion, this.nsMappings);
                }
                context = new ParentAxisQuery(context, null, this.indexFormatVersion, this.nsMappings);
            }
            return context;
        }
        catch (NamespaceException e) {
            this.exceptions.add(e);
        }
        catch (ParseException e) {
            this.exceptions.add(e);
        }
        catch (RepositoryException e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public Object visit(PathQueryNode node, Object data) throws RepositoryException {
        BooleanQuery constraint;
        JcrTermQuery context = null;
        LocationStepQueryNode[] steps = node.getPathSteps();
        if (steps.length > 0) {
            if (node.isAbsolute() && !steps[0].getIncludeDescendants()) {
                InternalQName nameTest = steps[0].getNameTest();
                if (nameTest == null) {
                    context = new JcrTermQuery(new Term(FieldNames.UUID, "00exo0jcr0root0uuid0000000000000"));
                } else if (nameTest.getName().length() == 0) {
                    context = new JcrTermQuery(new Term(FieldNames.UUID, "00exo0jcr0root0uuid0000000000000"));
                } else {
                    BooleanQuery and = new BooleanQuery();
                    and.add((Query)new JcrTermQuery(new Term(FieldNames.UUID, "00exo0jcr0root0uuid0000000000000")), BooleanClause.Occur.MUST);
                    and.add((Query)new NameQuery(nameTest, this.indexFormatVersion, this.nsMappings), BooleanClause.Occur.MUST);
                    context = and;
                }
                LocationStepQueryNode[] tmp = new LocationStepQueryNode[steps.length - 1];
                System.arraycopy(steps, 1, tmp, 0, steps.length - 1);
                steps = tmp;
            } else {
                context = new JcrTermQuery(new Term(FieldNames.UUID, "00exo0jcr0root0uuid0000000000000"));
            }
        } else {
            this.exceptions.add(new InvalidQueryException("Number of location steps must be > 0"));
        }
        for (int i = 0; i < steps.length; ++i) {
            context = (Query)steps[i].accept(this, (Object)context);
        }
        if (data instanceof BooleanQuery && (constraint = (BooleanQuery)data).getClauses().length > 0) {
            constraint.add((Query)context, BooleanClause.Occur.MUST);
            context = constraint;
        }
        return context;
    }

    @Override
    public Object visit(LocationStepQueryNode node, Object data) throws RepositoryException {
        Query context = (Query)data;
        BooleanQuery andQuery = new BooleanQuery();
        if (context == null) {
            this.exceptions.add(new IllegalArgumentException("Unsupported query"));
        }
        Object[] predicates = node.acceptOperands(this, data);
        for (int i = 0; i < predicates.length; ++i) {
            andQuery.add((Query)predicates[i], BooleanClause.Occur.MUST);
        }
        QueryNode[] pred = node.getPredicates();
        for (int i = 0; i < pred.length; ++i) {
            RelationQueryNode pos;
            if (pred[i].getType() != 2 || (pos = (RelationQueryNode)pred[i]).getValueType() != 6) continue;
            node.setIndex(pos.getPositionValue());
        }
        NameQuery nameTest = null;
        if (node.getNameTest() != null) {
            nameTest = new NameQuery(node.getNameTest(), this.indexFormatVersion, this.nsMappings);
        }
        if (node.getIncludeDescendants()) {
            PathQueryNode pathNode;
            if (nameTest != null) {
                andQuery.add((Query)new DescendantSelfAxisQuery(context, (Query)nameTest, false), BooleanClause.Occur.MUST);
            } else if (predicates.length > 0) {
                pathNode = (PathQueryNode)node.getParent();
                if (pathNode.getPathSteps()[0] != node) {
                    DescendantSelfAxisQuery subQuery = new DescendantSelfAxisQuery(context, (Query)andQuery, false);
                    andQuery = new BooleanQuery();
                    andQuery.add((Query)subQuery, BooleanClause.Occur.MUST);
                }
            } else {
                pathNode = (PathQueryNode)node.getParent();
                if (pathNode.getPathSteps()[0] != node) {
                    if (node.getIndex() == -2147483647) {
                        context = new DescendantSelfAxisQuery(context, false);
                        andQuery.add(context, BooleanClause.Occur.MUST);
                    } else {
                        context = new DescendantSelfAxisQuery(context, true);
                        andQuery.add((Query)new ChildAxisQuery(this.sharedItemMgr, context, null, node.getIndex(), this.indexFormatVersion, this.nsMappings), BooleanClause.Occur.MUST);
                    }
                } else {
                    andQuery.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
                }
            }
        } else if (nameTest != null) {
            andQuery.add((Query)new ChildAxisQuery(this.sharedItemMgr, context, nameTest.getName(), node.getIndex(), this.indexFormatVersion, this.nsMappings), BooleanClause.Occur.MUST);
        } else {
            andQuery.add((Query)new ChildAxisQuery(this.sharedItemMgr, context, null, node.getIndex(), this.indexFormatVersion, this.nsMappings), BooleanClause.Occur.MUST);
        }
        return andQuery;
    }

    @Override
    public Object visit(DerefQueryNode node, Object data) throws RepositoryException {
        Query context = (Query)data;
        if (context == null) {
            this.exceptions.add(new IllegalArgumentException("Unsupported query"));
        }
        try {
            String refProperty = this.resolver.createJCRName(node.getRefProperty()).getAsString();
            if (node.getIncludeDescendants()) {
                Query refPropQuery = Util.createMatchAllQuery(refProperty, this.indexFormatVersion);
                context = new DescendantSelfAxisQuery(context, refPropQuery, false);
            }
            context = new DerefQuery(context, refProperty, node.getNameTest(), this.indexFormatVersion, this.nsMappings);
            Object[] predicates = node.acceptOperands(this, data);
            if (predicates.length > 0) {
                BooleanQuery andQuery = new BooleanQuery();
                for (int i = 0; i < predicates.length; ++i) {
                    andQuery.add((Query)predicates[i], BooleanClause.Occur.MUST);
                }
                andQuery.add(context, BooleanClause.Occur.MUST);
                context = andQuery;
            }
        }
        catch (NamespaceException e) {
            this.exceptions.add(e);
        }
        return context;
    }

    @Override
    public Object visit(RelationQueryNode node, Object data) throws RepositoryException {
        Query query;
        String[] stringValues = new String[1];
        switch (node.getValueType()) {
            case 0: {
                break;
            }
            case 4: {
                stringValues[0] = DateField.dateToString(node.getDateValue());
                break;
            }
            case 2: {
                stringValues[0] = DoubleField.doubleToString(node.getDoubleValue());
                break;
            }
            case 1: {
                stringValues[0] = LongField.longToString(node.getLongValue());
                break;
            }
            case 3: {
                if (node.getOperation() == 12 || node.getOperation() == 11 || node.getOperation() == 14 || node.getOperation() == 13) {
                    InternalQName propertyName = node.getRelativePath().getName();
                    stringValues = this.getStringValues(propertyName, node.getStringValue());
                    break;
                }
                stringValues[0] = node.getStringValue();
                break;
            }
            case 6: {
                return null;
            }
            default: {
                throw new IllegalArgumentException("Unknown relation type: " + node.getValueType());
            }
        }
        if (node.getRelativePath() == null && node.getOperation() != 28 && node.getOperation() != 29) {
            this.exceptions.add(new InvalidQueryException("@* not supported in predicate"));
            return data;
        }
        final int[] transform = new int[]{0};
        node.acceptOperands(new DefaultQueryNodeVisitor(){

            public Object visit(PropertyFunctionQueryNode node, Object data) {
                if (node.getFunctionName().equals("lower-case")) {
                    transform[0] = 1;
                } else if (node.getFunctionName().equals("upper-case")) {
                    transform[0] = 2;
                }
                return data;
            }
        }, null);
        QPath relPath = node.getRelativePath();
        InternalQName propName = node.getOperation() == 28 ? Constants.JCR_PRIMARYTYPE : relPath.getName();
        String field = "";
        try {
            field = this.resolver.createJCRName(propName).getAsString();
        }
        catch (NamespaceException e) {
            this.exceptions.add(e);
        }
        if (propName.getNamespace().equals(NS_FN_URI) && propName.getName().equals("name()")) {
            if (node.getValueType() != 3) {
                this.exceptions.add(new InvalidQueryException("Name function can only be used in conjunction with a string literal"));
                return data;
            }
            if (node.getOperation() != 11 && node.getOperation() != 12) {
                this.exceptions.add(new InvalidQueryException("Name function can only be used in conjunction with an equals operator"));
                return data;
            }
            if (XMLChar.isValidName(node.getStringValue())) {
                try {
                    InternalQName n = this.session.getLocationFactory().parseJCRName(ISO9075.decode(node.getStringValue())).getInternalName();
                    query = new NameQuery(n, this.indexFormatVersion, this.nsMappings);
                }
                catch (RepositoryException e) {
                    this.exceptions.add(e);
                    return data;
                }
            } else {
                query = new BooleanQuery();
            }
        } else {
            switch (node.getOperation()) {
                case 11: 
                case 12: {
                    BooleanQuery or = new BooleanQuery();
                    for (int i = 0; i < stringValues.length; ++i) {
                        Term t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]));
                        Object q = transform[0] == 2 ? new CaseTermQuery.Upper(t) : (transform[0] == 1 ? new CaseTermQuery.Lower(t) : new JcrTermQuery(t));
                        or.add((Query)q, BooleanClause.Occur.SHOULD);
                    }
                    query = or;
                    if (node.getOperation() != 11) break;
                    query = this.createSingleValueConstraint((Query)or, field);
                    break;
                }
                case 19: 
                case 20: {
                    Term upper;
                    BooleanQuery or = new BooleanQuery();
                    for (int i = 0; i < stringValues.length; ++i) {
                        Term lower = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]));
                        upper = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, "\uffff"));
                        or.add((Query)new RangeQuery(lower, upper, true, transform[0]), BooleanClause.Occur.SHOULD);
                    }
                    query = or;
                    if (node.getOperation() != 19) break;
                    query = this.createSingleValueConstraint((Query)or, field);
                    break;
                }
                case 17: 
                case 18: {
                    Term upper;
                    BooleanQuery or = new BooleanQuery();
                    for (int i = 0; i < stringValues.length; ++i) {
                        Term lower = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]));
                        upper = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, "\uffff"));
                        or.add((Query)new RangeQuery(lower, upper, false, transform[0]), BooleanClause.Occur.SHOULD);
                    }
                    query = or;
                    if (node.getOperation() != 17) break;
                    query = this.createSingleValueConstraint((Query)or, field);
                    break;
                }
                case 21: 
                case 22: {
                    Term upper;
                    BooleanQuery or = new BooleanQuery();
                    for (int i = 0; i < stringValues.length; ++i) {
                        Term lower = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, ""));
                        upper = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]));
                        or.add((Query)new RangeQuery(lower, upper, true, transform[0]), BooleanClause.Occur.SHOULD);
                    }
                    query = or;
                    if (node.getOperation() != 21) break;
                    query = this.createSingleValueConstraint(query, field);
                    break;
                }
                case 23: {
                    if (stringValues[0].equals("%")) {
                        query = Util.createMatchAllQuery(field, this.indexFormatVersion);
                        break;
                    }
                    query = new WildcardQuery(FieldNames.PROPERTIES, field, stringValues[0], transform[0]);
                    break;
                }
                case 15: 
                case 16: {
                    Term upper;
                    BooleanQuery or = new BooleanQuery();
                    for (int i = 0; i < stringValues.length; ++i) {
                        Term lower = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, ""));
                        upper = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]));
                        or.add((Query)new RangeQuery(lower, upper, false, transform[0]), BooleanClause.Occur.SHOULD);
                    }
                    query = or;
                    if (node.getOperation() != 15) break;
                    query = this.createSingleValueConstraint((Query)or, field);
                    break;
                }
                case 13: {
                    Term t;
                    BooleanQuery notQuery = new BooleanQuery();
                    notQuery.add(Util.createMatchAllQuery(field, this.indexFormatVersion), BooleanClause.Occur.SHOULD);
                    for (int i = 0; i < stringValues.length; ++i) {
                        t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]));
                        Object q = transform[0] == 2 ? new CaseTermQuery.Upper(t) : (transform[0] == 1 ? new CaseTermQuery.Lower(t) : new JcrTermQuery(t));
                        notQuery.add((Query)q, BooleanClause.Occur.MUST_NOT);
                    }
                    notQuery.add((Query)new JcrTermQuery(new Term(FieldNames.MVP, field)), BooleanClause.Occur.MUST_NOT);
                    query = notQuery;
                    break;
                }
                case 14: {
                    Term t;
                    BooleanQuery notQuery = new BooleanQuery();
                    notQuery.add(Util.createMatchAllQuery(field, this.indexFormatVersion), BooleanClause.Occur.SHOULD);
                    for (int i = 0; i < stringValues.length; ++i) {
                        t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]));
                        NotQuery svp = new NotQuery((Query)new JcrTermQuery(new Term(FieldNames.MVP, field)));
                        BooleanQuery and = new BooleanQuery();
                        Object q = transform[0] == 2 ? new CaseTermQuery.Upper(t) : (transform[0] == 1 ? new CaseTermQuery.Lower(t) : new JcrTermQuery(t));
                        and.add((Query)q, BooleanClause.Occur.MUST);
                        and.add((Query)svp, BooleanClause.Occur.MUST);
                        notQuery.add((Query)and, BooleanClause.Occur.MUST_NOT);
                    }
                    query = notQuery;
                    break;
                }
                case 26: {
                    query = new NotQuery(Util.createMatchAllQuery(field, this.indexFormatVersion));
                    break;
                }
                case 28: {
                    String uuid = "x";
                    try {
                        QPath path = this.resolver.parseJCRPath(node.getStringValue()).getInternalPath();
                        NodeData parent = (NodeData)this.sharedItemMgr.getItemData("00exo0jcr0root0uuid0000000000000");
                        if (path.equals(Constants.ROOT_PATH)) {
                            uuid = "00exo0jcr0root0uuid0000000000000";
                        } else {
                            QPathEntry[] relPathEntries = path.getRelPath(path.getDepth());
                            ItemData item = parent;
                            for (int i = 0; i < relPathEntries.length && (item = this.sharedItemMgr.getItemData(parent, relPathEntries[i], ItemType.UNKNOWN)) != null; ++i) {
                                if (item.isNode()) {
                                    parent = (NodeData)item;
                                    continue;
                                }
                                if (i >= relPathEntries.length - 1) continue;
                                throw new IllegalPathException("Path can not contains a property as the intermediate element");
                            }
                            uuid = item.getIdentifier();
                        }
                    }
                    catch (RepositoryException e) {
                        this.exceptions.add(e);
                    }
                    query = new SimilarityQuery(uuid, this.analyzer);
                    break;
                }
                case 27: {
                    query = Util.createMatchAllQuery(field, this.indexFormatVersion);
                    break;
                }
                case 29: {
                    query = Util.createMatchAllQuery(field, this.indexFormatVersion);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown relation operation: " + node.getOperation());
                }
            }
        }
        if (relPath != null && relPath.getEntries().length > 1) {
            QPathEntry[] elements = relPath.getEntries();
            for (int i = elements.length - 2; i >= 0; --i) {
                QPathEntry name = null;
                if (!elements[i].equals((Object)RelationQueryNode.STAR_NAME_TEST)) {
                    name = elements[i];
                }
                if (i == elements.length - 2) {
                    if (name == null) continue;
                    NameQuery nameTest = new NameQuery(name, this.indexFormatVersion, this.nsMappings);
                    BooleanQuery and = new BooleanQuery();
                    and.add(query, BooleanClause.Occur.MUST);
                    and.add((Query)nameTest, BooleanClause.Occur.MUST);
                    query = and;
                    continue;
                }
                query = new ParentAxisQuery(query, name, this.indexFormatVersion, this.nsMappings);
            }
            query = new ParentAxisQuery(query, null, this.indexFormatVersion, this.nsMappings);
        }
        return query;
    }

    @Override
    public Object visit(OrderQueryNode node, Object data) {
        return data;
    }

    @Override
    public Object visit(PropertyFunctionQueryNode node, Object data) {
        return data;
    }

    private Query createSingleValueConstraint(Query q, String propName) {
        JcrTermQuery mvp = new JcrTermQuery(new Term(FieldNames.MVP, propName));
        NotQuery svp = new NotQuery((Query)mvp);
        BooleanQuery and = new BooleanQuery();
        and.add(q, BooleanClause.Occur.MUST);
        and.add((Query)svp, BooleanClause.Occur.MUST);
        return and;
    }

    private String[] getStringValues(InternalQName propertyName, String literal) {
        PropertyTypeRegistry.TypeMapping[] types = this.propRegistry.getPropertyTypes(propertyName);
        ArrayList<String> values = new ArrayList<String>();
        block25: for (int i = 0; i < types.length; ++i) {
            switch (types[i].type) {
                case 7: {
                    try {
                        InternalQName n = this.session.getLocationFactory().parseJCRName(literal).getInternalName();
                        values.add(this.nsMappings.translateName(n));
                        log.debug((Object)("Coerced " + literal + " into NAME."));
                    }
                    catch (RepositoryException e) {
                        if (types.length != 1) continue block25;
                        log.warn((Object)("Unable to coerce '" + literal + "' into a NAME: " + e.toString()));
                    }
                    catch (IllegalNameException e) {
                        if (types.length != 1) continue block25;
                        log.warn((Object)("Unable to coerce '" + literal + "' into a NAME: " + e.toString()));
                    }
                    continue block25;
                }
                case 8: {
                    try {
                        QPath p = this.session.getLocationFactory().parseJCRPath(literal).getInternalPath();
                        values.add(this.resolver.createJCRPath(p).getAsString(true));
                        log.debug((Object)("Coerced " + literal + " into PATH."));
                    }
                    catch (RepositoryException e) {
                        if (types.length != 1) continue block25;
                        log.warn((Object)("Unable to coerce '" + literal + "' into a PATH: " + e.toString()));
                    }
                    continue block25;
                }
                case 5: {
                    Calendar c = ISO8601.parse((String)literal);
                    if (c != null) {
                        values.add(DateField.timeToString(c.getTimeInMillis()));
                        log.debug((Object)("Coerced " + literal + " into DATE."));
                        continue block25;
                    }
                    if (types.length != 1) continue block25;
                    log.warn((Object)("Unable to coerce '" + literal + "' into a DATE."));
                    continue block25;
                }
                case 4: {
                    try {
                        double d = Double.parseDouble(literal);
                        values.add(DoubleField.doubleToString(d));
                        log.debug((Object)("Coerced " + literal + " into DOUBLE."));
                    }
                    catch (NumberFormatException e) {
                        if (types.length != 1) continue block25;
                        log.warn((Object)("Unable to coerce '" + literal + "' into a DOUBLE: " + e.toString()));
                    }
                    continue block25;
                }
                case 3: {
                    try {
                        long l = Long.parseLong(literal);
                        values.add(LongField.longToString(l));
                        log.debug((Object)("Coerced " + literal + " into LONG."));
                    }
                    catch (NumberFormatException e) {
                        if (types.length != 1) continue block25;
                        log.warn((Object)("Unable to coerce '" + literal + "' into a LONG: " + e.toString()));
                    }
                    continue block25;
                }
                case 1: {
                    values.add(literal);
                    log.debug((Object)("Using literal " + literal + " as is."));
                }
            }
        }
        if (values.size() == 0) {
            values.add(literal);
            if (literal.indexOf(47) > -1) {
                try {
                    QPath p = this.session.getLocationFactory().parseJCRPath(literal).getInternalPath();
                    values.add(this.resolver.createJCRPath(p).getAsString(true));
                    log.debug((Object)("Coerced " + literal + " into PATH."));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (XMLChar.isValidName(literal)) {
                try {
                    InternalQName n = this.session.getLocationFactory().parseJCRName(literal).getInternalName();
                    values.add(this.nsMappings.translateName(n));
                    log.debug((Object)("Coerced " + literal + " into NAME."));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (literal.indexOf(58) > -1) {
                Calendar c = ISO8601.parse((String)literal);
                if (c != null) {
                    values.add(DateField.timeToString(c.getTimeInMillis()));
                    log.debug((Object)("Coerced " + literal + " into DATE."));
                }
            } else {
                try {
                    values.add(LongField.longToString(Long.parseLong(literal)));
                    log.debug((Object)("Coerced " + literal + " into LONG."));
                }
                catch (NumberFormatException e) {
                    try {
                        values.add(DoubleField.doubleToString(Double.parseDouble(literal)));
                        log.debug((Object)("Coerced " + literal + " into DOUBLE."));
                    }
                    catch (NumberFormatException e1) {
                        // empty catch block
                    }
                }
            }
        }
        if (values.size() == 0) {
            values.add(literal);
            log.debug((Object)("Using literal " + literal + " as is."));
        }
        return values.toArray(new String[values.size()]);
    }
}

