/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl.jboss.mru;

import java.io.Serializable;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ExoCacheConfig;
import org.exoplatform.services.cache.ExoCacheInitException;
import org.exoplatform.services.cache.impl.jboss.AbstractExoCache;
import org.exoplatform.services.cache.impl.jboss.AbstractExoCacheCreator;
import org.exoplatform.services.cache.impl.jboss.mru.MRUExoCacheConfig;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.eviction.MRUAlgorithmConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MRUExoCacheCreator
extends AbstractExoCacheCreator {
    public static final String EXPECTED_IMPL = "MRU";

    @Override
    public ExoCache<Serializable, Object> create(ExoCacheConfig config, Cache<Serializable, Object> cache) throws ExoCacheInitException {
        if (config instanceof MRUExoCacheConfig) {
            MRUExoCacheConfig mruConfig = (MRUExoCacheConfig)config;
            return this.create(config, cache, mruConfig.getMaxNodes(), mruConfig.getMinTimeToLive());
        }
        long period = config.getLiveTime();
        return this.create(config, cache, config.getMaxSize(), period > 0L ? period * 1000L : 0L);
    }

    private ExoCache<Serializable, Object> create(ExoCacheConfig config, Cache<Serializable, Object> cache, int maxNodes, long minTimeToLive) throws ExoCacheInitException {
        MRUAlgorithmConfig mru = new MRUAlgorithmConfig(maxNodes);
        mru.setMinTimeToLive(minTimeToLive);
        Fqn<String> rooFqn = this.addEvictionRegion(config, cache, (EvictionAlgorithmConfig)mru);
        return new MRUExoCache(config, cache, rooFqn, mru);
    }

    @Override
    public Class<? extends ExoCacheConfig> getExpectedConfigType() {
        return MRUExoCacheConfig.class;
    }

    @Override
    public String getExpectedImplementation() {
        return EXPECTED_IMPL;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MRUExoCache
    extends AbstractExoCache<Serializable, Object> {
        private final MRUAlgorithmConfig mru;

        public MRUExoCache(ExoCacheConfig config, Cache<Serializable, Object> cache, Fqn<String> rooFqn, MRUAlgorithmConfig mru) {
            super(config, cache, rooFqn);
            this.mru = mru;
        }

        public void setMaxSize(int max) {
            this.mru.setMaxNodes(max);
        }

        public void setLiveTime(long period) {
            this.mru.setMinTimeToLive(period);
        }

        @ManagedName(value="MaxNodes")
        @ManagedDescription(value="This is the maximum number of nodes allowed in this region. 0 denotes immediate expiry, -1 denotes no limit.")
        public int getMaxSize() {
            return this.mru.getMaxNodes();
        }

        @ManagedName(value="MinTimeToLive")
        @ManagedDescription(value="the minimum amount of time a node must be allowed to live after being accessed before it is allowed to be considered for eviction. 0 denotes that this feature is disabled, which is the default value.")
        public long getLiveTime() {
            return this.mru.getMinTimeToLive();
        }
    }
}

